/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.simple;

import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.Dataset;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Quad;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;

public class DatasetGraphView
implements Graph {
    private final boolean unionGraph;
    private final BlankNodeOrIRI namedGraph;
    private final Dataset dataset;

    public DatasetGraphView(Dataset dataset) {
        this.dataset = dataset;
        this.namedGraph = null;
        this.unionGraph = true;
    }

    public DatasetGraphView(Dataset dataset, BlankNodeOrIRI namedGraph) {
        this.dataset = dataset;
        this.namedGraph = namedGraph;
        this.unionGraph = false;
    }

    public void close() throws Exception {
        this.dataset.close();
    }

    public void add(Triple triple) {
        this.dataset.add(this.namedGraph, triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public void add(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        this.dataset.add(this.namedGraph, subject, predicate, object);
    }

    public boolean contains(Triple triple) {
        return this.dataset.contains(this.unionOrNamedGraph(), triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    private Optional<BlankNodeOrIRI> unionOrNamedGraph() {
        if (this.unionGraph) {
            return null;
        }
        return Optional.ofNullable(this.namedGraph);
    }

    public boolean contains(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        return this.dataset.contains(this.unionOrNamedGraph(), subject, predicate, object);
    }

    public void remove(Triple triple) {
        this.dataset.remove(this.unionOrNamedGraph(), triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public void remove(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        this.dataset.remove(this.unionOrNamedGraph(), subject, predicate, object);
    }

    public void clear() {
        this.dataset.remove(this.unionOrNamedGraph(), null, null, null);
    }

    public long size() {
        return this.stream().count();
    }

    public Stream<? extends Triple> stream() {
        return this.stream(null, null, null);
    }

    public Stream<? extends Triple> stream(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        Stream<Triple> stream = this.dataset.stream(this.unionOrNamedGraph(), subject, predicate, object).map(Quad::asTriple);
        if (this.unionGraph) {
            return stream.distinct();
        }
        return stream;
    }
}

