/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.filter.capability;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.opengis.feature.type.Name;

public final class GeometryOperand
implements Name,
Serializable {
    private static final long serialVersionUID = -9006169053542932716L;
    private static final Map<GeometryOperand, GeometryOperand> POOL = new HashMap<GeometryOperand, GeometryOperand>();
    public static final GeometryOperand Envelope = new GeometryOperand("Envelope");
    public static final GeometryOperand Point = new GeometryOperand("Point");
    public static final GeometryOperand LineString = new GeometryOperand("LineString");
    public static final GeometryOperand Polygon = new GeometryOperand("Polygon");
    public static final GeometryOperand ArcByCenterPoint = new GeometryOperand("ArcByCenterPoint");
    public static final GeometryOperand CircleByCenterPoint = new GeometryOperand("CircleByCenterPoint");
    public static final GeometryOperand Arc = new GeometryOperand("Arc");
    public static final GeometryOperand Circle = new GeometryOperand("Circle");
    public static final GeometryOperand ArcByBulge = new GeometryOperand("ArcByBulge");
    public static final GeometryOperand Bezier = new GeometryOperand("Bezier");
    public static final GeometryOperand Clothoid = new GeometryOperand("Clothoid");
    public static final GeometryOperand CubicSpline = new GeometryOperand("CubicSpline");
    public static final GeometryOperand Geodesic = new GeometryOperand("Geodesic");
    public static final GeometryOperand OffsetCurve = new GeometryOperand("OffsetCurve");
    public static final GeometryOperand Triangle = new GeometryOperand("Triangle");
    public static final GeometryOperand PolyhedralSurface = new GeometryOperand("PolyhedralSurface");
    public static final GeometryOperand TriangulatedSurface = new GeometryOperand("TriangulatedSurface");
    public static final GeometryOperand Tin = new GeometryOperand("Tin");
    public static final GeometryOperand Solid = new GeometryOperand("Solid");
    private final String namespaceURI;
    private final String name;

    private GeometryOperand(String name) {
        this("http://www.opengis.net/gml", name);
    }

    private GeometryOperand(String namespaceURI, String name) {
        this.namespaceURI = namespaceURI;
        this.name = name;
        POOL.put(this, this);
    }

    public static GeometryOperand get(String namespaceURI, String name) {
        if (namespaceURI == null || namespaceURI.trim().length() == 0) {
            namespaceURI = "http://www.opengis.net/gml";
        }
        name = name.trim();
        return POOL.get(new GeometryOperand(namespaceURI, name));
    }

    @Override
    public String getLocalPart() {
        return this.name;
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public String getURI() {
        return this.namespaceURI + "/" + this.name;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public String getSeparator() {
        return "#";
    }

    @Override
    public int hashCode() {
        return this.namespaceURI.hashCode() + 37 * this.name.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other != null && other instanceof Name) {
            Name that = (Name)other;
            return this.namespaceURI.equals(that.getNamespaceURI()) && this.name.equals(that.getLocalPart());
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getURI();
    }

    private Object readResolve() throws ObjectStreamException {
        GeometryOperand unique = POOL.get(this);
        return unique != null ? unique : this;
    }
}

