/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.decomposition;

import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyRange;
import org.semanticweb.owlapitools.decomposition.LocalityChecker;
import org.semanticweb.owlapitools.decomposition.SigAccessor;

public class TopEquivalenceEvaluator
extends SigAccessor
implements OWLObjectVisitor {
    boolean isTopEq = false;

    public TopEquivalenceEvaluator(LocalityChecker l) {
        super(l);
    }

    private boolean isBotDistinct(OWLObject c) {
        if (this.isTopEquivalent(c)) {
            return true;
        }
        return c instanceof OWLDatatype;
    }

    private boolean isCardLargerThan(OWLObject c, int n) {
        if (n == 0) {
            return this.isBotDistinct(c);
        }
        if (c instanceof OWLDatatype) {
            return ((OWLDatatype)c).isBuiltIn() && !((OWLDatatype)c).getBuiltInDatatype().isFinite();
        }
        return false;
    }

    private boolean isMinTopEquivalent(int n, OWLPropertyExpression r, OWLPropertyRange c) {
        return n == 0 || this.isTopEquivalent((OWLObject)r) && this.isCardLargerThan((OWLObject)c, n - 1);
    }

    private boolean isMaxTopEquivalent(int n, OWLPropertyExpression r, OWLPropertyRange c) {
        return this.localityChecker.isBotEquivalent((OWLObject)r) || this.localityChecker.isBotEquivalent((OWLObject)c);
    }

    public boolean isTopEquivalent(OWLObject expr) {
        if (expr.isTopEntity()) {
            return true;
        }
        if (expr.isBottomEntity()) {
            return false;
        }
        expr.accept((OWLObjectVisitor)this);
        return this.isTopEq;
    }

    public void visit(OWLClass expr) {
        this.isTopEq = this.getSignature().topCLocal() && !this.getSignature().contains((OWLEntity)expr);
    }

    public void visit(OWLObjectComplementOf expr) {
        this.isTopEq = this.localityChecker.isBotEquivalent((OWLObject)expr.getOperand());
    }

    public void visit(OWLObjectIntersectionOf expr) {
        this.isTopEq = !expr.operands().anyMatch(p -> !this.isTopEquivalent((OWLObject)p));
    }

    public void visit(OWLObjectUnionOf expr) {
        this.isTopEq = expr.operands().anyMatch(this::isTopEquivalent);
    }

    public void visit(OWLObjectOneOf expr) {
        this.isTopEq = false;
    }

    public void visit(OWLObjectHasSelf expr) {
        this.isTopEq = this.isTopEquivalent((OWLObject)expr.getProperty());
    }

    public void visit(OWLObjectHasValue expr) {
        this.isTopEq = this.isTopEquivalent((OWLObject)expr.getProperty());
    }

    public void visit(OWLObjectSomeValuesFrom expr) {
        this.isTopEq = this.isMinTopEquivalent(1, (OWLPropertyExpression)expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    public void visit(OWLObjectAllValuesFrom expr) {
        this.isTopEq = this.isTopEquivalent(expr.getFiller()) || this.localityChecker.isBotEquivalent((OWLObject)expr.getProperty());
    }

    public void visit(OWLObjectMinCardinality expr) {
        this.isTopEq = this.isMinTopEquivalent(expr.getCardinality(), (OWLPropertyExpression)expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    public void visit(OWLObjectMaxCardinality expr) {
        this.isTopEq = this.isMaxTopEquivalent(expr.getCardinality(), (OWLPropertyExpression)expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    public void visit(OWLObjectExactCardinality expr) {
        int n = expr.getCardinality();
        this.isTopEq = this.isMinTopEquivalent(n, (OWLPropertyExpression)expr.getProperty(), (OWLPropertyRange)expr.getFiller()) && this.isMaxTopEquivalent(n, (OWLPropertyExpression)expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    public void visit(OWLDataHasValue expr) {
        this.isTopEq = this.isTopEquivalent((OWLObject)expr.getProperty());
    }

    public void visit(OWLDataSomeValuesFrom expr) {
        this.isTopEq = this.isMinTopEquivalent(1, (OWLPropertyExpression)expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    public void visit(OWLDataAllValuesFrom expr) {
        this.isTopEq = this.isTopEquivalent(expr.getFiller()) || this.localityChecker.isBotEquivalent((OWLObject)expr.getProperty());
    }

    public void visit(OWLDataMinCardinality expr) {
        this.isTopEq = this.isMinTopEquivalent(expr.getCardinality(), (OWLPropertyExpression)expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    public void visit(OWLDataMaxCardinality expr) {
        this.isTopEq = this.isMaxTopEquivalent(expr.getCardinality(), (OWLPropertyExpression)expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    public void visit(OWLDataExactCardinality expr) {
        int n = expr.getCardinality();
        this.isTopEq = this.isMinTopEquivalent(n, (OWLPropertyExpression)expr.getProperty(), (OWLPropertyRange)expr.getFiller()) && this.isMaxTopEquivalent(n, (OWLPropertyExpression)expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    public void visit(OWLObjectProperty expr) {
        this.isTopEq = this.getSignature().topRLocal() && !this.getSignature().contains((OWLEntity)expr);
    }

    public void visit(OWLObjectInverseOf expr) {
        this.isTopEq = this.isTopEquivalent((OWLObject)expr.getInverse());
    }

    public void visit(OWLDataProperty expr) {
        this.isTopEq = this.getSignature().topRLocal() && !this.getSignature().contains((OWLEntity)expr);
    }

    public void visit(OWLDatatype node) {
        this.isTopEq = node.isTopDatatype();
    }

    public void visit(OWLLiteral node) {
        this.isTopEq = false;
    }

    public void visit(OWLDataComplementOf node) {
        this.isTopEq = this.localityChecker.isBotEquivalent((OWLObject)node.getDataRange());
    }

    public void visit(OWLDatatypeRestriction node) {
        this.isTopEq = node.isTopDatatype();
    }

    public void visit(OWLDataOneOf node) {
        this.isTopEq = false;
    }
}

