/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.metrics;

import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.metrics.IntegerValuedMetric;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public abstract class ObjectCountMetric<E>
extends IntegerValuedMetric {
    public ObjectCountMetric(OWLOntology o) {
        super(o);
    }

    protected abstract String getObjectTypeName();

    @Override
    public String getName() {
        return this.getObjectTypeName() + " count";
    }

    protected abstract Stream<E> getObjects(OWLOntology var1);

    @Override
    public Integer recomputeMetric() {
        return this.getObjects().size();
    }

    protected Set<E> getObjects() {
        return OWLAPIStreamUtils.asUnorderedSet(this.getOntologies().flatMap(this::getObjects));
    }

    @Override
    protected boolean isMetricInvalidated(List<? extends OWLOntologyChange> changes) {
        return true;
    }
}

