/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.grpc.ClientStreamTracer;
import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.Deadline;
import io.grpc.DoubleHistogramMetricInstrument;
import io.grpc.EquivalentAddressGroup;
import io.grpc.ExperimentalApi;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.LongCounterMetricInstrument;
import io.grpc.MetricInstrumentRegistry;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.services.MetricReport;
import io.grpc.util.ForwardingLoadBalancerHelper;
import io.grpc.util.ForwardingSubchannel;
import io.grpc.util.MultiChildLoadBalancer;
import io.grpc.util.RoundRobinLoadBalancer;
import io.grpc.xds.WeightedTargetLoadBalancer;
import io.grpc.xds.orca.OrcaOobUtil;
import io.grpc.xds.orca.OrcaPerRequestUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/9885")
final class WeightedRoundRobinLoadBalancer
extends RoundRobinLoadBalancer {
    private static final LongCounterMetricInstrument RR_FALLBACK_COUNTER;
    private static final LongCounterMetricInstrument ENDPOINT_WEIGHT_NOT_YET_USEABLE_COUNTER;
    private static final LongCounterMetricInstrument ENDPOINT_WEIGHT_STALE_COUNTER;
    private static final DoubleHistogramMetricInstrument ENDPOINT_WEIGHTS_HISTOGRAM;
    private static final Logger log;
    private WeightedRoundRobinLoadBalancerConfig config;
    private final SynchronizationContext syncContext;
    private final ScheduledExecutorService timeService;
    private SynchronizationContext.ScheduledHandle weightUpdateTimer;
    private final Runnable updateWeightTask;
    private final AtomicInteger sequence;
    private final long infTime;
    private final Deadline.Ticker ticker;
    private String locality = "";

    public WeightedRoundRobinLoadBalancer(LoadBalancer.Helper helper, Deadline.Ticker ticker) {
        this(new WrrHelper(OrcaOobUtil.newOrcaReportingHelper(helper)), ticker, new Random());
    }

    public WeightedRoundRobinLoadBalancer(WrrHelper helper, Deadline.Ticker ticker, Random random) {
        super((LoadBalancer.Helper)helper);
        helper.setLoadBalancer(this);
        this.ticker = (Deadline.Ticker)Preconditions.checkNotNull((Object)ticker, (Object)"ticker");
        this.infTime = ticker.nanoTime() + Long.MAX_VALUE;
        this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)helper.getSynchronizationContext(), (Object)"syncContext");
        this.timeService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)helper.getScheduledExecutorService(), (Object)"timeService");
        this.updateWeightTask = new UpdateWeightTask();
        this.sequence = new AtomicInteger(random.nextInt());
        log.log(Level.FINE, "weighted_round_robin LB created");
    }

    @VisibleForTesting
    WeightedRoundRobinLoadBalancer(LoadBalancer.Helper helper, Deadline.Ticker ticker, Random random) {
        this(new WrrHelper(OrcaOobUtil.newOrcaReportingHelper(helper)), ticker, random);
    }

    protected MultiChildLoadBalancer.ChildLbState createChildLbState(Object key, Object policyConfig, LoadBalancer.SubchannelPicker initialPicker, LoadBalancer.ResolvedAddresses unused) {
        WeightedChildLbState childLbState = new WeightedChildLbState(key, this.pickFirstLbProvider, policyConfig, initialPicker);
        return childLbState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        MultiChildLoadBalancer.AcceptResolvedAddrRetVal acceptRetVal;
        if (resolvedAddresses.getLoadBalancingPolicyConfig() == null) {
            Status unavailableStatus = Status.UNAVAILABLE.withDescription("NameResolver returned no WeightedRoundRobinLoadBalancerConfig. addrs=" + resolvedAddresses.getAddresses() + ", attrs=" + resolvedAddresses.getAttributes());
            this.handleNameResolutionError(unavailableStatus);
            return unavailableStatus;
        }
        String locality = (String)resolvedAddresses.getAttributes().get(WeightedTargetLoadBalancer.CHILD_NAME);
        this.locality = locality != null ? locality : "";
        this.config = (WeightedRoundRobinLoadBalancerConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        try {
            this.resolvingAddresses = true;
            acceptRetVal = this.acceptResolvedAddressesInternal(resolvedAddresses);
            if (!acceptRetVal.status.isOk()) {
                Status status = acceptRetVal.status;
                return status;
            }
            if (this.weightUpdateTimer != null && this.weightUpdateTimer.isPending()) {
                this.weightUpdateTimer.cancel();
            }
            this.updateWeightTask.run();
            this.createAndApplyOrcaListeners();
            this.updateOverallBalancingState();
            this.shutdownRemoved(acceptRetVal.removedChildren);
        }
        finally {
            this.resolvingAddresses = false;
        }
        return acceptRetVal.status;
    }

    public LoadBalancer.SubchannelPicker createReadyPicker(Collection<MultiChildLoadBalancer.ChildLbState> activeList) {
        return new WeightedRoundRobinPicker((List<MultiChildLoadBalancer.ChildLbState>)ImmutableList.copyOf(activeList), this.config.enableOobLoadReport, this.config.errorUtilizationPenalty, this.sequence, this.getHelper(), this.locality);
    }

    private void createAndApplyOrcaListeners() {
        for (MultiChildLoadBalancer.ChildLbState child : this.getChildLbStates()) {
            WeightedChildLbState wChild = (WeightedChildLbState)child;
            for (WrrSubchannel weightedSubchannel : wChild.subchannels) {
                if (this.config.enableOobLoadReport) {
                    OrcaOobUtil.setListener((LoadBalancer.Subchannel)weightedSubchannel, wChild.getOrCreateOrcaListener(this.config.errorUtilizationPenalty), OrcaOobUtil.OrcaReportingConfig.newBuilder().setReportInterval(this.config.oobReportingPeriodNanos, TimeUnit.NANOSECONDS).build());
                    continue;
                }
                OrcaOobUtil.setListener((LoadBalancer.Subchannel)weightedSubchannel, null, null);
            }
        }
    }

    public void shutdown() {
        if (this.weightUpdateTimer != null) {
            this.weightUpdateTimer.cancel();
        }
        super.shutdown();
    }

    static {
        log = Logger.getLogger(WeightedRoundRobinLoadBalancer.class.getName());
        MetricInstrumentRegistry metricInstrumentRegistry = MetricInstrumentRegistry.getDefaultRegistry();
        RR_FALLBACK_COUNTER = metricInstrumentRegistry.registerLongCounter("grpc.lb.wrr.rr_fallback", "EXPERIMENTAL. Number of scheduler updates in which there were not enough endpoints with valid weight, which caused the WRR policy to fall back to RR behavior", "{update}", (List)Lists.newArrayList((Object[])new String[]{"grpc.target"}), (List)Lists.newArrayList((Object[])new String[]{"grpc.lb.locality"}), false);
        ENDPOINT_WEIGHT_NOT_YET_USEABLE_COUNTER = metricInstrumentRegistry.registerLongCounter("grpc.lb.wrr.endpoint_weight_not_yet_usable", "EXPERIMENTAL. Number of endpoints from each scheduler update that don't yet have usable weight information", "{endpoint}", (List)Lists.newArrayList((Object[])new String[]{"grpc.target"}), (List)Lists.newArrayList((Object[])new String[]{"grpc.lb.locality"}), false);
        ENDPOINT_WEIGHT_STALE_COUNTER = metricInstrumentRegistry.registerLongCounter("grpc.lb.wrr.endpoint_weight_stale", "EXPERIMENTAL. Number of endpoints from each scheduler update whose latest weight is older than the expiration period", "{endpoint}", (List)Lists.newArrayList((Object[])new String[]{"grpc.target"}), (List)Lists.newArrayList((Object[])new String[]{"grpc.lb.locality"}), false);
        ENDPOINT_WEIGHTS_HISTOGRAM = metricInstrumentRegistry.registerDoubleHistogram("grpc.lb.wrr.endpoint_weights", "EXPERIMENTAL. The histogram buckets will be endpoint weight ranges.", "{weight}", (List)Lists.newArrayList(), (List)Lists.newArrayList((Object[])new String[]{"grpc.target"}), (List)Lists.newArrayList((Object[])new String[]{"grpc.lb.locality"}), false);
    }

    static final class WeightedRoundRobinLoadBalancerConfig {
        final long blackoutPeriodNanos;
        final long weightExpirationPeriodNanos;
        final boolean enableOobLoadReport;
        final long oobReportingPeriodNanos;
        final long weightUpdatePeriodNanos;
        final float errorUtilizationPenalty;

        public static Builder newBuilder() {
            return new Builder();
        }

        private WeightedRoundRobinLoadBalancerConfig(long blackoutPeriodNanos, long weightExpirationPeriodNanos, boolean enableOobLoadReport, long oobReportingPeriodNanos, long weightUpdatePeriodNanos, float errorUtilizationPenalty) {
            this.blackoutPeriodNanos = blackoutPeriodNanos;
            this.weightExpirationPeriodNanos = weightExpirationPeriodNanos;
            this.enableOobLoadReport = enableOobLoadReport;
            this.oobReportingPeriodNanos = oobReportingPeriodNanos;
            this.weightUpdatePeriodNanos = weightUpdatePeriodNanos;
            this.errorUtilizationPenalty = errorUtilizationPenalty;
        }

        static final class Builder {
            long blackoutPeriodNanos = 10000000000L;
            long weightExpirationPeriodNanos = 180000000000L;
            boolean enableOobLoadReport = false;
            long oobReportingPeriodNanos = 10000000000L;
            long weightUpdatePeriodNanos = 1000000000L;
            float errorUtilizationPenalty = 1.0f;

            private Builder() {
            }

            Builder setBlackoutPeriodNanos(long blackoutPeriodNanos) {
                this.blackoutPeriodNanos = blackoutPeriodNanos;
                return this;
            }

            Builder setWeightExpirationPeriodNanos(long weightExpirationPeriodNanos) {
                this.weightExpirationPeriodNanos = weightExpirationPeriodNanos;
                return this;
            }

            Builder setEnableOobLoadReport(boolean enableOobLoadReport) {
                this.enableOobLoadReport = enableOobLoadReport;
                return this;
            }

            Builder setOobReportingPeriodNanos(long oobReportingPeriodNanos) {
                this.oobReportingPeriodNanos = oobReportingPeriodNanos;
                return this;
            }

            Builder setWeightUpdatePeriodNanos(long weightUpdatePeriodNanos) {
                this.weightUpdatePeriodNanos = weightUpdatePeriodNanos;
                return this;
            }

            Builder setErrorUtilizationPenalty(float errorUtilizationPenalty) {
                this.errorUtilizationPenalty = errorUtilizationPenalty;
                return this;
            }

            WeightedRoundRobinLoadBalancerConfig build() {
                return new WeightedRoundRobinLoadBalancerConfig(this.blackoutPeriodNanos, this.weightExpirationPeriodNanos, this.enableOobLoadReport, this.oobReportingPeriodNanos, this.weightUpdatePeriodNanos, this.errorUtilizationPenalty);
            }
        }
    }

    @VisibleForTesting
    static final class StaticStrideScheduler {
        private final short[] scaledWeights;
        private final AtomicInteger sequence;
        private final boolean usesRoundRobin;
        private static final int K_MAX_WEIGHT = 65535;
        private static final double K_MAX_RATIO = 10.0;
        private static final double K_MIN_RATIO = 0.1;

        StaticStrideScheduler(float[] weights, AtomicInteger sequence) {
            double unscaledMeanWeight;
            Preconditions.checkArgument((weights.length >= 1 ? 1 : 0) != 0, (Object)"Couldn't build scheduler: requires at least one weight");
            int numChannels = weights.length;
            int numWeightedChannels = 0;
            double sumWeight = 0.0;
            float unscaledMaxWeight = 0.0f;
            for (float weight : weights) {
                if (!(weight > 0.0f)) continue;
                sumWeight += (double)weight;
                unscaledMaxWeight = Math.max(weight, unscaledMaxWeight);
                ++numWeightedChannels;
            }
            if (numWeightedChannels > 0) {
                unscaledMeanWeight = sumWeight / (double)numWeightedChannels;
                unscaledMaxWeight = Math.min(unscaledMaxWeight, (float)(10.0 * unscaledMeanWeight));
            } else {
                unscaledMeanWeight = 1.0;
                unscaledMaxWeight = 1.0f;
            }
            this.usesRoundRobin = numWeightedChannels < 2;
            double scalingFactor = 65535.0f / unscaledMaxWeight;
            int weightLowerBound = (int)Math.ceil(scalingFactor * unscaledMeanWeight * 0.1);
            short[] scaledWeights = new short[numChannels];
            for (int i = 0; i < numChannels; ++i) {
                if (weights[i] <= 0.0f) {
                    scaledWeights[i] = (short)Math.round(scalingFactor * unscaledMeanWeight);
                    continue;
                }
                int weight = (int)Math.round(scalingFactor * (double)Math.min(weights[i], unscaledMaxWeight));
                scaledWeights[i] = (short)Math.max(weight, weightLowerBound);
            }
            this.scaledWeights = scaledWeights;
            this.sequence = sequence;
        }

        boolean usesRoundRobin() {
            return this.usesRoundRobin;
        }

        private long nextSequence() {
            return Integer.toUnsignedLong(this.sequence.getAndIncrement());
        }

        int pick() {
            long offset;
            long generation;
            int backendIndex;
            int weight;
            do {
                long sequence = this.nextSequence();
                backendIndex = (int)(sequence % (long)this.scaledWeights.length);
                generation = sequence / (long)this.scaledWeights.length;
            } while (((long)(weight = Short.toUnsignedInt(this.scaledWeights[backendIndex])) * generation + (offset = 32767L * (long)backendIndex)) % 65535L < (long)(65535 - weight));
            return backendIndex;
        }
    }

    @VisibleForTesting
    static final class WeightedRoundRobinPicker
    extends LoadBalancer.SubchannelPicker {
        private final List<MultiChildLoadBalancer.ChildLbState> children;
        private final Map<LoadBalancer.Subchannel, OrcaPerRequestUtil.OrcaPerRequestReportListener> subchannelToReportListenerMap = new HashMap<LoadBalancer.Subchannel, OrcaPerRequestUtil.OrcaPerRequestReportListener>();
        private final boolean enableOobLoadReport;
        private final float errorUtilizationPenalty;
        private final AtomicInteger sequence;
        private final int hashCode;
        private final LoadBalancer.Helper helper;
        private final String locality;
        private volatile StaticStrideScheduler scheduler;

        WeightedRoundRobinPicker(List<MultiChildLoadBalancer.ChildLbState> children, boolean enableOobLoadReport, float errorUtilizationPenalty, AtomicInteger sequence, LoadBalancer.Helper helper, String locality) {
            Preconditions.checkNotNull(children, (Object)"children");
            Preconditions.checkArgument((!children.isEmpty() ? 1 : 0) != 0, (Object)"empty child list");
            this.children = children;
            for (MultiChildLoadBalancer.ChildLbState child : children) {
                WeightedChildLbState wChild = (WeightedChildLbState)child;
                for (WrrSubchannel subchannel : wChild.subchannels) {
                    this.subchannelToReportListenerMap.put((LoadBalancer.Subchannel)subchannel, wChild.getOrCreateOrcaListener(errorUtilizationPenalty));
                }
            }
            this.enableOobLoadReport = enableOobLoadReport;
            this.errorUtilizationPenalty = errorUtilizationPenalty;
            this.sequence = (AtomicInteger)Preconditions.checkNotNull((Object)sequence, (Object)"sequence");
            this.helper = helper;
            this.locality = (String)Preconditions.checkNotNull((Object)locality, (Object)"locality");
            int sum = 0;
            for (MultiChildLoadBalancer.ChildLbState child : children) {
                sum += child.hashCode();
            }
            this.hashCode = sum ^ Boolean.hashCode(enableOobLoadReport) ^ Float.hashCode(errorUtilizationPenalty);
            this.updateWeight();
        }

        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            MultiChildLoadBalancer.ChildLbState childLbState = this.children.get(this.scheduler.pick());
            WeightedChildLbState wChild = (WeightedChildLbState)childLbState;
            LoadBalancer.PickResult pickResult = childLbState.getCurrentPicker().pickSubchannel(args);
            LoadBalancer.Subchannel subchannel = pickResult.getSubchannel();
            if (subchannel == null) {
                return pickResult;
            }
            if (!this.enableOobLoadReport) {
                return LoadBalancer.PickResult.withSubchannel((LoadBalancer.Subchannel)subchannel, (ClientStreamTracer.Factory)OrcaPerRequestUtil.getInstance().newOrcaClientStreamTracerFactory(this.subchannelToReportListenerMap.getOrDefault(subchannel, wChild.getOrCreateOrcaListener(this.errorUtilizationPenalty))));
            }
            return LoadBalancer.PickResult.withSubchannel((LoadBalancer.Subchannel)subchannel);
        }

        private void updateWeight() {
            float[] newWeights = new float[this.children.size()];
            AtomicInteger staleEndpoints = new AtomicInteger();
            AtomicInteger notYetUsableEndpoints = new AtomicInteger();
            for (int i = 0; i < this.children.size(); ++i) {
                double newWeight = ((WeightedChildLbState)this.children.get(i)).getWeight(staleEndpoints, notYetUsableEndpoints);
                this.helper.getMetricRecorder().recordDoubleHistogram(ENDPOINT_WEIGHTS_HISTOGRAM, newWeight, (List)ImmutableList.of((Object)this.helper.getChannelTarget()), (List)ImmutableList.of((Object)this.locality));
                newWeights[i] = newWeight > 0.0 ? (float)newWeight : 0.0f;
            }
            if (staleEndpoints.get() > 0) {
                this.helper.getMetricRecorder().addLongCounter(ENDPOINT_WEIGHT_STALE_COUNTER, (long)staleEndpoints.get(), (List)ImmutableList.of((Object)this.helper.getChannelTarget()), (List)ImmutableList.of((Object)this.locality));
            }
            if (notYetUsableEndpoints.get() > 0) {
                this.helper.getMetricRecorder().addLongCounter(ENDPOINT_WEIGHT_NOT_YET_USEABLE_COUNTER, (long)notYetUsableEndpoints.get(), (List)ImmutableList.of((Object)this.helper.getChannelTarget()), (List)ImmutableList.of((Object)this.locality));
            }
            this.scheduler = new StaticStrideScheduler(newWeights, this.sequence);
            if (this.scheduler.usesRoundRobin()) {
                this.helper.getMetricRecorder().addLongCounter(RR_FALLBACK_COUNTER, 1L, (List)ImmutableList.of((Object)this.helper.getChannelTarget()), (List)ImmutableList.of((Object)this.locality));
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper(WeightedRoundRobinPicker.class).add("enableOobLoadReport", this.enableOobLoadReport).add("errorUtilizationPenalty", this.errorUtilizationPenalty).add("list", this.children).toString();
        }

        @VisibleForTesting
        List<MultiChildLoadBalancer.ChildLbState> getChildren() {
            return this.children;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (!(o instanceof WeightedRoundRobinPicker)) {
                return false;
            }
            WeightedRoundRobinPicker other = (WeightedRoundRobinPicker)((Object)o);
            if (other == this) {
                return true;
            }
            return this.hashCode == other.hashCode && this.sequence == other.sequence && this.enableOobLoadReport == other.enableOobLoadReport && Float.compare(this.errorUtilizationPenalty, other.errorUtilizationPenalty) == 0 && this.children.size() == other.children.size() && new HashSet<MultiChildLoadBalancer.ChildLbState>(this.children).containsAll(other.children);
        }
    }

    @VisibleForTesting
    final class WrrSubchannel
    extends ForwardingSubchannel {
        private final LoadBalancer.Subchannel delegate;
        private final WeightedChildLbState owner;

        WrrSubchannel(LoadBalancer.Subchannel delegate, WeightedChildLbState owner) {
            this.delegate = (LoadBalancer.Subchannel)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
            this.owner = (WeightedChildLbState)((Object)Preconditions.checkNotNull((Object)((Object)owner), (Object)"owner"));
        }

        public void start(final LoadBalancer.SubchannelStateListener listener) {
            this.owner.addSubchannel(this);
            this.delegate().start(new LoadBalancer.SubchannelStateListener(){

                public void onSubchannelState(ConnectivityStateInfo newState) {
                    if (newState.getState().equals((Object)ConnectivityState.READY)) {
                        WrrSubchannel.this.owner.nonEmptySince = WeightedRoundRobinLoadBalancer.this.infTime;
                    }
                    listener.onSubchannelState(newState);
                }
            });
        }

        protected LoadBalancer.Subchannel delegate() {
            return this.delegate;
        }

        public void shutdown() {
            super.shutdown();
            this.owner.removeSubchannel(this);
        }
    }

    private static final class WrrHelper
    extends ForwardingLoadBalancerHelper {
        private final LoadBalancer.Helper delegate;
        private WeightedRoundRobinLoadBalancer wrr;

        WrrHelper(LoadBalancer.Helper helper) {
            this.delegate = helper;
        }

        void setLoadBalancer(WeightedRoundRobinLoadBalancer lb) {
            this.wrr = lb;
        }

        protected LoadBalancer.Helper delegate() {
            return this.delegate;
        }

        public LoadBalancer.Subchannel createSubchannel(LoadBalancer.CreateSubchannelArgs args) {
            Preconditions.checkElementIndex((int)0, (int)args.getAddresses().size(), (String)"Empty address group");
            WeightedChildLbState childLbState = (WeightedChildLbState)this.wrr.getChildLbStateEag((EquivalentAddressGroup)args.getAddresses().get(0));
            WeightedRoundRobinLoadBalancer weightedRoundRobinLoadBalancer = this.wrr;
            Objects.requireNonNull(weightedRoundRobinLoadBalancer);
            return weightedRoundRobinLoadBalancer.new WrrSubchannel(this.delegate().createSubchannel(args), childLbState);
        }
    }

    private final class UpdateWeightTask
    implements Runnable {
        private UpdateWeightTask() {
        }

        @Override
        public void run() {
            if (WeightedRoundRobinLoadBalancer.this.currentPicker != null && WeightedRoundRobinLoadBalancer.this.currentPicker instanceof WeightedRoundRobinPicker) {
                ((WeightedRoundRobinPicker)WeightedRoundRobinLoadBalancer.this.currentPicker).updateWeight();
            }
            WeightedRoundRobinLoadBalancer.this.weightUpdateTimer = WeightedRoundRobinLoadBalancer.this.syncContext.schedule((Runnable)this, ((WeightedRoundRobinLoadBalancer)WeightedRoundRobinLoadBalancer.this).config.weightUpdatePeriodNanos, TimeUnit.NANOSECONDS, WeightedRoundRobinLoadBalancer.this.timeService);
        }
    }

    @VisibleForTesting
    final class WeightedChildLbState
    extends MultiChildLoadBalancer.ChildLbState {
        private final Set<WrrSubchannel> subchannels;
        private volatile long lastUpdated;
        private volatile long nonEmptySince;
        private volatile double weight;
        private OrcaReportListener orcaReportListener;

        public WeightedChildLbState(Object key, LoadBalancerProvider policyProvider, Object childConfig, LoadBalancer.SubchannelPicker initialPicker) {
            super((MultiChildLoadBalancer)WeightedRoundRobinLoadBalancer.this, key, (LoadBalancer.Factory)policyProvider, childConfig, initialPicker);
            this.subchannels = new HashSet<WrrSubchannel>();
            this.weight = 0.0;
        }

        private double getWeight(AtomicInteger staleEndpoints, AtomicInteger notYetUsableEndpoints) {
            if (WeightedRoundRobinLoadBalancer.this.config == null) {
                return 0.0;
            }
            long now = WeightedRoundRobinLoadBalancer.this.ticker.nanoTime();
            if (now - this.lastUpdated >= ((WeightedRoundRobinLoadBalancer)WeightedRoundRobinLoadBalancer.this).config.weightExpirationPeriodNanos) {
                this.nonEmptySince = WeightedRoundRobinLoadBalancer.this.infTime;
                staleEndpoints.incrementAndGet();
                return 0.0;
            }
            if (now - this.nonEmptySince < ((WeightedRoundRobinLoadBalancer)WeightedRoundRobinLoadBalancer.this).config.blackoutPeriodNanos && ((WeightedRoundRobinLoadBalancer)WeightedRoundRobinLoadBalancer.this).config.blackoutPeriodNanos > 0L) {
                notYetUsableEndpoints.incrementAndGet();
                return 0.0;
            }
            return this.weight;
        }

        public void addSubchannel(WrrSubchannel wrrSubchannel) {
            this.subchannels.add(wrrSubchannel);
        }

        public OrcaReportListener getOrCreateOrcaListener(float errorUtilizationPenalty) {
            if (this.orcaReportListener != null && this.orcaReportListener.errorUtilizationPenalty == errorUtilizationPenalty) {
                return this.orcaReportListener;
            }
            this.orcaReportListener = new OrcaReportListener(errorUtilizationPenalty);
            return this.orcaReportListener;
        }

        public void removeSubchannel(WrrSubchannel wrrSubchannel) {
            this.subchannels.remove((Object)wrrSubchannel);
        }

        final class OrcaReportListener
        implements OrcaPerRequestUtil.OrcaPerRequestReportListener,
        OrcaOobUtil.OrcaOobReportListener {
            private final float errorUtilizationPenalty;

            OrcaReportListener(float errorUtilizationPenalty) {
                this.errorUtilizationPenalty = errorUtilizationPenalty;
            }

            @Override
            public void onLoadReport(MetricReport report) {
                double utilization;
                double newWeight = 0.0;
                double d = utilization = report.getApplicationUtilization() > 0.0 ? report.getApplicationUtilization() : report.getCpuUtilization();
                if (utilization > 0.0 && report.getQps() > 0.0) {
                    double penalty = 0.0;
                    if (report.getEps() > 0.0 && this.errorUtilizationPenalty > 0.0f) {
                        penalty = report.getEps() / report.getQps() * (double)this.errorUtilizationPenalty;
                    }
                    newWeight = report.getQps() / (utilization + penalty);
                }
                if (newWeight == 0.0) {
                    return;
                }
                if (WeightedChildLbState.this.nonEmptySince == WeightedRoundRobinLoadBalancer.this.infTime) {
                    WeightedChildLbState.this.nonEmptySince = WeightedRoundRobinLoadBalancer.this.ticker.nanoTime();
                }
                WeightedChildLbState.this.lastUpdated = WeightedRoundRobinLoadBalancer.this.ticker.nanoTime();
                WeightedChildLbState.this.weight = newWeight;
            }
        }
    }
}

