/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.plugins;

import com.ontotext.platform.plugins.DatabaseRequestInvoker;
import com.ontotext.platform.plugins.DeploymentChecker;
import com.ontotext.platform.plugins.PluginQueries;
import com.ontotext.platform.plugins.PluginRuntimeException;
import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.StringManipulation;
import com.ontotext.sparql.SinglePropertyResultHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;

public abstract class PluginManager {
    public static final String OTP_PREFIX = "otp-";
    public static final String ENTITY_CHANGE_PLUGIN_NAME = "entity-change";
    private final DatabaseRequestInvoker connectionProvider;
    private final DeploymentChecker deploymentChecker;
    protected Set<String> activePluginInstances = new CopyOnWriteArraySet<String>();
    protected AtomicBoolean deployed = new AtomicBoolean(false);

    public abstract String getPluginIri();

    public abstract String getPluginInstanceIri();

    public PluginManager(DatabaseRequestInvoker connectionProvider) {
        this.connectionProvider = connectionProvider;
        this.deploymentChecker = new DeploymentChecker(connectionProvider);
    }

    public String getPluginShortName(String pluginName) {
        return StringUtils.removeStart((String)pluginName, (String)this.getPluginInstanceIri());
    }

    public boolean exists(String name) {
        SinglePropertyResultHandler handler;
        if (this.activePluginInstances.contains(name)) {
            return true;
        }
        String query = PluginQueries.buildExistsQuery(this.getPluginShortName(name), this.getPluginIri(), this.getPluginInstanceIri());
        String error = this.connectionProvider.executeSelect(query, (TupleQueryResultHandler)(handler = new SinglePropertyResultHandler("cntStatus"))).orElse(null);
        if (error != null) {
            throw new PluginRuntimeException(String.format("Failed to execute exists operation for plugin with name: %s due to: %s", name, error), ErrorCode.COULD_NOT_QUERY_GDB_PLUGIN_INFO);
        }
        if (!handler.getResults().isEmpty()) {
            this.activePluginInstances.add(name);
            return true;
        }
        return false;
    }

    public void create(Collection<CreatePluginConfiguration> requests) {
        List<String> queries = this.createRequests(requests);
        String error = this.invoke(queries, this.connectionProvider);
        if (error != null) {
            throw new PluginRuntimeException("Failed to execute create operation due to: " + error, ErrorCode.COULD_NOT_UPDATE_ENTITY_CHANGE_PLUGIN);
        }
    }

    protected String invoke(List<String> queries, DatabaseRequestInvoker invoker) {
        return invoker.executeUpdate(queries).orElse(null);
    }

    private List<String> createRequests(Collection<CreatePluginConfiguration> requests) {
        List<String> all = this.listAllNames();
        return requests.stream().filter(config -> !all.contains(config.getPluginInstanceName())).map(req -> PluginQueries.buildCreateQuery(req.getPluginInstanceName(), req.getConfiguration(), this.getPluginIri(), this.getPluginInstanceIri())).collect(Collectors.toList());
    }

    public void remove(String name) {
        String normalized = this.normalizeName(name);
        this.activePluginInstances.remove(normalized);
        this.removeInternal(Collections.singletonList(normalized));
    }

    public void removeAll(Collection<String> pluginNames) {
        Set allCurrent = this.listAll().stream().map(this::getPluginShortName).collect(Collectors.toSet());
        List<String> toRemove = pluginNames.stream().map(this::normalizeName).filter(allCurrent::contains).collect(Collectors.toList());
        toRemove.forEach(this.activePluginInstances::remove);
        this.removeInternal(toRemove);
    }

    public void removeAll() {
        this.activePluginInstances.clear();
        List<String> platformSpecificIndexes = this.listAll().stream().filter(this.platformInstances()).collect(Collectors.toList());
        this.removeInternal(platformSpecificIndexes);
    }

    protected Predicate<String> platformInstances() {
        return iri -> this.getPluginShortName((String)iri).startsWith(OTP_PREFIX);
    }

    private void removeInternal(List<String> plugins) {
        List<String> updates = plugins.stream().map(name -> PluginQueries.buildRemoveQuery(this.normalizeName((String)name), this.getPluginIri(), this.getPluginInstanceIri())).collect(Collectors.toList());
        String error = this.connectionProvider.executeSequentialUpdate(updates).orElse(null);
        if (error != null) {
            throw new PluginRuntimeException(String.format("Failed to remove plugin instances due to: %s", error), ErrorCode.COULD_NOT_UPDATE_ENTITY_CHANGE_PLUGIN);
        }
    }

    public List<String> listAll() {
        SinglePropertyResultHandler handler = new SinglePropertyResultHandler("cntUri");
        String error = this.connectionProvider.executeSelect(PluginQueries.buildListAllQuery(this.getPluginIri()), (TupleQueryResultHandler)handler).orElse(null);
        if (error != null) {
            throw new PluginRuntimeException("Failed to execute list all operation.", ErrorCode.COULD_NOT_QUERY_GDB_PLUGIN_INFO);
        }
        return handler.getResults().stream().map(Value::stringValue).collect(Collectors.toList());
    }

    public List<String> listAllNames() {
        return this.listAll().stream().filter(this.platformInstances()).map(this::getPluginShortName).collect(Collectors.toList());
    }

    private String normalizeName(String name) {
        if (((String)name).startsWith(this.getPluginInstanceIri())) {
            name = ((String)name).substring(this.getPluginInstanceIri().length());
        }
        if (!((String)name).startsWith(OTP_PREFIX)) {
            name = OTP_PREFIX + (String)name;
        }
        return name;
    }

    protected void ensurePluginIsDeployedAndActivated() {
        if (this.deployed.get()) {
            return;
        }
        DeploymentChecker.PluginStatus pluginStatus = this.deploymentChecker.getPluginStatus(ENTITY_CHANGE_PLUGIN_NAME);
        if (pluginStatus == DeploymentChecker.PluginStatus.NOT_FOUND) {
            throw new PluginRuntimeException("Entity Change connector not installed.", ErrorCode.MISSING_ENTITY_CHANGE_PLUGIN_FROM_GDB);
        }
        if (pluginStatus == DeploymentChecker.PluginStatus.INACTIVE) {
            this.deploymentChecker.activatePlugin(ENTITY_CHANGE_PLUGIN_NAME);
        }
        this.deployed.set(true);
    }

    public static class CreatePluginConfiguration {
        private final String pluginName;
        private final Object configuration;

        public CreatePluginConfiguration(String pluginName, Object configuration) {
            this.pluginName = pluginName;
            this.configuration = configuration;
        }

        public String getPluginInstanceName() {
            return StringUtils.prependIfMissing((String)StringManipulation.replaceColonWithUnderscore((String)this.pluginName).toLowerCase(), (CharSequence)PluginManager.OTP_PREFIX, (CharSequence[])new CharSequence[0]);
        }

        public Object getConfiguration() {
            return this.configuration;
        }
    }
}

