/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.plugins;

import com.ontotext.models.Prefixes;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class PluginGenerationUtil {
    private PluginGenerationUtil() {
    }

    public static Collection<String> getTypesAsIri(SomlSchema soml, Shape shape) {
        LinkedHashSet<String> rdfTypes = new LinkedHashSet<String>();
        if (!shape.isAbstract() && !shape.isUnion()) {
            PluginGenerationUtil.getTypeForSingleShape(shape, rdfTypes);
        } else {
            shape.getConcreteSubTypes().forEach(child -> PluginGenerationUtil.getTypeForSingleShape(child, rdfTypes));
        }
        return rdfTypes.stream().map(arg_0 -> ((Prefixes)soml.getPrefixes()).toIri(arg_0)).collect(Collectors.toList());
    }

    private static void getTypeForSingleShape(Shape shape, Set<String> rdfTypes) {
        if (PluginGenerationUtil.addRdfType(shape, rdfTypes)) {
            return;
        }
        if (shape.getParents().anyMatch(parent -> PluginGenerationUtil.addRdfType(parent, rdfTypes))) {
            return;
        }
        if (shape.forEachParentShape().anyMatch(parent -> PluginGenerationUtil.addRdfType(parent, rdfTypes))) {
            return;
        }
        if (rdfTypes.isEmpty()) {
            rdfTypes.add("$untyped");
        }
    }

    private static boolean addRdfType(Shape shape, Set<String> rdfTypes) {
        if (shape.getTypeProp().equals("rdf:type")) {
            rdfTypes.addAll(shape.getTypeAsList());
            return true;
        }
        return false;
    }
}

