/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.plugins;

import com.ontotext.platform.plugins.DatabaseRequestInvoker;
import com.ontotext.platform.plugins.PluginRuntimeException;
import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.sparql.SinglePropertyResultHandler;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String IS_PLUGIN_DEPLOYED_TEMPLATE = DeploymentChecker.loadTemplate("/deployment-queries/is-plugin-deployed-template.sparql");
    private static final String ACTIVATE_PLUGIN = DeploymentChecker.loadTemplate("/deployment-queries/activate-plugin.ru");
    private static final String DEACTIVATE_PLUGIN = DeploymentChecker.loadTemplate("/deployment-queries/deactivate-plugin.ru");
    private final DatabaseRequestInvoker connectionProvider;

    public DeploymentChecker(DatabaseRequestInvoker connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    private static String loadTemplate(String path) {
        try {
            return IOUtils.resourceToString((String)path, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException ioe) {
            throw new PluginRuntimeException("Failed to load the query for deployment checking: " + ioe.getMessage());
        }
    }

    public PluginStatus getPluginStatus(String name) {
        String error;
        try {
            String isDeployedQuery = String.format(IS_PLUGIN_DEPLOYED_TEMPLATE, name);
            SinglePropertyResultHandler handler = new SinglePropertyResultHandler("isActive");
            error = this.connectionProvider.executeSelect(isDeployedQuery, (TupleQueryResultHandler)handler).orElse(null);
            if (error == null) {
                return handler.getResults().stream().filter(Literal.class::isInstance).map(value -> ((Literal)value).booleanValue()).findFirst().map(PluginStatus::from).orElse(PluginStatus.NOT_FOUND);
            }
        }
        catch (Exception exc) {
            error = exc.getMessage();
            LOGGER.debug("", (Throwable)exc);
        }
        throw new PluginRuntimeException("Failed to check, if '" + name + "' plugin is activated due to: " + error, ErrorCode.COULD_NOT_QUERY_GDB_PLUGIN_INFO);
    }

    public void activatePlugin(String name) {
        String error = this.managePlugin(name, ACTIVATE_PLUGIN);
        if (error != null) {
            throw new PluginRuntimeException("Could not activate " + name, ErrorCode.COULD_NOT_ACTIVATE_GDB_PLUGIN);
        }
    }

    public void deactivatePlugin(String name) {
        String error = this.managePlugin(name, DEACTIVATE_PLUGIN);
        if (error != null) {
            throw new PluginRuntimeException("Could not deactivate " + name + " due to: " + error);
        }
    }

    private String managePlugin(String name, String deactivatePlugin) {
        String error;
        try {
            String activate = String.format(deactivatePlugin, name);
            error = this.connectionProvider.executeUpdate(Collections.singletonList(activate)).orElse(null);
        }
        catch (Exception exc) {
            error = exc.getMessage();
            LOGGER.debug("", (Throwable)exc);
        }
        return error;
    }

    public static enum PluginStatus {
        ACTIVE,
        INACTIVE,
        NOT_FOUND;


        static PluginStatus from(boolean value) {
            return value ? ACTIVE : INACTIVE;
        }
    }
}

