/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.security;

import com.google.common.base.MoreObjects;
import com.ontotext.graphdb.raft.security.SecurityConfig;
import com.ontotext.graphdb.security.TlsContext;
import io.grpc.CallCredentials;
import io.grpc.ChannelCredentials;
import io.grpc.InsecureChannelCredentials;
import io.grpc.InsecureServerCredentials;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCredentials;
import io.grpc.TlsChannelCredentials;
import io.grpc.TlsServerCredentials;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Consumer;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.function.FailableConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityUtil.class);
    public static final Metadata.Key<String> AUTHORIZATION_HEADER = Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<String> TIMESTAMP_HEADER = Metadata.Key.of((String)"X-GraphDB-Timestamp", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<String> AUTH_CONTEXT_HEADER_USERNAME = Metadata.Key.of((String)"X-GraphDB-Auth-Context", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<String> USER_AUTHORITIES = Metadata.Key.of((String)"user-roles", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<String> RECIPIENT_ADDRESS = Metadata.Key.of((String)"recipient-address", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);

    private SecurityUtil() {
    }

    static String createSummary(CallCredentials.RequestInfo request, String username, String userRoles) {
        return SecurityUtil.createSummary(request.getAuthority(), request.getMethodDescriptor(), username, userRoles);
    }

    static <RespT, ReqT> String createSummary(ServerCall<ReqT, RespT> call, String username, String userRoles) {
        return SecurityUtil.createSummary(call.getAuthority(), call.getMethodDescriptor(), username, userRoles);
    }

    static <RespT, ReqT> String createSummary(String authority, MethodDescriptor<ReqT, RespT> descriptor, String username, String userRoles) {
        return "authority=" + Objects.toString(authority, "") + "\nusername=" + Objects.toString(username, "") + "\nroles=" + Objects.toString(userRoles, "") + "\nmethod=" + SecurityUtil.getDescriptorSummary(descriptor);
    }

    private static <RespT, ReqT> String getDescriptorSummary(MethodDescriptor<ReqT, RespT> descriptor) {
        return MoreObjects.toStringHelper(descriptor).add("fullMethodName", (Object)descriptor.getFullMethodName()).add("type", (Object)descriptor.getType()).add("idempotent", descriptor.isIdempotent()).add("safe", descriptor.isSafe()).add("sampledToLocalTracing", descriptor.isSampledToLocalTracing()).add("schemaDescriptor", descriptor.getSchemaDescriptor() == null ? null : descriptor.getSchemaDescriptor().getClass().toString()).omitNullValues().toString();
    }

    public static ServerCredentials createServerCredentials(SecurityConfig securityConfig) {
        if (!securityConfig.isSecurityEnabled()) {
            LOGGER.debug("Cluster gRPC server security is disabled");
            return InsecureServerCredentials.create();
        }
        SecurityConfig.SecurityMode securityMode = securityConfig.getSecurityMode();
        LOGGER.debug("Using security mode: {}", (Object)securityMode);
        if (securityMode == SecurityConfig.SecurityMode.TLS || securityMode == SecurityConfig.SecurityMode.DEFAULT) {
            TlsServerCredentials.Builder builder = TlsServerCredentials.newBuilder().clientAuth(TlsServerCredentials.ClientAuth.REQUIRE);
            boolean failIfNotConfigured = securityMode == SecurityConfig.SecurityMode.TLS;
            SecurityUtil.setupKeyManager(securityConfig, (arg_0, arg_1, arg_2) -> ((TlsServerCredentials.Builder)builder).keyManager(arg_0, arg_1, arg_2), arg_0 -> ((TlsServerCredentials.Builder)builder).keyManager(arg_0), failIfNotConfigured, "server");
            SecurityUtil.setupTrustManager(securityConfig, (FailableConsumer<File, IOException>)((FailableConsumer)arg_0 -> ((TlsServerCredentials.Builder)builder).trustManager(arg_0)), arg_0 -> ((TlsServerCredentials.Builder)builder).trustManager(arg_0), false, "server");
            return builder.build();
        }
        throw new UnsupportedOperationException("graphdb.raft.security.mode: " + String.valueOf((Object)securityMode) + " is not supported!");
    }

    @Nonnull
    public static ChannelCredentials createChannelCredentials(SecurityConfig securityConfig) {
        if (!securityConfig.isSecurityEnabled()) {
            LOGGER.debug("Cluster gRPC channel security is disabled");
            return InsecureChannelCredentials.create();
        }
        SecurityConfig.SecurityMode securityMode = securityConfig.getSecurityMode();
        if (securityMode == SecurityConfig.SecurityMode.TLS || securityMode == SecurityConfig.SecurityMode.DEFAULT) {
            TlsChannelCredentials.Builder builder = TlsChannelCredentials.newBuilder();
            SecurityUtil.setupKeyManager(securityConfig, (arg_0, arg_1, arg_2) -> ((TlsChannelCredentials.Builder)builder).keyManager(arg_0, arg_1, arg_2), arg_0 -> ((TlsChannelCredentials.Builder)builder).keyManager(arg_0), false, "channel");
            SecurityUtil.setupTrustManager(securityConfig, (FailableConsumer<File, IOException>)((FailableConsumer)arg_0 -> ((TlsChannelCredentials.Builder)builder).trustManager(arg_0)), arg_0 -> ((TlsChannelCredentials.Builder)builder).trustManager(arg_0), false, "channel");
            return builder.build();
        }
        throw new UnsupportedOperationException("graphdb.raft.security.mode: " + String.valueOf((Object)securityConfig.getSecurityMode()) + " is not supported!");
    }

    private static void setupKeyManager(SecurityConfig securityConfig, CertificateConfigurer certificateConfigurer, Consumer<KeyManager[]> keyManagerConsumer, boolean failIfNotConfigured, String name) {
        try {
            File certChainFile = securityConfig.getCertChainFile();
            File privateKeyFile = securityConfig.getPrivateKeyFile();
            if (certChainFile != null && privateKeyFile != null) {
                LOGGER.debug("Setting {} security using certificate chain and private key files", (Object)name);
                certificateConfigurer.configure(certChainFile, privateKeyFile, securityConfig.getPrivateKeyPassword());
            } else {
                KeyManager[] keyManagers = (KeyManager[])ObjectUtils.getIfNull((Object)securityConfig.getTlsContext().getKeyManagers(), () -> ((TlsContext)TlsContext.getDefaultRpcTlsContext()).getKeyManagers());
                if (keyManagers != null && keyManagers.length > 0) {
                    LOGGER.debug("Setting {} security using server's key manager {}", (Object)name, (Object)keyManagers.length);
                    keyManagerConsumer.accept(keyManagers);
                } else {
                    if (failIfNotConfigured) {
                        throw new IllegalStateException("TLS KeyManager not configured");
                    }
                    LOGGER.warn("Could not set {} security. Not configured!", (Object)name);
                }
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    private static void setupTrustManager(SecurityConfig securityConfig, FailableConsumer<File, IOException> fileTrustManager, Consumer<TrustManager[]> trustManagerConsumer, boolean failIfNotConfigured, String name) {
        File rootCertsFile = securityConfig.getRootCertsFile();
        if (rootCertsFile != null) {
            try {
                LOGGER.debug("Setting {} trust manager using custom root certificate file", (Object)name);
                fileTrustManager.accept((Object)rootCertsFile);
            }
            catch (IOException ioe) {
                throw new IllegalStateException(ioe);
            }
        } else {
            TrustManager[] trustManagers = (TrustManager[])ObjectUtils.getIfNull((Object)securityConfig.getTlsContext().getTrustManagers(), () -> ((TlsContext)TlsContext.getDefaultRpcTlsContext()).getTrustManagers());
            if (trustManagers != null && trustManagers.length > 0) {
                LOGGER.debug("Setting {} trust manager using server's manager {}", (Object)name, (Object)trustManagers.length);
                trustManagerConsumer.accept(trustManagers);
            } else {
                if (failIfNotConfigured) {
                    throw new IllegalStateException("TLS TrustManager not configured");
                }
                LOGGER.warn("Could not set {} trust manager. Not configured!", (Object)name);
            }
        }
    }

    private static interface CertificateConfigurer {
        public void configure(File var1, File var2, String var3) throws IOException;
    }
}

