/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.sparql.template;

import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.repository.SemanticRepository;
import com.ontotext.forest.sparql.template.SparqlTemplate;
import com.ontotext.forest.sparql.template.ValueParser;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.UpdateExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailUpdate;
import org.eclipse.rdf4j.sail.shacl.GraphDBShaclSailValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class SparqlTemplateService {
    private static final Logger LOG = LoggerFactory.getLogger(SparqlTemplateService.class);
    public static final String TEMPLATE_ID = "templateId";
    public static final String TEMPLATE_ID_PLACEHOLDER = "{{templateId}}";
    public static final String TEMPLATE = "template";
    public static final String TEMPLATE_PLACEHOLDER = "{{template}}";
    private static final String GET_SPARQL_TEMPLATE_IDs_QUERY = "select ?templateId {\n  ?templateId <http://www.ontotext.com/sparql/template> ?template\n}";
    private static final String CREATE_SPARQL_TEMPLATE_QUERY = "insert data {\n  <{{templateId}}> <http://www.ontotext.com/sparql/template> '''{{template}}'''\n}";
    private static final String GET_SPARQL_TEMPLATE_CONTENT_QUERY = "select ?template {\n  <{{templateId}}> <http://www.ontotext.com/sparql/template> ?template\n}";
    private static final String DELETE_SPARQL_TEMPLATE_QUERY = "delete where {\n  <{{templateId}}> <http://www.ontotext.com/sparql/template> ?template.\n}";
    @Autowired
    private SemanticDataManagement semanticDataManagement;
    @Autowired
    private ValueParser valueParser;

    public List<String> getSparqlTemplateIDs(String repositoryID) {
        return this.executeQuery(repositoryID, GET_SPARQL_TEMPLATE_IDs_QUERY, TEMPLATE_ID);
    }

    public ResponseEntity<?> createSparqlTemplate(String repositoryID, SparqlTemplate sparqlTemplate) {
        try {
            this.executeUpdate(repositoryID, CREATE_SPARQL_TEMPLATE_QUERY.replace(TEMPLATE_ID_PLACEHOLDER, sparqlTemplate.getTemplateID()).replace(TEMPLATE_PLACEHOLDER, sparqlTemplate.getQuery()));
            return new ResponseEntity((HttpStatusCode)HttpStatus.CREATED);
        }
        catch (Exception ex) {
            return new ResponseEntity((Object)ex.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<String> editSparqlTemplate(String repositoryID, SparqlTemplate sparqlTemplate) {
        try {
            this.executeUpdate(repositoryID, CREATE_SPARQL_TEMPLATE_QUERY.replace(TEMPLATE_ID_PLACEHOLDER, sparqlTemplate.getTemplateID()).replace(TEMPLATE_PLACEHOLDER, sparqlTemplate.getQuery()));
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception ex) {
            return new ResponseEntity((Object)ex.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public String getSparqlTemplateContent(String repositoryID, String templateId) {
        List<String> results = this.executeQuery(repositoryID, GET_SPARQL_TEMPLATE_CONTENT_QUERY.replace(TEMPLATE_ID_PLACEHOLDER, templateId), TEMPLATE);
        if (results.size() == 1) {
            return results.get(0);
        }
        return null;
    }

    public ResponseEntity<?> deleteSmartUpdateTemplate(String repositoryID, String templateId) {
        try {
            this.executeUpdate(repositoryID, DELETE_SPARQL_TEMPLATE_QUERY.replace(TEMPLATE_ID_PLACEHOLDER, templateId));
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        catch (Exception ex) {
            return new ResponseEntity((Object)ex.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private List<String> executeQuery(String repositoryID, String query, String binding) {
        ArrayList<String> templateIds = new ArrayList<String>();
        SemanticRepository currentRepository = this.semanticDataManagement.getLocationFromHeaderOrThrow().getRepository(repositoryID);
        try (RepositoryConnection connection = currentRepository.getConnection();){
            TupleQueryResult templates = connection.prepareTupleQuery(query).evaluate();
            while (templates.hasNext()) {
                BindingSet template = (BindingSet)templates.next();
                templateIds.add(template.getValue(binding).stringValue());
            }
        }
        return templateIds;
    }

    private void executeUpdate(String repositoryID, final String updateString) {
        SemanticRepository repo;
        SemanticRepository semanticRepository = repo = this.semanticDataManagement.getLocationFromHeaderOrThrow().getRepository(repositoryID);
        Objects.requireNonNull(semanticRepository);
        new SemanticRepository.WithConnection<Void>(this, semanticRepository){

            protected Void doInConnection() throws RepositoryException {
                try {
                    this.prepareAndExecuteUpdate(updateString);
                }
                catch (MalformedQueryException | QueryEvaluationException e) {
                    LOG.error("Cannot execute update query", e);
                    throw new RepositoryException(e);
                }
                return null;
            }
        }.run();
    }

    public ResponseEntity<String> executeUpdate(String repositoryID, Map<String, Object> input, HttpServletRequest request) {
        ResponseEntity responseEntity;
        block10: {
            if (input.isEmpty()) {
                return new ResponseEntity((Object)"Empty document.", (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            SemanticRepository currentRepository = this.semanticDataManagement.getLocationFromHeaderOrThrow().getRepository(repositoryID);
            RepositoryConnection connection = currentRepository.getConnection();
            try {
                Update template = this.prepareUpdate(repositoryID, input, connection);
                this.bindInput(input, template);
                template.execute();
                responseEntity = new ResponseEntity((Object)"Update done.", (HttpStatusCode)HttpStatus.OK);
                if (connection == null) break block10;
            }
            catch (Throwable template) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable) {
                            template.addSuppressed(throwable);
                        }
                    }
                    throw template;
                }
                catch (TemplateNotFoundException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.NOT_FOUND);
                }
                catch (Exception e) {
                    GraphDBShaclSailValidationException shaclSailValidationException = GraphDBShaclSailValidationException.findGraphDBShaclValidationException((Exception)e);
                    String errorMessage = shaclSailValidationException != null ? shaclSailValidationException.writeShaclValidationReportInRequestedMimetype(request) : e.getMessage();
                    LOG.error(errorMessage, (Throwable)e);
                    return new ResponseEntity((Object)errorMessage, (HttpStatusCode)HttpStatus.BAD_REQUEST);
                }
            }
            connection.close();
        }
        return responseEntity;
    }

    private Update prepareUpdate(String repositoryID, Map<String, Object> input, RepositoryConnection connection) {
        String templateId = (String)input.remove(TEMPLATE_ID);
        if (templateId != null) {
            String query = this.getSparqlTemplateContent(repositoryID, templateId);
            if (query == null) {
                throw new TemplateNotFoundException();
            }
            LOG.info("Template found {}", (Object)templateId);
            return connection.prepareUpdate(QueryLanguage.SPARQL, query);
        }
        List<String> templates = this.getSparqlTemplateIDs(repositoryID);
        ArrayList<Update> result = new ArrayList<Update>();
        for (String template : templates) {
            Update update = connection.prepareUpdate(QueryLanguage.SPARQL, this.getSparqlTemplateContent(repositoryID, template));
            if (this.hasAllVariables(update, input)) {
                LOG.info("Template found {}", (Object)template);
                result.add(update);
            }
            if (result.size() <= 1) continue;
            throw new MultipleTemplatesException();
        }
        if (result.isEmpty()) {
            throw new TemplateNotFoundException();
        }
        return (Update)result.get(0);
    }

    private boolean hasAllVariables(Update update, Map<String, Object> input) {
        for (String name : input.keySet()) {
            if (this.hasVariable(update, name)) continue;
            return false;
        }
        return true;
    }

    private boolean hasVariable(Update update, final String variableName) {
        List updateExpressions = ((SailUpdate)update).getParsedUpdate().getUpdateExprs();
        final boolean[] result = new boolean[]{false};
        AbstractQueryModelVisitor<RuntimeException> collector = new AbstractQueryModelVisitor<RuntimeException>(this){

            public void meet(Var node) {
                if (!node.hasValue() && node.getName().equals(variableName)) {
                    result[0] = true;
                }
            }
        };
        for (UpdateExpr updateExpr : updateExpressions) {
            updateExpr.visit((QueryModelVisitor)collector);
        }
        return result[0];
    }

    private void bindInput(Map<String, Object> input, Update update) {
        for (String varName : input.keySet()) {
            Object valueAsObject = input.get(varName);
            Value value = this.valueParser.parse(valueAsObject);
            if (value == null) {
                LOG.warn("Binding for {} is {}. Skipping binding.", (Object)varName, (Object)(valueAsObject == null ? "null" : "empty"));
                continue;
            }
            update.setBinding(varName, value);
        }
    }

    static class TemplateNotFoundException
    extends RuntimeException {
        static final String NONE = "No matching template found.";

        TemplateNotFoundException() {
            super(NONE);
        }
    }

    static class MultipleTemplatesException
    extends RuntimeException {
        static final String MULTIPLE = "Multiple templates found.";

        MultipleTemplatesException() {
            super(MULTIPLE);
        }
    }
}

