/*
 * Decompiled with CFR 0.152.
 */
package com.useekm.types;

import com.useekm.indexing.GeoConstants;
import com.useekm.types.AbstractGeo;
import com.useekm.types.AbstractGeoSerializer;
import com.useekm.types.GeoConvert;
import com.useekm.types.GeoWkt;
import com.useekm.types.exception.InvalidGeometryException;
import org.eclipse.rdf4j.model.IRI;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTWriter;

public class WktSerializer
extends AbstractGeoSerializer {
    public static final WktSerializer INTANCE = new WktSerializer();

    protected WktSerializer() {
    }

    @Override
    public String toLiteral(Geometry geometry) {
        return new WKTWriter().write(geometry);
    }

    @Override
    public Geometry toGeometry(String value) throws InvalidGeometryException {
        return value.isEmpty() ? GeoConvert.getEmptyGeometry() : GeoConvert.wktToGeometry(value);
    }

    @Override
    public AbstractGeo toGeo(String value) {
        return new GeoWkt(value);
    }

    @Override
    public IRI getDatatype() {
        return GeoConstants.XMLSCHEMA_SPATIAL_TEXT;
    }

    @Override
    public Class<? extends AbstractGeo> getGeoClass() {
        return GeoWkt.class;
    }
}

