/*
 * Decompiled with CFR 0.152.
 */
package com.useekm.types;

import com.ontotext.trree.geosparql.conversion.CRSUtil;
import com.ontotext.trree.geosparql.conversion.TransformCoordinateFilter;
import com.ontotext.trree.geosparql.gml.GmlSerializer;
import com.useekm.indexing.GeoFactory;
import com.useekm.types.AbstractGeo;
import com.useekm.types.AbstractGeoSerializer;
import com.useekm.types.WkbGzSerializer;
import com.useekm.types.WkbSerializer;
import com.useekm.types.WktGzSerializer;
import com.useekm.types.WktOgcSerializer;
import com.useekm.types.WktSerializer;
import com.useekm.types.exception.InvalidGeometryException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;

public final class GeoConvert {
    private static final AbstractGeoSerializer NO_TYPE_SERIALIZER = new WktSerializer();
    private static final Map<String, AbstractGeoSerializer> GEO_SERIALIZERS = new HashMap<String, AbstractGeoSerializer>();

    private static void add(AbstractGeoSerializer serializer) {
        GEO_SERIALIZERS.put(serializer.getDatatype().stringValue(), serializer);
    }

    private static AbstractGeoSerializer getSerializer(IRI datatype, boolean acceptNoType) throws InvalidGeometryException {
        if (datatype == null || datatype.equals((Object)XMLSchema.STRING)) {
            if (acceptNoType) {
                return NO_TYPE_SERIALIZER;
            }
            throw new InvalidGeometryException((IRI)null);
        }
        AbstractGeoSerializer s = GEO_SERIALIZERS.get(datatype.stringValue());
        if (s == null) {
            throw new InvalidGeometryException(datatype);
        }
        return s;
    }

    public static boolean isSupported(IRI datatype) {
        return datatype != null && GEO_SERIALIZERS.containsKey(datatype.stringValue());
    }

    public static Geometry toGeometry(Literal literal, boolean acceptNoType) throws InvalidGeometryException {
        return GeoConvert.getSerializer(literal.getDatatype(), acceptNoType).toGeometry(literal.stringValue());
    }

    public static Geometry toGeometryExpr(Literal literal, boolean acceptNoType) throws ValueExprEvaluationException {
        try {
            return GeoConvert.getSerializer(literal.getDatatype(), acceptNoType).toGeometry(literal.stringValue());
        }
        catch (InvalidGeometryException e) {
            throw new ValueExprEvaluationException((Throwable)e);
        }
    }

    public static Literal toLiteral(ValueFactory vf, Geometry geometry, IRI datatype) {
        AbstractGeoSerializer s = GEO_SERIALIZERS.get(datatype.stringValue());
        Validate.notNull((Object)s);
        return vf.createLiteral(s.toLiteral(geometry), datatype);
    }

    public static Literal toLiteralExpr(ValueFactory vf, Geometry geometry, IRI datatype) {
        if (datatype == null) {
            return vf.createLiteral(NO_TYPE_SERIALIZER.toLiteral(geometry), NO_TYPE_SERIALIZER.getDatatype());
        }
        return GeoConvert.toLiteral(vf, geometry, datatype);
    }

    public static AbstractGeo toGeo(Literal literal) throws InvalidGeometryException {
        return GeoConvert.getSerializer(literal.getDatatype(), false).toGeo(literal.stringValue());
    }

    public static Geometry wktToGeometry(String value) throws InvalidGeometryException {
        int startOfUri = value.indexOf("<");
        for (int i = 0; i < startOfUri; ++i) {
            if (value.charAt(i) <= ' ') continue;
            startOfUri = -1;
            break;
        }
        MathTransform mathTransform = null;
        if (startOfUri >= 0) {
            int endOfUri = value.indexOf(">");
            if (endOfUri > 0) {
                String shortId;
                String uri = value.substring(startOfUri + 1, endOfUri);
                if (!uri.equals("http://www.opengis.net/def/crs/OGC/1.3/CRS84") && (shortId = CRSUtil.crsUriToShortId(uri)) != null) {
                    try {
                        mathTransform = CRSUtil.findMathTransform(shortId, "CRS:84");
                    }
                    catch (FactoryException e) {
                        throw new InvalidGeometryException("Unable to find SRS", e);
                    }
                }
                value = value.substring(endOfUri + 1);
            } else {
                throw new InvalidGeometryException("CRS uri in value is incomplete: " + value, null);
            }
        }
        WKTReader reader = new WKTReader(GeoFactory.getDefaultGeometryFactory());
        try {
            Geometry g = reader.read(value);
            if (mathTransform != null) {
                g.apply((CoordinateFilter)new TransformCoordinateFilter(mathTransform));
                g.setSRID(4326);
            }
            return g;
        }
        catch (ParseException e) {
            throw new InvalidGeometryException("Invalid geo WKT: " + value, e);
        }
    }

    public static Literal toLiteral(ValueFactory vf, String value, IRI datatype) {
        try {
            Geometry geometry = GeoConvert.wktToGeometry(value);
            return GeoConvert.toLiteral(vf, geometry, datatype);
        }
        catch (InvalidGeometryException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Geometry getEmptyGeometry() {
        return GeoFactory.getDefaultGeometryFactory().createPoint((CoordinateSequence)null);
    }

    static {
        GeoConvert.add(WktOgcSerializer.INTANCE);
        GeoConvert.add(WktSerializer.INTANCE);
        GeoConvert.add(WktGzSerializer.INTANCE);
        GeoConvert.add(WkbSerializer.INTANCE);
        GeoConvert.add(WkbGzSerializer.INTANCE);
        GeoConvert.add(GmlSerializer.INSTANCE);
    }
}

