/*
 * Decompiled with CFR 0.152.
 */
package com.useekm.geosparql.algebra;

import com.useekm.indexing.GeoConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.FunctionCall;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class PropertyToFunctionOptimizer
implements QueryOptimizer {
    private static final Collection<IRI> PROPERTY_TO_FUNCTION = new HashSet<IRI>();
    private static final String CONST_ASWKT = "geo__aswkt__";
    private static final Map<IRI, IRI> PROPERTY_RELATION;
    private static final Collection<IRI> ALL_PROPERTIES;

    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        PatternVisitor visitor = new PatternVisitor(bindings);
        tupleExpr.visit((QueryModelVisitor)visitor);
        int n = 0;
        for (StatementPattern pattern : visitor.patterns) {
            IRI pred = (IRI)PropertyToFunctionOptimizer.getValue(pattern.getPredicateVar(), bindings);
            if (PROPERTY_TO_FUNCTION.contains(pred)) {
                this.rewriteProperty(pattern, bindings, pred, n++);
                continue;
            }
            this.rewriteRelation(pattern, pred, n++);
        }
    }

    private void rewriteProperty(StatementPattern pattern, BindingSet bindings, IRI pred, int n) {
        String geo = "geo__priv__" + n + "__";
        Var object = pattern.getObjectVar();
        Value objValue = PropertyToFunctionOptimizer.getValue(object, bindings);
        Object replacement = new StatementPattern(pattern.getSubjectVar(), new Var(CONST_ASWKT, (Value)GeoConstants.GEO_AS_WKT), new Var(geo));
        replacement = objValue == null ? new Extension((TupleExpr)replacement, new ExtensionElem[]{new ExtensionElem((ValueExpr)new FunctionCall(pred.stringValue(), new ValueExpr[]{new Var(geo)}), object.getName())}) : new Filter((TupleExpr)replacement, (ValueExpr)new Compare((ValueExpr)new FunctionCall(pred.stringValue(), new ValueExpr[]{new Var(geo)}), (ValueExpr)new ValueConstant(objValue)));
        pattern.replaceWith((QueryModelNode)replacement);
    }

    private void rewriteRelation(StatementPattern pattern, IRI pred, int n) {
        String geo1 = "geo__priv__" + n + "a__";
        String geo2 = "geo__priv__" + n + "b__";
        String function = PROPERTY_RELATION.get(pred).stringValue();
        Filter replacement = new Filter((TupleExpr)new Join((TupleExpr)new StatementPattern(pattern.getSubjectVar(), new Var(CONST_ASWKT, (Value)GeoConstants.GEO_AS_WKT), new Var(geo1)), (TupleExpr)new StatementPattern(pattern.getObjectVar(), new Var(CONST_ASWKT, (Value)GeoConstants.GEO_AS_WKT), new Var(geo2))), (ValueExpr)new FunctionCall(function, new ValueExpr[]{new Var(geo1), new Var(geo2)}));
        pattern.replaceWith((QueryModelNode)replacement);
    }

    private static Value getValue(Var var, BindingSet bindings) {
        Value val = var.getValue();
        if (val == null) {
            val = bindings.getValue(var.getName());
        }
        return val;
    }

    static {
        PROPERTY_TO_FUNCTION.add(GeoConstants.GEO_DIMENSION);
        PROPERTY_TO_FUNCTION.add(GeoConstants.GEO_COORDINATE_DIMENSION);
        PROPERTY_TO_FUNCTION.add(GeoConstants.GEO_SPATIAL_DIMENSION);
        PROPERTY_TO_FUNCTION.add(GeoConstants.GEO_IS_EMPTY);
        PROPERTY_TO_FUNCTION.add(GeoConstants.GEO_IS_SIMPLE);
        PROPERTY_RELATION = new HashMap<IRI, IRI>();
        PROPERTY_RELATION.put(GeoConstants.GEO_SF_EQUALS, GeoConstants.GEOF_SF_EQUALS);
        PROPERTY_RELATION.put(GeoConstants.GEO_SF_DISJOINT, GeoConstants.GEOF_SF_DISJOINT);
        PROPERTY_RELATION.put(GeoConstants.GEO_SF_INTERSECTS, GeoConstants.GEOF_SF_INTERSECTS);
        PROPERTY_RELATION.put(GeoConstants.GEO_SF_TOUCHES, GeoConstants.GEOF_SF_TOUCHES);
        PROPERTY_RELATION.put(GeoConstants.GEO_SF_CROSSES, GeoConstants.GEOF_SF_CROSSES);
        PROPERTY_RELATION.put(GeoConstants.GEO_SF_WITHIN, GeoConstants.GEOF_SF_WITHIN);
        PROPERTY_RELATION.put(GeoConstants.GEO_SF_CONTAINS, GeoConstants.GEOF_SF_CONTAINS);
        PROPERTY_RELATION.put(GeoConstants.GEO_SF_OVERLAPS, GeoConstants.GEOF_SF_OVERLAPS);
        PROPERTY_RELATION.put(GeoConstants.GEO_EH_EQUALS, GeoConstants.GEO_EH_EQUALS);
        PROPERTY_RELATION.put(GeoConstants.GEO_EH_DISJOINT, GeoConstants.GEO_EH_DISJOINT);
        PROPERTY_RELATION.put(GeoConstants.GEO_EH_MEET, GeoConstants.GEO_EH_MEET);
        PROPERTY_RELATION.put(GeoConstants.GEO_EH_OVERLAP, GeoConstants.GEO_EH_OVERLAP);
        PROPERTY_RELATION.put(GeoConstants.GEO_EH_COVERS, GeoConstants.GEO_EH_COVERS);
        PROPERTY_RELATION.put(GeoConstants.GEO_EH_COVERED_BY, GeoConstants.GEO_EH_COVERED_BY);
        PROPERTY_RELATION.put(GeoConstants.GEO_EH_INSIDE, GeoConstants.GEO_EH_INSIDE);
        PROPERTY_RELATION.put(GeoConstants.GEO_EH_CONTAINS, GeoConstants.GEO_EH_CONTAINS);
        PROPERTY_RELATION.put(GeoConstants.GEO_RCC8_EQ, GeoConstants.GEO_RCC8_EQ);
        PROPERTY_RELATION.put(GeoConstants.GEO_RCC8_DC, GeoConstants.GEO_RCC8_DC);
        PROPERTY_RELATION.put(GeoConstants.GEO_RCC8_EC, GeoConstants.GEO_RCC8_EC);
        PROPERTY_RELATION.put(GeoConstants.GEO_RCC8_PO, GeoConstants.GEO_RCC8_PO);
        PROPERTY_RELATION.put(GeoConstants.GEO_RCC8_TPPI, GeoConstants.GEO_RCC8_TPPI);
        PROPERTY_RELATION.put(GeoConstants.GEO_RCC8_TPP, GeoConstants.GEO_RCC8_TPP);
        PROPERTY_RELATION.put(GeoConstants.GEO_RCC8_NTPP, GeoConstants.GEO_RCC8_NTPP);
        PROPERTY_RELATION.put(GeoConstants.GEO_RCC8_NTPPI, GeoConstants.GEO_RCC8_NTPPI);
        ALL_PROPERTIES = new HashSet<IRI>();
        ALL_PROPERTIES.addAll(PROPERTY_TO_FUNCTION);
        ALL_PROPERTIES.addAll(PROPERTY_RELATION.keySet());
    }

    private static final class PatternVisitor
    extends AbstractQueryModelVisitor<RuntimeException> {
        private BindingSet bindings;
        private List<StatementPattern> patterns = new ArrayList<StatementPattern>();

        private PatternVisitor(BindingSet bindings) {
            this.bindings = bindings;
        }

        public void meet(StatementPattern pattern) {
            Var pred = pattern.getPredicateVar();
            Value predVal = PropertyToFunctionOptimizer.getValue(pred, this.bindings);
            if (predVal instanceof IRI && ALL_PROPERTIES.contains(predVal)) {
                this.patterns.add(pattern);
            }
        }
    }
}

