/*
 * Decompiled with CFR 0.152.
 */
package com.useekm.geosparql;

import java.util.HashMap;
import java.util.Map;
import javax.measure.MetricPrefix;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import si.uom.SI;

public final class UnitsOfMeasure {
    public static final String NS_OGC = "http://www.opengis.net/def/uom/OGC/1.0/";
    public static final String NS_EXT_LENGTH = "http://rdf.useekm.com/uom/length/";
    public static final String CENTIMETRE = "cm";
    public static final IRI URI_CENTIMETRE = SimpleValueFactory.getInstance().createIRI("http://rdf.useekm.com/uom/length/cm");
    public static final String KILOMETRE = "km";
    public static final IRI URI_KILOMETRE = SimpleValueFactory.getInstance().createIRI("http://rdf.useekm.com/uom/length/km");
    public static final String MILLIMETRE = "mm";
    public static final IRI URI_MILLIMETRE = SimpleValueFactory.getInstance().createIRI("http://rdf.useekm.com/uom/length/mm");
    public static final String METRE = "metre";
    public static final IRI URI_METRE = SimpleValueFactory.getInstance().createIRI("http://www.opengis.net/def/uom/OGC/1.0/metre");
    public static final String FOOT = "ft";
    public static final IRI URI_FOOT = SimpleValueFactory.getInstance().createIRI("http://rdf.useekm.com/uom/length/ft");
    public static final String US_SURVEY_FOOT = "US_survey_ft";
    public static final IRI URI_US_SURVEY_FOOT = SimpleValueFactory.getInstance().createIRI("http://rdf.useekm.com/uom/length/US_survey_ft");
    public static final String INCH = "inch";
    public static final IRI URI_INCH = SimpleValueFactory.getInstance().createIRI("http://rdf.useekm.com/uom/length/inch");
    public static final String LIGHT_YEAR = "ly";
    public static final IRI URI_LIGHT_YEAR = SimpleValueFactory.getInstance().createIRI("http://rdf.useekm.com/uom/length/ly");
    public static final String MILE = "mile";
    public static final IRI URI_MILE = SimpleValueFactory.getInstance().createIRI("http://rdf.useekm.com/uom/length/mile");
    public static final String NAUTICAL_MILE = "NM";
    public static final IRI URI_NAUTICAL_MILE = SimpleValueFactory.getInstance().createIRI("http://rdf.useekm.com/uom/length/NM");
    public static final String YARD = "yd";
    public static final IRI URI_YARD = SimpleValueFactory.getInstance().createIRI("http://rdf.useekm.com/uom/length/yd");
    private static final Map<String, Unit<Length>> UNITS = new HashMap<String, Unit<Length>>();

    public static Unit<Length> getUnit(Value unitOfMeasure) {
        return unitOfMeasure instanceof IRI ? UNITS.get(unitOfMeasure.stringValue()) : null;
    }

    static {
        UNITS.put(URI_CENTIMETRE.stringValue(), (Unit<Length>)MetricPrefix.CENTI((Unit)SI.METRE));
        UNITS.put(URI_KILOMETRE.stringValue(), (Unit<Length>)MetricPrefix.KILO((Unit)SI.METRE));
        UNITS.put(URI_MILLIMETRE.stringValue(), (Unit<Length>)MetricPrefix.MILLI((Unit)SI.METRE));
        UNITS.put(URI_METRE.stringValue(), (Unit<Length>)SI.METRE);
        UNITS.put(URI_FOOT.stringValue(), (Unit<Length>)SI.METRE.multiply(0.3048));
        UNITS.put(URI_US_SURVEY_FOOT.stringValue(), (Unit<Length>)SI.METRE.multiply(0.3048006096012192));
        UNITS.put(URI_INCH.stringValue(), (Unit<Length>)SI.METRE.multiply(0.0254));
        UNITS.put(URI_LIGHT_YEAR.stringValue(), (Unit<Length>)SI.METRE.multiply(9.460528405E15));
        UNITS.put(URI_MILE.stringValue(), (Unit<Length>)SI.METRE.multiply(1609.344));
        UNITS.put(URI_NAUTICAL_MILE.stringValue(), (Unit<Length>)SI.METRE.multiply(1852.0));
        UNITS.put(URI_YARD.stringValue(), (Unit<Length>)SI.METRE.multiply(0.9144));
    }
}

