/*
 * Decompiled with CFR 0.152.
 */
package com.useekm.geosparql;

import com.useekm.geosparql.AbstractLiteralBinaryFunction;
import com.useekm.geosparql.UnitsOfMeasure;
import com.useekm.indexing.GeoConstants;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.referencing.GeodeticCalculator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.operation.distance.DistanceOp;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.operation.TransformException;
import si.uom.SI;

public class Distance
extends AbstractLiteralBinaryFunction {
    public String getURI() {
        return GeoConstants.GEOF_DISTANCE.stringValue();
    }

    @Override
    protected Literal evaluate(ValueFactory valueFactory, IRI getype, Geometry geom1, Geometry geom2, Value ... allArgs) throws ValueExprEvaluationException {
        if (allArgs.length == 3) {
            return this.computeDistanceinUnits(valueFactory, geom1, geom2, allArgs);
        }
        if (allArgs.length == 2) {
            return valueFactory.createLiteral(geom1.distance(geom2));
        }
        throw new ValueExprEvaluationException("Too many arguments for distance filter");
    }

    public Literal computeDistanceinUnits(ValueFactory valueFactory, Geometry geom1, Geometry geom2, Value ... allArgs) throws ValueExprEvaluationException {
        Value unitOfMeasure = allArgs[2];
        Unit<Length> unit = UnitsOfMeasure.getUnit(unitOfMeasure);
        if (unit == null) {
            throw new ValueExprEvaluationException("Not a valid length measure unit: " + String.valueOf(unitOfMeasure));
        }
        Coordinate[] points = DistanceOp.nearestPoints((Geometry)geom1, (Geometry)geom2);
        GeodeticCalculator gc = new GeodeticCalculator();
        try {
            gc.setStartingPosition((Position)new DirectPosition2D(points[0].x, points[0].y));
            gc.setDestinationPosition((Position)new DirectPosition2D(points[1].x, points[1].y));
            double distance = gc.getOrthodromicDistance();
            return valueFactory.createLiteral(unit == SI.METRE ? distance : SI.METRE.getConverterTo(unit).convert(distance));
        }
        catch (TransformException e) {
            throw new ValueExprEvaluationException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ValueExprEvaluationException((Throwable)e);
        }
    }
}

