/*
 * Decompiled with CFR 0.152.
 */
package com.useekm.geosparql;

import com.useekm.types.GeoConvert;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.TopologyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFunction
implements Function {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFunction.class);

    protected Geometry asGeometry(Value value) throws ValueExprEvaluationException {
        if (!(value instanceof Literal)) {
            throw new ValueExprEvaluationException("expected literal, found " + value.toString());
        }
        return GeoConvert.toGeometryExpr((Literal)value, true);
    }

    protected double asDouble(Value value) throws ValueExprEvaluationException {
        if (!(value instanceof Literal)) {
            throw new ValueExprEvaluationException("expected xsd:double, found " + value.toString());
        }
        try {
            return ((Literal)value).doubleValue();
        }
        catch (NumberFormatException e) {
            throw new ValueExprEvaluationException((Throwable)e);
        }
    }

    public abstract Value eval(ValueFactory var1, Value ... var2) throws ValueExprEvaluationException, TopologyException;

    public final Value evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        try {
            return this.eval(valueFactory, args);
        }
        catch (TopologyException e) {
            LOG.debug("Raising filter evaluation error due to invalid input geometry", (Throwable)e);
            throw new ValueExprEvaluationException((Throwable)e);
        }
    }
}

