/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.geosparql.gml;

import com.ontotext.trree.geosparql.conversion.CRSUtil;
import com.ontotext.trree.geosparql.conversion.TransformCoordinateFilter;
import com.useekm.types.exception.InvalidGeometryException;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.jvnet.ogc.gml.v_3_1_1.ObjectFactory;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Geometry;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;

public class GmlConverter {
    private Unmarshaller unmarshaller;
    private Marshaller marshaller;

    public GmlConverter() throws JAXBException {
        try {
            ClassLoader cl = ObjectFactory.class.getClassLoader();
            JAXBContext context = JAXBContext.newInstance((String)"org.jvnet.ogc.gml.v_3_1_1.jts", (ClassLoader)cl);
            this.unmarshaller = context.createUnmarshaller();
            this.marshaller = context.createMarshaller();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public Geometry gmlToGeometry(String literalValue) throws InvalidGeometryException {
        try {
            String shortId;
            Geometry g = (Geometry)this.unmarshaller.unmarshal((Reader)new StringReader(literalValue));
            String srsName = (String)g.getUserData();
            if (srsName != null && (shortId = CRSUtil.crsUriToShortId(srsName)) != null && !shortId.equals("CRS:84")) {
                MathTransform mathTransform = null;
                try {
                    mathTransform = CRSUtil.findMathTransform(shortId, "CRS:84");
                }
                catch (FactoryException e) {
                    throw new InvalidGeometryException("Unable to find SRS", e);
                }
                if (mathTransform != null) {
                    g.apply((CoordinateFilter)new TransformCoordinateFilter(mathTransform));
                    g.setSRID(4326);
                }
            }
            return g;
        }
        catch (JAXBException e) {
            throw new InvalidGeometryException("Invalid GML geometry", e);
        }
    }

    public String geometryToGml(Geometry g) {
        try {
            StringWriter sw = new StringWriter();
            this.marshaller.marshal((Object)g, (Writer)sw);
            return sw.toString();
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unable to serialize to GML", e);
        }
    }
}

