/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.geosparql.conversion;

import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.function.DefaultNumberSystem;
import tech.units.indriya.spi.NumberSystem;

public class CRSUtil {
    public static final String TARGET_CRS = "CRS:84";
    private static final String EPSG_PREFIX = "http://www.opengis.net/def/crs/EPSG/0/";
    private static final String CRS84 = "http://www.opengis.net/def/crs/OGC/1.3/CRS84";

    public static String crsUriToShortId(String uri) {
        if (CRS84.equals(uri)) {
            return TARGET_CRS;
        }
        if (uri.startsWith(EPSG_PREFIX)) {
            return "EPSG:" + uri.substring(EPSG_PREFIX.length());
        }
        return null;
    }

    public static MathTransform findMathTransform(String sourceCRS, String targetCRS) throws FactoryException {
        CoordinateReferenceSystem dst;
        CoordinateReferenceSystem src = CRS.decode((String)sourceCRS);
        if (!src.equals((Object)(dst = CRS.decode((String)targetCRS)))) {
            return CRS.findMathTransform((CoordinateReferenceSystem)src, (CoordinateReferenceSystem)dst);
        }
        return null;
    }

    static {
        Calculus.setCurrentNumberSystem((NumberSystem)new DefaultNumberSystem());
    }
}

