/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.geosparql;

import com.useekm.geosparql.AbstractBooleanBinaryFunction;
import com.useekm.geosparql.Contains;
import com.useekm.geosparql.Crosses;
import com.useekm.geosparql.Disjoint;
import com.useekm.geosparql.EhContains;
import com.useekm.geosparql.EhCoveredBy;
import com.useekm.geosparql.EhCovers;
import com.useekm.geosparql.EhDisjoint;
import com.useekm.geosparql.EhEquals;
import com.useekm.geosparql.EhInside;
import com.useekm.geosparql.EhMeet;
import com.useekm.geosparql.EhOverlap;
import com.useekm.geosparql.Equals;
import com.useekm.geosparql.Intersects;
import com.useekm.geosparql.Overlaps;
import com.useekm.geosparql.Rcc8dc;
import com.useekm.geosparql.Rcc8ec;
import com.useekm.geosparql.Rcc8eq;
import com.useekm.geosparql.Rcc8ntpp;
import com.useekm.geosparql.Rcc8ntppi;
import com.useekm.geosparql.Rcc8po;
import com.useekm.geosparql.Rcc8tpp;
import com.useekm.geosparql.Rcc8tppi;
import com.useekm.geosparql.Touches;
import com.useekm.geosparql.Within;
import com.useekm.indexing.GeoConstants;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.eclipse.rdf4j.model.IRI;
import org.locationtech.jts.geom.Geometry;

public enum GeoSparqlFunction {
    SF_EQUALS(Equals.class, GeoConstants.GEO_SF_EQUALS, SpatialOperation.IsEqualTo),
    SF_DISJOINT(Disjoint.class, GeoConstants.GEO_SF_DISJOINT, SpatialOperation.IsDisjointTo),
    SF_INTERSECTS(Intersects.class, GeoConstants.GEO_SF_INTERSECTS, SpatialOperation.Intersects),
    SF_TOUCHES(Touches.class, GeoConstants.GEO_SF_TOUCHES, SpatialOperation.Intersects),
    SF_WITHIN(Within.class, GeoConstants.GEO_SF_WITHIN, SpatialOperation.IsWithin),
    SF_CONTAINS(Contains.class, GeoConstants.GEO_SF_CONTAINS, SpatialOperation.Contains),
    SF_OVERLAPS(Overlaps.class, GeoConstants.GEO_SF_OVERLAPS, SpatialOperation.Overlaps),
    SF_CROSSES(Crosses.class, GeoConstants.GEO_SF_CROSSES, SpatialOperation.Intersects),
    EH_EQUALS(EhEquals.class, GeoConstants.GEO_EH_EQUALS, SpatialOperation.IsEqualTo),
    EH_DISJOINT(EhDisjoint.class, GeoConstants.GEO_EH_DISJOINT, SpatialOperation.IsDisjointTo),
    EH_MEET(EhMeet.class, GeoConstants.GEO_EH_MEET, SpatialOperation.Intersects),
    EH_OVERLAP(EhOverlap.class, GeoConstants.GEO_EH_OVERLAP, SpatialOperation.Overlaps),
    EH_COVERS(EhCovers.class, GeoConstants.GEO_EH_COVERS, SpatialOperation.Contains),
    EH_COVERED_BY(EhCoveredBy.class, GeoConstants.GEO_EH_COVERED_BY, SpatialOperation.IsWithin),
    EH_INSIDE(EhInside.class, GeoConstants.GEO_EH_INSIDE, SpatialOperation.IsWithin),
    EH_CONTAINS(EhContains.class, GeoConstants.GEO_EH_CONTAINS, SpatialOperation.Contains),
    RCC8_EQ(Rcc8eq.class, GeoConstants.GEO_RCC8_EQ, SpatialOperation.IsEqualTo),
    RCC8_DC(Rcc8dc.class, GeoConstants.GEO_RCC8_DC, SpatialOperation.IsDisjointTo),
    RCC8_EC(Rcc8ec.class, GeoConstants.GEO_RCC8_EC, SpatialOperation.Intersects),
    RCC8_PO(Rcc8po.class, GeoConstants.GEO_RCC8_PO, SpatialOperation.Overlaps),
    RCC8_TPPI(Rcc8tppi.class, GeoConstants.GEO_RCC8_TPPI, SpatialOperation.Contains),
    RCC8_TPP(Rcc8tpp.class, GeoConstants.GEO_RCC8_TPP, SpatialOperation.IsWithin),
    RCC8_NTPP(Rcc8ntpp.class, GeoConstants.GEO_RCC8_NTPP, SpatialOperation.IsWithin),
    RCC8_NTPPI(Rcc8ntppi.class, GeoConstants.GEO_RCC8_NTPPI, SpatialOperation.Contains);

    private static final Map<SpatialOperation, SpatialOperation> INVERSE_SPATIAL_OPERATIONS;
    private final AbstractBooleanBinaryFunction functionImplementation;
    private final IRI predicateUri;
    private SpatialOperation spatialOperation;

    private GeoSparqlFunction(Class<? extends AbstractBooleanBinaryFunction> functionClass, IRI predicateUri, SpatialOperation spatialOperation) {
        try {
            this.functionImplementation = functionClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        this.predicateUri = predicateUri;
        this.spatialOperation = spatialOperation;
    }

    public IRI getPredicateUri() {
        return this.predicateUri;
    }

    public SpatialOperation getSpatialOperation() {
        return this.spatialOperation;
    }

    public SpatialOperation getInverseSpatialOperation() {
        return INVERSE_SPATIAL_OPERATIONS.get(this.spatialOperation);
    }

    public boolean evaluate(Geometry argument1, Geometry argument2) {
        return this.functionImplementation.evaluate(argument1, argument2);
    }

    static {
        INVERSE_SPATIAL_OPERATIONS = new HashMap<SpatialOperation, SpatialOperation>();
        INVERSE_SPATIAL_OPERATIONS.put(SpatialOperation.IsEqualTo, SpatialOperation.IsEqualTo);
        INVERSE_SPATIAL_OPERATIONS.put(SpatialOperation.IsDisjointTo, SpatialOperation.IsDisjointTo);
        INVERSE_SPATIAL_OPERATIONS.put(SpatialOperation.Intersects, SpatialOperation.Intersects);
        INVERSE_SPATIAL_OPERATIONS.put(SpatialOperation.IsWithin, SpatialOperation.Contains);
        INVERSE_SPATIAL_OPERATIONS.put(SpatialOperation.Contains, SpatialOperation.IsWithin);
        INVERSE_SPATIAL_OPERATIONS.put(SpatialOperation.Overlaps, SpatialOperation.Overlaps);
    }
}

