/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.geosparql;

import com.ontotext.trree.geosparql.GeoSparqlPlugin;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.StatementIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rdf4j.model.Value;

class GeoSparqlConfigIterator
extends StatementIterator {
    private GeoSparqlPlugin plugin;
    private Entities entities;
    private long[] predicates;
    private int index;

    GeoSparqlConfigIterator(GeoSparqlPlugin plugin, long predicate, Entities entities) {
        this(plugin, predicate, 0L, entities);
    }

    GeoSparqlConfigIterator(GeoSparqlPlugin plugin, long predicate, long object, Entities entities) {
        this.plugin = plugin;
        this.entities = entities;
        this.predicates = predicate == 0L ? (object == 0L ? new long[]{plugin.enabledPredicateId, plugin.prefixTreePredicateId, plugin.precisionPredicateId, plugin.currentPrefixTreePredicateId, plugin.currentPrecisionPredicateId, plugin.maxBufferedDocsPredicateId, plugin.ramBufferSizePredicateId, plugin.ignoreErrorsPredicateId} : this.getPredicateFromObjectValue(entities.get(object))) : new long[]{predicate};
        this.subject = plugin.contextId;
    }

    public boolean next() {
        if (this.index < this.predicates.length) {
            this.predicate = this.predicates[this.index];
            if (this.predicate == this.plugin.enabledPredicateId) {
                this.object = this.entities.put((Value)GeoSparqlPlugin.VALUE_FACTORY.createLiteral(this.plugin.getConfig().isEnabled()), Entities.Scope.REQUEST);
            } else if (this.predicate == this.plugin.prefixTreePredicateId) {
                this.object = this.entities.put((Value)this.plugin.getConfig().getPrefixTree().toLiteral(), Entities.Scope.REQUEST);
            } else if (this.predicate == this.plugin.precisionPredicateId) {
                this.object = this.entities.put((Value)GeoSparqlPlugin.VALUE_FACTORY.createLiteral(this.plugin.getConfig().getPrecision()), Entities.Scope.REQUEST);
            } else if (this.predicate == this.plugin.currentPrefixTreePredicateId) {
                this.object = this.entities.put((Value)this.plugin.getConfig().getCurrentPrefixTree().toLiteral(), Entities.Scope.REQUEST);
            } else if (this.predicate == this.plugin.currentPrecisionPredicateId) {
                this.object = this.entities.put((Value)GeoSparqlPlugin.VALUE_FACTORY.createLiteral(this.plugin.getConfig().getCurrentPrecision()), Entities.Scope.REQUEST);
            } else if (this.predicate == this.plugin.maxBufferedDocsPredicateId) {
                this.object = this.entities.put((Value)GeoSparqlPlugin.VALUE_FACTORY.createLiteral(this.plugin.getConfig().getMaxBufferedDocs()), Entities.Scope.REQUEST);
            } else if (this.predicate == this.plugin.ramBufferSizePredicateId) {
                this.object = this.entities.put((Value)GeoSparqlPlugin.VALUE_FACTORY.createLiteral(this.plugin.getConfig().getRamBufferSizeMb()), Entities.Scope.REQUEST);
            } else if (this.predicate == this.plugin.ignoreErrorsPredicateId) {
                this.object = this.entities.put((Value)GeoSparqlPlugin.VALUE_FACTORY.createLiteral(this.plugin.getConfig().isIgnoreErrors()), Entities.Scope.REQUEST);
            }
            ++this.index;
            return true;
        }
        return false;
    }

    public void close() {
    }

    private long[] getPredicateFromObjectValue(Value objectValue) {
        ArrayList<Long> predicatesList = new ArrayList<Long>();
        for (Map.Entry<Object, Object> propertiesValues : this.plugin.getConfig().getAsProperties().entrySet()) {
            if (!objectValue.stringValue().equalsIgnoreCase(propertiesValues.getValue().toString())) continue;
            predicatesList.add(this.getPluginPredicateFromConfigKey(propertiesValues.getKey().toString()));
        }
        return predicatesList.stream().mapToLong(i -> i).toArray();
    }

    private long getPluginPredicateFromConfigKey(String propertyKey) {
        HashMap<String, Long> mappedPropertiesKeyToPluginPredicates = new HashMap<String, Long>();
        mappedPropertiesKeyToPluginPredicates.put("enabled", this.plugin.enabledPredicateId);
        mappedPropertiesKeyToPluginPredicates.put("prefixtree.current", this.plugin.currentPrefixTreePredicateId);
        mappedPropertiesKeyToPluginPredicates.put("precision.current", this.plugin.currentPrecisionPredicateId);
        mappedPropertiesKeyToPluginPredicates.put("prefixtree", this.plugin.prefixTreePredicateId);
        mappedPropertiesKeyToPluginPredicates.put("precision", this.plugin.precisionPredicateId);
        mappedPropertiesKeyToPluginPredicates.put("maxBufferedDocs", this.plugin.maxBufferedDocsPredicateId);
        mappedPropertiesKeyToPluginPredicates.put("ramBufferSizeMB", this.plugin.ramBufferSizePredicateId);
        mappedPropertiesKeyToPluginPredicates.put("ignoreErrors", this.plugin.ignoreErrorsPredicateId);
        return (Long)mappedPropertiesKeyToPluginPredicates.get(propertyKey);
    }
}

