/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.geosparql;

import com.ontotext.trree.sdk.PluginException;
import java.nio.file.Path;
import java.util.Properties;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class GeoSparqlConfig {
    private static final String VERSION = "3";
    private static final String LEGACY_VERSION = "2";
    private static final String PLUGIN_CONFIG_FILENAME = "config.properties";
    private static final String INDEX_DIRECTORY = "index";
    static final String ENABLED_KEY = "enabled";
    static final String CURRENT_PREFIXTREE_KEY = "prefixtree.current";
    static final String CURRENT_PRECISION = "precision.current";
    static final String PREFIXTREE_KEY = "prefixtree";
    static final String PRECISION_KEY = "precision";
    static final String IGNORE_ERRORS_KEY = "ignoreErrors";
    static final String MAX_BUFFERED_DOCS_KEY = "maxBufferedDocs";
    static final String RAM_BUFFER_SIZE_MB_KEY = "ramBufferSizeMB";
    static final boolean ENABLED_DEFAULT = false;
    static final PrefixTree PREFIXTREE_DEFAULT = PrefixTree.QUAD;
    static final int PRECISION_DEFAULT = 11;
    static final boolean IGNORE_ERRORS_DEFAULT = false;
    static final int MAX_BUFFERED_DOCS_DEFAULT = 1000;
    static final double RAM_BUFFER_SIZE_MB_DEFAULT = 32.0;
    private static final double MIN_RAM_BUFFER_SIZE_MB = 16.0;
    private static final int MAX_BUFFERED_DOCS = 5000;
    private static final double MAX_RAM_BUFFER_SIZE_MB = 512.0;
    private boolean enabled = false;
    private PrefixTree currentPrefixTree = PREFIXTREE_DEFAULT;
    private int currentPrecision = 11;
    private PrefixTree prefixTree = PREFIXTREE_DEFAULT;
    private int precision = 11;
    private boolean ignoreErrors = false;
    private int maxBufferedDocs = 1000;
    private double ramBufferSizeMb = 32.0;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public PrefixTree getPrefixTree() {
        return this.prefixTree;
    }

    public void setPrefixTree(PrefixTree prefixTree) {
        this.prefixTree = prefixTree;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getMaxBufferedDocs() {
        return this.maxBufferedDocs;
    }

    public void setMaxBufferedDocs(int maxBufferedDocs) {
        if (maxBufferedDocs <= 0 || maxBufferedDocs > 5000) {
            throw new PluginException("MaxBufferedDocs value should not be greater than 5000");
        }
        this.maxBufferedDocs = maxBufferedDocs;
    }

    public double getRamBufferSizeMb() {
        return this.ramBufferSizeMb;
    }

    public void setRamBufferSizeMb(double ramBufferSizeMb) {
        if (!(ramBufferSizeMb >= 16.0) || !(ramBufferSizeMb <= 512.0)) {
            throw new PluginException("RamBufferSizeMb value should be in range of 16.0 to 512.0");
        }
        this.ramBufferSizeMb = ramBufferSizeMb;
    }

    public PrefixTree getCurrentPrefixTree() {
        return this.currentPrefixTree;
    }

    public int getCurrentPrecision() {
        return this.currentPrecision;
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    public void setFromProperties(Properties properties) {
        this.enabled = Boolean.parseBoolean(properties.getProperty(ENABLED_KEY, Boolean.toString(false)));
        this.ignoreErrors = Boolean.parseBoolean(properties.getProperty(IGNORE_ERRORS_KEY, Boolean.toString(false)));
        try {
            this.prefixTree = PrefixTree.valueOf(properties.getProperty(PREFIXTREE_KEY, PREFIXTREE_DEFAULT.name()).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.prefixTree = PREFIXTREE_DEFAULT;
        }
        try {
            this.precision = Integer.parseInt(properties.getProperty(PRECISION_KEY, Integer.toString(11)));
        }
        catch (NumberFormatException e) {
            this.precision = 11;
        }
        try {
            this.currentPrefixTree = PrefixTree.valueOf(properties.getProperty(CURRENT_PREFIXTREE_KEY, PREFIXTREE_DEFAULT.name()).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.currentPrefixTree = PREFIXTREE_DEFAULT;
        }
        try {
            this.currentPrecision = Integer.parseInt(properties.getProperty(CURRENT_PRECISION, Integer.toString(11)));
        }
        catch (NumberFormatException e) {
            this.currentPrecision = 11;
        }
        try {
            this.maxBufferedDocs = Integer.parseInt(properties.getProperty(MAX_BUFFERED_DOCS_KEY, Integer.toString(1000)));
        }
        catch (NumberFormatException e) {
            this.maxBufferedDocs = 1000;
        }
        try {
            this.ramBufferSizeMb = Double.parseDouble(properties.getProperty(RAM_BUFFER_SIZE_MB_KEY, Double.toString(32.0)));
        }
        catch (NumberFormatException e) {
            this.ramBufferSizeMb = 32.0;
        }
    }

    public Properties getAsProperties() {
        Properties properties = new Properties();
        properties.setProperty(ENABLED_KEY, Boolean.toString(this.enabled));
        properties.setProperty(PREFIXTREE_KEY, this.prefixTree.name());
        properties.setProperty(PRECISION_KEY, Integer.toString(this.precision));
        properties.setProperty(CURRENT_PREFIXTREE_KEY, this.currentPrefixTree.name());
        properties.setProperty(CURRENT_PRECISION, Integer.toString(this.currentPrecision));
        properties.setProperty(IGNORE_ERRORS_KEY, Boolean.toString(this.ignoreErrors));
        properties.setProperty(MAX_BUFFERED_DOCS_KEY, Integer.toString(this.maxBufferedDocs));
        properties.setProperty(RAM_BUFFER_SIZE_MB_KEY, Double.toString(this.ramBufferSizeMb));
        return properties;
    }

    public void updateCurrentSettings() {
        this.currentPrecision = this.precision;
        this.currentPrefixTree = this.prefixTree;
    }

    public static Path resolveLegacyConfigPath(Path pluginDataDir) {
        return pluginDataDir.resolve("v2").resolve(PLUGIN_CONFIG_FILENAME);
    }

    public static Path resolveConfigPath(Path pluginDataDir) {
        return pluginDataDir.resolve("v3").resolve(PLUGIN_CONFIG_FILENAME);
    }

    public static Path resolveIndexPath(Path pluginDataDir) {
        return pluginDataDir.resolve("v3").resolve(INDEX_DIRECTORY);
    }

    public static enum PrefixTree {
        GEOHASH(SimpleValueFactory.getInstance().createLiteral("geohash")),
        QUAD(SimpleValueFactory.getInstance().createLiteral("quad"));

        private Literal literal;

        private PrefixTree(Literal literal) {
            this.literal = literal;
        }

        public Literal toLiteral() {
            return this.literal;
        }
    }
}

