/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.viz;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JFrame;
import javax.swing.JPanel;
import pitt.search.semanticvectors.ObjectVector;
import pitt.search.semanticvectors.vectors.RealVector;

public class Plot2dVectors
extends JPanel {
    ObjectVector[] vectors;
    static final int scale = 500;
    static final int pad = 50;
    static final int comp1 = 1;
    static final int comp2 = 2;
    static final int maxplot = 50;
    public final boolean PRINT_TEX_OUTPUT = false;

    public Plot2dVectors(ObjectVector[] vectors) {
        System.err.println("Constructing plotter ...");
        this.vectors = vectors;
        this.setSize(new Dimension(600, 600));
    }

    @Override
    public void paintComponent(Graphics g) {
        float[] tmpVec;
        RealVector realVector;
        int i;
        float min2 = 100.0f;
        float min1 = 100.0f;
        float max2 = -100.0f;
        float max1 = -100.0f;
        for (i = 0; i < this.vectors.length; ++i) {
            realVector = (RealVector)this.vectors[i].getVector();
            tmpVec = realVector.getCoordinates();
            if (tmpVec[1] < min1) {
                min1 = tmpVec[1];
            }
            if (tmpVec[2] < min2) {
                min2 = tmpVec[2];
            }
            if (tmpVec[1] > max1) {
                max1 = tmpVec[1];
            }
            if (tmpVec[2] > max2) {
                max2 = tmpVec[2];
            }
            if (i > 50) break;
        }
        System.err.println("Painting component ...");
        for (i = 0; i < this.vectors.length; ++i) {
            realVector = (RealVector)this.vectors[i].getVector();
            tmpVec = realVector.getCoordinates();
            int c1 = 25 + Math.round(500.0f * (tmpVec[1] - min1) / (max1 - min1));
            int c2 = 25 + Math.round(500.0f * (tmpVec[2] - min2) / (max2 - min2));
            g.drawString(this.vectors[i].getObject().toString(), c1, c2);
            if (i > 50) break;
        }
        System.err.println("Finished painting component ...");
    }

    public void createAndShowGUI() {
        JFrame frame = new JFrame("Term Vector Plotter");
        frame.setSize(new Dimension(600, 600));
        frame.setDefaultCloseOperation(3);
        System.err.println("Trying to set content pane ...");
        frame.setContentPane(this);
        frame.setVisible(true);
    }
}

