/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.viz;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.index.Term;
import pitt.search.semanticvectors.CloseableVectorStore;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.LuceneUtils;
import pitt.search.semanticvectors.SearchResult;
import pitt.search.semanticvectors.VectorSearcher;
import pitt.search.semanticvectors.VectorStore;
import pitt.search.semanticvectors.VectorStoreRAM;
import pitt.search.semanticvectors.VectorStoreReader;
import pitt.search.semanticvectors.VectorStoreUtils;
import pitt.search.semanticvectors.utils.VerbatimLogger;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.ZeroVectorException;

public class PathFinder {
    double[][] dis;
    double[][] mindis;
    double[][] pruned;
    int[][] changedatq;
    int q;
    int r;
    int rows;
    int columns;

    public double[][] MinDis(double[][] links) {
        int y;
        int x;
        int n = links.length;
        double[][] mindis = new double[links.length][links.length];
        for (x = 0; x < links.length; ++x) {
            for (y = 0; y < links.length; ++y) {
                mindis[x][y] = links[x][y] > 0.0 | links[y][x] > 0.0 ? 1.0 : 2.147483647E9;
                if (x != y) continue;
                mindis[x][y] = 0.0;
            }
        }
        for (int ind = 0; ind < n; ++ind) {
            for (int row = 0; row < n; ++row) {
                for (int col = 0; col < n; ++col) {
                    double indirect = mindis[row][ind] + mindis[ind][col];
                    if (!(indirect < mindis[row][col])) continue;
                    mindis[row][col] = indirect;
                }
            }
        }
        for (x = 0; x < links.length; ++x) {
            for (y = 0; y < links.length; ++y) {
                if (mindis[x][y] != 2.147483647E9) continue;
                mindis[x][y] = links.length / 2;
            }
        }
        return mindis;
    }

    public PathFinder(int q, double r, double[][] dish) {
        int pass;
        int col;
        int row;
        int n = dish.length;
        q = Math.min(q, n - 1);
        this.dis = new double[n][n];
        this.mindis = new double[n][n];
        this.changedatq = new int[n][n];
        for (row = 0; row < n; ++row) {
            for (col = 0; col < n; ++col) {
                this.dis[row][col] = 1.0 - dish[row][col];
                this.mindis[row][col] = 1.0 - dish[row][col];
            }
        }
        if (q > n - 2) {
            pass = 1;
            for (int ind = 0; ind < n; ++ind) {
                for (int row2 = 0; row2 < n; ++row2) {
                    for (int col2 = 0; col2 < n; ++col2) {
                        double indirect = this.minkowski(this.mindis[row2][ind], this.mindis[ind][col2], r);
                        if (!(this.mindis[row2][col2] - indirect > 1.0E-10)) continue;
                        this.mindis[row2][col2] = indirect;
                        this.changedatq[row2][col2] = pass;
                    }
                }
            }
        } else {
            pass = 1;
            boolean changed = true;
            while (changed && pass < q) {
                ++pass;
                changed = false;
                double[][] m = (double[][])this.mindis.clone();
                for (int row3 = 0; row3 < n; ++row3) {
                    for (int col3 = 0; col3 < n; ++col3) {
                        for (int ind = 0; ind < n; ++ind) {
                            double indirect2;
                            double indirect1 = this.minkowski(this.dis[row3][ind], m[ind][col3], r);
                            double indirect = Math.min(indirect1, indirect2 = this.minkowski(m[row3][ind], this.dis[ind][col3], r));
                            if (!(this.mindis[row3][col3] - indirect > 1.0E-10)) continue;
                            this.mindis[row3][col3] = indirect;
                            this.changedatq[row3][col3] = pass;
                            changed = true;
                        }
                    }
                }
            }
        }
        this.pruned = new double[n][n];
        for (row = 0; row < n; ++row) {
            for (col = 0; col < n; ++col) {
                if (this.mindis[row][col] != this.dis[row][col]) continue;
                this.pruned[row][col] = 1.0 - this.dis[row][col];
            }
        }
    }

    double minkowski(double x, double y, double r) {
        double temp = 0.0;
        if (r == Double.POSITIVE_INFINITY || Math.min(x, y) == 0.0) {
            return Math.max(x, y);
        }
        if (r == 1.0) {
            return x + y;
        }
        temp = Math.pow(Math.pow(x, r) + Math.pow(y, r), 1.0 / r);
        return temp;
    }

    public double[][] pruned() {
        return this.pruned;
    }

    int[][] changedatq() {
        return this.changedatq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void pathfinderWriterWrapper(FlagConfig flagConfig, List<SearchResult> searchResults) throws IOException {
        if (flagConfig.boundvectorfile().isEmpty() || flagConfig.elementalvectorfile().equals("elementalvectors") || flagConfig.semanticvectorfile().equals("semanticvectors")) {
            PathFinder.writeResultsPathfinderGraphJson(flagConfig, searchResults);
            return;
        }
        VectorStoreRAM elementalVectors = new VectorStoreRAM(flagConfig);
        elementalVectors.initFromFile(flagConfig.elementalvectorfile());
        VectorStoreRAM semanticVectors = new VectorStoreRAM(flagConfig);
        semanticVectors.initFromFile(flagConfig.semanticvectorfile());
        VectorStoreRAM predicateVectors = new VectorStoreRAM(flagConfig);
        predicateVectors.initFromFile(flagConfig.elementalpredicatevectorfile());
        CloseableVectorStore semanticVecReader = null;
        CloseableVectorStore elementalVecReader = null;
        CloseableVectorStore boundVecReader = null;
        LuceneUtils luceneUtils = null;
        try {
            semanticVecReader = VectorStoreReader.openVectorStore(flagConfig.semanticvectorfile(), flagConfig);
            elementalVecReader = VectorStoreReader.openVectorStore(flagConfig.elementalvectorfile(), flagConfig);
            boundVecReader = VectorStoreReader.openVectorStore(flagConfig.boundvectorfile(), flagConfig);
            luceneUtils = new LuceneUtils(flagConfig);
            PathFinder.writeResultsPathfinderGraphJson(flagConfig, searchResults, semanticVecReader, elementalVecReader, boundVecReader, luceneUtils);
        }
        catch (Throwable throwable) {
            VectorStoreUtils.closeVectorStores(semanticVecReader, boundVecReader, elementalVecReader);
            if (luceneUtils == null) throw throwable;
            luceneUtils.closeLuceneDir();
            throw throwable;
        }
        VectorStoreUtils.closeVectorStores(semanticVecReader, boundVecReader, elementalVecReader);
        if (luceneUtils == null) return;
        luceneUtils.closeLuceneDir();
    }

    public static void writeResultsPathfinderGraphJson(FlagConfig flagConfig, List<SearchResult> results) throws IOException {
        BufferedWriter writer = null;
        File jsonFile = new File(flagConfig.jsonfile());
        VerbatimLogger.info("Writing graph in json format to ...  " + jsonFile.getCanonicalPath() + "\n");
        writer = new BufferedWriter(new FileWriter(jsonFile));
        writer.write("{\"nodes\":[\n");
        for (int z = 0; z < results.size(); ++z) {
            writer.write("{\"name\":\"" + results.get(z).getObjectVector().getObject() + "\",\"group\":1}");
            if (z >= results.size() - 1) continue;
            writer.write(",");
        }
        writer.write("],\n");
        writer.write("\"links\":[\n");
        double[][] links = new double[results.size()][results.size()];
        for (int x = 0; x < results.size(); ++x) {
            for (int y = 0; y < results.size(); ++y) {
                links[y][x] = results.get(y).getObjectVector().getVector().measureOverlap(results.get(x).getObjectVector().getVector());
            }
        }
        int q = flagConfig.pathfinderQ();
        if (q == -1) {
            q = results.size() - 1;
        }
        double r = flagConfig.pathfinderR();
        PathFinder scout = new PathFinder(q, r, links);
        links = scout.pruned();
        for (int x = 0; x < results.size() - 1; ++x) {
            for (int y = x + 1; y < results.size(); ++y) {
                if (!(links[y][x] > 0.0)) continue;
                if (x > 0 || y > x + 1) {
                    writer.write(",");
                }
                writer.write("{\"source\":" + y + ",\"target\":" + x + ",\"value\":" + links[y][x] + "}\n");
            }
        }
        writer.write("  ]\n}");
        writer.close();
    }

    public static void writeResultsPathfinderGraphJson(FlagConfig flagConfig, List<SearchResult> results, VectorStore semanticvectors, VectorStore elementalvectors, VectorStore predicatevectors, LuceneUtils lUtils) throws IOException {
        BufferedWriter writer = null;
        File jsonFile = new File(flagConfig.jsonfile());
        VerbatimLogger.info("Writing graph in json format to ...  " + jsonFile.getCanonicalPath() + "\n");
        writer = new BufferedWriter(new FileWriter(jsonFile));
        writer.write("{\"nodes\":[\n");
        HashSet<String> onList = new HashSet<String>();
        ArrayList<Vector> resultsemanticVectors = new ArrayList<Vector>();
        ArrayList<Vector> resultelementalVectors = new ArrayList<Vector>();
        for (int z = 0; z < results.size(); ++z) {
            onList.add(results.get(z).getObjectVector().getObject().toString());
            resultsemanticVectors.add(semanticvectors.getVector(results.get(z).getObjectVector().getObject().toString()));
            resultelementalVectors.add(elementalvectors.getVector(results.get(z).getObjectVector().getObject().toString()));
            writer.write("{\"name\":\"" + results.get(z).getObjectVector().getObject() + "\",\"group\":1}");
            writer.write(",");
        }
        double[][] links = new double[results.size()][results.size()];
        String[][] predicate = new String[results.size()][results.size()];
        String linkString = "";
        for (int x = 0; x < results.size(); ++x) {
            for (int y = 0; y < results.size(); ++y) {
                if (x == y) continue;
                Vector queryVector = ((Vector)resultsemanticVectors.get(y)).copy();
                Vector boundVector = ((Vector)resultelementalVectors.get(x)).copy();
                queryVector.bind(boundVector);
                try {
                    String pred;
                    VectorSearcher.VectorSearcherBoundProduct predicateFinder = new VectorSearcher.VectorSearcherBoundProduct(semanticvectors, predicatevectors, null, flagConfig, queryVector);
                    LinkedList<SearchResult> bestPredicates = predicateFinder.getNearestNeighbors(1);
                    if (bestPredicates.size() <= 0) continue;
                    predicate[y][x] = pred = ((SearchResult)bestPredicates.get(0)).getObjectVector().getObject().toString();
                    links[y][x] = ((SearchResult)bestPredicates.get(0)).getScore();
                    continue;
                }
                catch (ZeroVectorException e) {
                    e.printStackTrace();
                }
            }
        }
        linkString = linkString + "],\n";
        linkString = linkString + "\"links\":[\n";
        int q = flagConfig.pathfinderQ();
        if (q == -1) {
            q = results.size() - 1;
        }
        double r = flagConfig.pathfinderR();
        PathFinder scout = new PathFinder(q, r, links);
        links = scout.pruned();
        boolean wroteone = false;
        int nodecount = results.size() - 1;
        for (int x = 0; x < results.size(); ++x) {
            for (int y = 0; y < results.size(); ++y) {
                if (x == y || !(links[y][x] > 0.0) || !(links[y][x] > links[x][y])) continue;
                String subject = results.get(y).getObjectVector().getObject().toString();
                String object = results.get(x).getObjectVector().getObject().toString();
                if (lUtils.getDocsForTerm(new Term("predication", subject + predicate[y][x].replaceAll("-INV", "") + object)) == null && lUtils.getDocsForTerm(new Term("predication", object + predicate[y][x].replaceAll("-INV", "") + subject)) == null) continue;
                System.err.println(subject + predicate[y][x] + object);
                if (wroteone) {
                    linkString = linkString + ",";
                    writer.write(",");
                }
                if (predicate[y][x].endsWith("INV")) {
                    writer.write("{\"name\":\"" + predicate[y][x].replaceAll("-INV", "") + "\",\"group\":2}");
                    linkString = linkString + "{\"source\":" + x + ",\"target\":" + ++nodecount + ",\"value\":" + links[y][x] + "},\n";
                    linkString = linkString + "{\"source\":" + nodecount + ",\"target\":" + y + ",\"value\":" + links[y][x] + "}\n";
                    wroteone = true;
                    continue;
                }
                writer.write("{\"name\":\"" + predicate[y][x] + "\",\"group\":2}");
                linkString = linkString + "{\"source\":" + y + ",\"target\":" + ++nodecount + ",\"value\":" + links[y][x] + "},\n";
                linkString = linkString + "{\"source\":" + nodecount + ",\"target\":" + x + ",\"value\":" + links[y][x] + "}\n";
                wroteone = true;
            }
        }
        writer.write(linkString);
        writer.write("  ]\n}");
        writer.close();
    }

    public static void main(String[] args) {
        double[][] testfl = new double[][]{{1.0, 0.95f, 0.24f}, {0.95f, 1.0, 0.95f}, {0.24f, 0.95f, 1.0}};
        PathFinder pf = new PathFinder(8, 1.0, testfl);
        double[][] pruned = pf.pruned();
        int[][] changedatq = pf.changedatq();
        System.out.println("pruned");
        for (int x = 0; x < pruned.length; ++x) {
            for (int y = 0; y < pruned.length; ++y) {
                System.out.print(pruned[x][y] + ":" + changedatq[x][y] + " ");
            }
            System.out.println();
        }
    }
}

