/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.vectors;

import java.util.logging.Logger;

public final class CircleLookupTable {
    public static Logger logger = Logger.getLogger(CircleLookupTable.class.getCanonicalName());
    static CircleLookupTable singletonInstance = null;
    public static final short PHASE_RESOLUTION = 16384;
    public static final double PI = Math.PI;
    public static final double HALF_PI = 1.5707963267948966;
    public static final double STEPS_PER_RADIAN = 2607.5945876176133;
    public static final double RADIANS_PER_STEP = 3.834951969714103E-4;
    public static final short ZERO_INDEX = -1;
    private float[] realLUT = new float[16384];
    private float[] imagLUT = new float[16384];

    private CircleLookupTable() {
    }

    private static void initialize() {
        singletonInstance = new CircleLookupTable();
        CircleLookupTable.singletonInstance.realLUT[0] = 0.0f;
        CircleLookupTable.singletonInstance.imagLUT[0] = 0.0f;
        for (int i = 0; i < 16384; i = (int)((short)(i + 1))) {
            double theta = (double)i * 3.834951969714103E-4;
            CircleLookupTable.singletonInstance.realLUT[i] = (float)Math.cos(theta);
            CircleLookupTable.singletonInstance.imagLUT[i] = (float)Math.sin(theta);
        }
    }

    public static float getRealEntry(short i) {
        if (i == -1) {
            return 0.0f;
        }
        if (singletonInstance == null) {
            CircleLookupTable.initialize();
        }
        return CircleLookupTable.singletonInstance.realLUT[i];
    }

    public static float getImagEntry(short i) {
        if (i == -1) {
            return 0.0f;
        }
        if (singletonInstance == null) {
            CircleLookupTable.initialize();
        }
        return CircleLookupTable.singletonInstance.imagLUT[i];
    }

    public static short phaseAngleFromCartesianTrig(float real, float imag) {
        if (real == 0.0f && imag == 0.0f) {
            return -1;
        }
        double theta = 1.5707963267948966 - Math.atan2(real, imag);
        short steps = (short)(theta * 2607.5945876176133);
        if (steps < 0) {
            steps = (short)(steps + 16384);
        }
        return steps;
    }
}

