/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.vectors;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import org.apache.lucene.util.FixedBitSet;
import pitt.search.semanticvectors.utils.Bobcat;
import pitt.search.semanticvectors.vectors.BinaryVector;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorFactory;
import pitt.search.semanticvectors.vectors.VectorType;

public class BinaryVectorUtils {
    private static final Logger logger = Logger.getLogger(BinaryVectorUtils.class.getCanonicalName());

    public static boolean orthogonalizeVectors(List<Vector> list) {
        long dimension = list.get(0).getDimension();
        for (int k = 0; k < list.size(); ++k) {
            Vector kthVector = list.get(k);
            if ((long)kthVector.getDimension() != dimension) {
                System.err.println("In orthogonalizeVector: not all vectors have required dimension.");
                return false;
            }
            for (int j = 0; j < k; ++j) {
                Vector jthVector = list.get(j);
                BinaryVectorUtils.sampleSubtract(((BinaryVector)kthVector).bitSet, ((BinaryVector)jthVector).bitSet);
            }
        }
        return true;
    }

    public static double compareWithProjection(Vector testVector, ArrayList<Vector> vectors) {
        float score = 0.0f;
        for (int i = 0; i < vectors.size(); ++i) {
            score = (float)((double)score + testVector.measureOverlap(vectors.get(i)));
        }
        return score;
    }

    public static BinaryVector intersection(BinaryVector vector, BinaryVector vector2) {
        FixedBitSet intersection = vector.getCoordinates().clone();
        FixedBitSet uncommonGround = vector.getCoordinates().clone();
        Random random = new Random();
        random.setSeed(23L);
        uncommonGround.xor(vector2.getCoordinates());
        for (int x = 0; x < vector.getDimension(); ++x) {
            double change = random.nextDouble();
            if (!uncommonGround.get(x) || !(change > 0.5)) continue;
            intersection.flip(x);
        }
        BinaryVector intersectionVector = (BinaryVector)VectorFactory.createZeroVector(VectorType.BINARY, vector.getDimension());
        intersectionVector.setCoordinates(intersection);
        return intersectionVector;
    }

    public static void sampleSubtract(FixedBitSet vector, FixedBitSet subvector) {
        block7: {
            int cnt;
            FixedBitSet commonGround;
            Random random;
            long numchanges;
            block6: {
                numchanges = (long)(vector.length() / 2) - BinaryVectorUtils.xorCount(vector, subvector);
                random = new Random();
                random.setSeed(23L);
                commonGround = vector.clone();
                commonGround.xor(subvector);
                cnt = 0;
                if (numchanges <= 0L) break block6;
                int x = 0;
                while ((long)cnt < numchanges) {
                    if (x >= vector.length()) {
                        x = 0;
                    }
                    double change = random.nextDouble();
                    if (!commonGround.get(x) && change > 0.5) {
                        vector.flip(x);
                        ++cnt;
                    }
                    ++x;
                }
                break block7;
            }
            if (numchanges >= 0L) break block7;
            int x = 0;
            while ((long)cnt > numchanges) {
                if (x >= vector.length()) {
                    x = 0;
                }
                double change = random.nextDouble();
                if (commonGround.get(x) && change > 0.5) {
                    vector.flip(x);
                    --cnt;
                }
                ++x;
            }
        }
    }

    public static Vector weightedSuperposition(BinaryVector v1, double weight1, BinaryVector v2, double weight2) {
        BinaryVector conclusion = (BinaryVector)VectorFactory.createZeroVector(VectorType.BINARY, v1.getDimension());
        FixedBitSet cVote = conclusion.bitSet;
        FixedBitSet v1vote = v1.bitSet;
        FixedBitSet v2vote = v2.bitSet;
        Random random = new Random();
        random.setSeed(Bobcat.asLong(v1.writeLongToString()));
        for (int x = 0; x < v1.getDimension(); ++x) {
            double probability = 0.0;
            if (v1vote.get(x)) {
                probability += weight1 / (weight1 + weight2);
            }
            if (v2vote.get(x)) {
                probability += weight2 / (weight1 + weight2);
            }
            if (!(random.nextDouble() <= probability)) continue;
            cVote.set(x);
        }
        return conclusion;
    }

    public static long xorCount(FixedBitSet first, FixedBitSet second) {
        return FixedBitSet.andNotCount(first, second) + FixedBitSet.andNotCount(second, first);
    }
}

