/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import pitt.search.semanticvectors.CompoundVectorBuilder;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.VectorStoreRAM;
import pitt.search.semanticvectors.VectorStoreWriter;
import pitt.search.semanticvectors.utils.VerbatimLogger;
import pitt.search.semanticvectors.vectors.ComplexVector;
import pitt.search.semanticvectors.vectors.RealVector;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorType;

public class VectorStoreSubset {
    public static void main(String[] args) throws IOException {
        FlagConfig flagConfig = FlagConfig.getFlagConfig(args);
        boolean PSIquery = true;
        VectorStoreRAM queryVectors = new VectorStoreRAM(flagConfig);
        VectorStoreRAM elementalVectors = new VectorStoreRAM(flagConfig);
        VectorStoreRAM predicateVectors = new VectorStoreRAM(flagConfig);
        VectorStoreRAM semanticVectors = new VectorStoreRAM(flagConfig);
        if (flagConfig.elementalvectorfile().equals("elementalvectors") && flagConfig.semanticvectorfile().equals("semanticvectors") && flagConfig.elementalpredicatevectorfile().equals("predicatevectors")) {
            PSIquery = false;
            queryVectors.initFromFile(flagConfig.queryvectorfile());
        } else {
            elementalVectors.initFromFile(flagConfig.elementalvectorfile());
            semanticVectors.initFromFile(flagConfig.semanticvectorfile());
            predicateVectors.initFromFile(flagConfig.elementalpredicatevectorfile());
        }
        VectorStoreRAM outGoingVectors = new VectorStoreRAM(flagConfig);
        BufferedReader theReader = new BufferedReader(new FileReader(new File(flagConfig.startlistfile())));
        String inputString = theReader.readLine();
        while (inputString != null) {
            Vector vectorToAdd = null;
            vectorToAdd = !PSIquery ? CompoundVectorBuilder.getQueryVectorFromString(queryVectors, null, flagConfig, inputString) : CompoundVectorBuilder.getBoundProductQueryVectorFromString(flagConfig, elementalVectors, semanticVectors, predicateVectors, null, inputString);
            if (vectorToAdd == null || vectorToAdd.isZeroVector() || flagConfig.vectortype().equals((Object)VectorType.REAL) && Float.isNaN(((RealVector)vectorToAdd).getCoordinates()[0]) || flagConfig.vectortype().equals((Object)VectorType.COMPLEX) && Float.isNaN(((ComplexVector)vectorToAdd).getCoordinates()[0])) {
                VerbatimLogger.info("Could not represent " + inputString);
            } else {
                VerbatimLogger.info("Adding " + inputString.replaceAll(" ", "_"));
                outGoingVectors.putVector(inputString.replaceAll(" ", "_"), vectorToAdd);
            }
            inputString = theReader.readLine();
        }
        theReader.close();
        VerbatimLogger.info("\nFinished adding vectors, proceeding to write out\n");
        VectorStoreWriter.writeVectorsInLuceneFormat(flagConfig.startlistfile().replaceAll("\\..*", "_subset.bin"), flagConfig, outGoingVectors);
    }
}

