/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.utils;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;

public class MatrixUtils {
    public static void normalize(float[] input) {
        double normSq = 0.0;
        for (int i = 0; i < input.length; ++i) {
            normSq += (double)(input[i] * input[i]);
        }
        float norm = (float)Math.sqrt(normSq);
        for (int i = 0; i < input.length; ++i) {
            input[i] = input[i] / norm;
        }
    }

    public static void normalizeRows(float[][] input) {
        for (int i = 0; i < input.length; ++i) {
            MatrixUtils.normalize(input[i]);
        }
    }

    public static float[][] multiplyMatrices(float[][] left, float[][] right) {
        if (left[0].length != right.length) {
            throw new IllegalArgumentException("Columns of left matric must match rows of right matrix.");
        }
        float[][] result = new float[left.length][right[0].length];
        for (int i = 0; i < left.length; ++i) {
            for (int j = 0; j < right[0].length; ++j) {
                result[i][j] = 0.0f;
                for (int k = 0; k < right.length; ++k) {
                    float[] fArray = result[i];
                    int n = j;
                    fArray[n] = fArray[n] + left[i][k] * right[k][j];
                }
            }
        }
        return result;
    }

    public static float[][] transpose(float[][] input) {
        float[][] output = new float[input[0].length][input.length];
        for (int i = 0; i < input.length; ++i) {
            for (int j = 0; j < input[0].length; ++j) {
                output[j][i] = input[i][j];
            }
        }
        return output;
    }

    public static String sPrintMatrix(float[][] input) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < input.length; ++i) {
            for (int j = 0; j < input[0].length; ++j) {
                builder.append(input[i][j]).append(", ");
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    public static float[][] randomInit(int rows, int cols, Random random) {
        float[][] output = new float[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                output[i][j] = 2.0f * random.nextFloat() - 1.0f;
            }
        }
        return output;
    }

    public static void writeSortedFirstDim(float[][] matrix, String fn) throws IOException {
        BufferedWriter outBuf = new BufferedWriter(new FileWriter(fn));
        ArrayList<Float> firsts = new ArrayList<Float>();
        for (int row = 0; row < matrix.length; ++row) {
            firsts.add(Float.valueOf(matrix[row][0]));
        }
        Collections.sort(firsts);
        for (Float num : firsts) {
            outBuf.write(String.format("%f\n", num));
        }
        outBuf.close();
    }

    public static void main(String[] args) throws IOException {
        int terms = 500;
        int docs = 1000;
        int dimension = 1200;
        int iterations = 100;
        Random random = new Random();
        float[][] cooccurences = MatrixUtils.randomInit(terms, docs, random);
        float[][] coocTrans = MatrixUtils.transpose(cooccurences);
        float[][] docVecs = MatrixUtils.randomInit(docs, dimension, random);
        MatrixUtils.normalizeRows(docVecs);
        for (int i = 0; i < iterations; ++i) {
            float[][] termVecs = MatrixUtils.multiplyMatrices(cooccurences, docVecs);
            MatrixUtils.writeSortedFirstDim(termVecs, String.format("./dim_%d.txt", i));
            MatrixUtils.normalizeRows(termVecs);
            docVecs = MatrixUtils.multiplyMatrices(coocTrans, termVecs);
            MatrixUtils.normalizeRows(docVecs);
        }
    }
}

