/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.utils;

import java.util.Arrays;

public class Distribution {
    private float[] orderedValues;

    public Distribution(float[] values) {
        assert (values != null && values.length > 1);
        Arrays.sort(values);
        this.orderedValues = (float[])values.clone();
    }

    public float getCumulativePosition(float value) {
        if (value < this.orderedValues[0]) {
            return 0.0f;
        }
        if (value > this.orderedValues[this.orderedValues.length - 1]) {
            return 1.0f;
        }
        int positionBelow = Distribution.getPosition(this.orderedValues, value);
        float basePosition = positionBelow;
        float interpolatedExtra = this.orderedValues[positionBelow + 1] == this.orderedValues[positionBelow] ? 0.0f : (value - this.orderedValues[positionBelow]) / (this.orderedValues[positionBelow + 1] - this.orderedValues[positionBelow]);
        return (basePosition + interpolatedExtra) / (float)(this.orderedValues.length - 1);
    }

    private static int getPosition(float[] knownValues, float incoming) {
        int positionBelow = 0;
        int positionAbove = knownValues.length - 1;
        while (positionBelow < positionAbove - 1) {
            int positionBetween = (positionBelow + positionAbove) / 2;
            if (knownValues[positionBetween] == incoming) {
                return positionBetween;
            }
            if (knownValues[positionBetween] > incoming) {
                positionAbove = positionBetween;
                continue;
            }
            positionBelow = positionBetween;
        }
        return positionBelow;
    }
}

