/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.orthography;

import java.util.Random;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.utils.VerbatimLogger;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorFactory;
import pitt.search.semanticvectors.vectors.VectorUtils;

public class ProportionVectors {
    private static final long randomSeed = 0L;
    private Vector vectorStart;
    private Vector vectorEnd;

    public ProportionVectors(FlagConfig flagConfig) {
        Random random = new Random(0L);
        while (true) {
            this.vectorStart = VectorFactory.generateRandomVector(flagConfig.vectortype(), flagConfig.dimension(), flagConfig.seedlength(), random);
            this.vectorEnd = VectorFactory.generateRandomVector(flagConfig.vectortype(), flagConfig.dimension(), flagConfig.seedlength(), random);
            if (this.vectorStart.measureOverlap(this.vectorEnd) < 0.1) break;
            VerbatimLogger.info("Bookend vectors too similar to each other ... repeating generation.\n");
        }
    }

    public Vector getProportionVector(double proportion) {
        if (proportion < 0.0 || proportion > 1.0) {
            throw new IllegalArgumentException("Proportion must be a number in the range [0, 1]. Not: " + proportion);
        }
        Vector proportionVector = VectorUtils.weightedSuperposition(this.vectorStart, proportion, this.vectorEnd, 1.0 - proportion);
        return proportionVector;
    }
}

