/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.lsh;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.ObjectVector;
import pitt.search.semanticvectors.VectorStoreReaderLucene;
import pitt.search.semanticvectors.lsh.InMemoryLSHStore;
import pitt.search.semanticvectors.lsh.LSHStore;
import pitt.search.semanticvectors.lsh.LocalitySensitiveHash;
import pitt.search.semanticvectors.lsh.LongIterator;
import pitt.search.semanticvectors.lsh.PersistedHashMap;
import pitt.search.semanticvectors.vectors.Vector;

public class PersistedLSHStore
extends LSHStore {
    public static final String STORE_SUFFIX = ".lshstore";
    public static final String LSH_SUFFIX = ".lsh";
    protected File homeDir;
    LocalitySensitiveHash lsh;
    File vecStoreFile;
    FlagConfig flagConfig;
    File cacheFile;
    PersistedHashMap phm;

    public PersistedLSHStore(File vecStoreFile, FlagConfig flagConfig) {
        this.vecStoreFile = vecStoreFile;
        this.flagConfig = flagConfig;
    }

    @Override
    public void initCache() throws IOException {
        this.homeDir = new File(this.vecStoreFile.getParentFile(), "lsh");
        if (!this.homeDir.exists()) {
            Files.createDirectories(this.homeDir.toPath(), new FileAttribute[0]);
        }
        this.cacheFile = new File(this.homeDir, this.vecStoreFile.getName() + STORE_SUFFIX + this.flagConfig.lsh_hashes_num() + this.flagConfig.lsh_max_bits_diff());
        File lshFile = new File(this.homeDir, this.vecStoreFile.getName() + LSH_SUFFIX + this.flagConfig.lsh_hashes_num() + this.flagConfig.lsh_max_bits_diff());
        this.phm = new PersistedHashMap(this.cacheFile);
        if (this.cacheFile.exists()) {
            this.phm.init();
            this.lsh = LocalitySensitiveHash.initFromFile(lshFile);
        } else {
            InMemoryLSHStore inMemoryStore = new InMemoryLSHStore(this.vecStoreFile, this.flagConfig);
            inMemoryStore.initCache();
            this.lsh = inMemoryStore.lsh;
            this.lsh.writeToFile(lshFile);
            this.phm.persist(inMemoryStore.storeHash);
        }
    }

    @Override
    public Enumeration<ObjectVector> getSimilar(Vector vector) throws IOException {
        short[] similarHashes = this.lsh.getSimilarHashes(vector);
        Arrays.sort(similarHashes);
        List<Short> keys = this.phm.keys();
        List toCheck = keys.stream().filter(aShort -> Arrays.binarySearch(similarHashes, aShort) >= 0).collect(Collectors.toList());
        final Iterator buckets = toCheck.iterator();
        Iterator<Long> iter = new Iterator<Long>(){
            LongIterator bucketIter;

            @Override
            public boolean hasNext() {
                if (this.bucketIter == null && buckets.hasNext()) {
                    this.bucketIter = PersistedLSHStore.this.phm.get((Short)buckets.next());
                }
                if (!this.bucketIter.hasNext()) {
                    if (buckets.hasNext()) {
                        this.bucketIter = PersistedLSHStore.this.phm.get((Short)buckets.next());
                    } else {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Long next() {
                if (!this.hasNext()) {
                    return null;
                }
                return this.bucketIter.next();
            }
        };
        return this.getObjectVectorEnum(iter, new VectorStoreReaderLucene(this.vecStoreFile.getAbsolutePath(), this.flagConfig), this.flagConfig);
    }

    @Override
    public void close() {
        this.phm.close();
    }
}

