/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.lsh;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.lsh.LSHStore;
import pitt.search.semanticvectors.lsh.PersistedLSHStore;

public enum LSHStoreFactory {
    INSTANCE;

    private static Map<LSHConfig, LSHStore> hashStores;

    public LSHStore getStore(File vecStoreFile, FlagConfig flagConfig) {
        return hashStores.computeIfAbsent(new LSHConfig(vecStoreFile.getAbsolutePath(), flagConfig.lsh_hashes_num(), flagConfig.lsh_max_bits_diff()), config -> {
            try {
                PersistedLSHStore store = new PersistedLSHStore(vecStoreFile, flagConfig);
                ((LSHStore)store).initCache();
                return store;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not init vector store cache", e);
            }
        });
    }

    public void clearStoresForIndex(File indexHome) {
        LinkedList<LSHConfig> toDelete = new LinkedList<LSHConfig>();
        for (LSHConfig lshConfig : hashStores.keySet()) {
            if (!lshConfig.fileName.startsWith(indexHome.getAbsolutePath())) continue;
            toDelete.add(lshConfig);
        }
        for (LSHConfig lshConfig : toDelete) {
            hashStores.remove(lshConfig).close();
        }
    }

    static {
        hashStores = new HashMap<LSHConfig, LSHStore>();
    }

    private static class LSHConfig {
        String fileName;
        int numOfHashes;
        int maxBitsDiff;

        public LSHConfig(String fileName, int numOfHashes, int maxBitsDiff) {
            this.fileName = fileName;
            this.numOfHashes = numOfHashes;
            this.maxBitsDiff = maxBitsDiff;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LSHConfig lshConfig = (LSHConfig)o;
            return this.numOfHashes == lshConfig.numOfHashes && this.maxBitsDiff == lshConfig.maxBitsDiff && Objects.equals(this.fileName, lshConfig.fileName);
        }

        public int hashCode() {
            return Objects.hash(this.fileName, this.numOfHashes, this.maxBitsDiff);
        }
    }
}

