/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.lsh;

import java.io.File;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.ObjectVector;
import pitt.search.semanticvectors.VectorStoreReaderLucene;
import pitt.search.semanticvectors.VectorStoreUtils;
import pitt.search.semanticvectors.lsh.DirectByteBufferCleaner;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorFactory;

public abstract class LSHStore {
    public abstract void initCache() throws IOException;

    public abstract Enumeration<ObjectVector> getSimilar(Vector var1) throws IOException;

    public void close() {
    }

    protected Enumeration<ObjectVector> getObjectVectorEnum(final Iterator<Long> iter, final VectorStoreReaderLucene vecStore, final FlagConfig flagConfig) throws IOException {
        Enumeration<ObjectVector> vecs;
        File storeFile = vecStore.getVectorFile();
        if (storeFile.length() < Integer.MAX_VALUE) {
            final MappedByteBuffer byteBuffer = FileChannel.open(storeFile.toPath(), new OpenOption[0]).map(FileChannel.MapMode.READ_ONLY, 0L, storeFile.length());
            final DataInput di = new DataInput(){

                @Override
                public byte readByte() throws IOException {
                    return byteBuffer.get();
                }

                @Override
                public void readBytes(byte[] b, int offset, int len) throws IOException {
                    byteBuffer.get(b, offset, len);
                }
            };
            vecs = new Enumeration<ObjectVector>(){

                @Override
                public boolean hasMoreElements() {
                    if (iter.hasNext()) {
                        return true;
                    }
                    DirectByteBufferCleaner.closeDirectByteBuffer(byteBuffer);
                    VectorStoreUtils.closeVectorStores(vecStore);
                    return false;
                }

                @Override
                public ObjectVector nextElement() {
                    String object;
                    if (!this.hasMoreElements()) {
                        return null;
                    }
                    Vector vector = VectorFactory.createZeroVector(flagConfig.vectortype(), flagConfig.dimension());
                    try {
                        long position = (Long)iter.next();
                        byteBuffer.position((int)position);
                        object = di.readString();
                        vector.readFromByteBuffer(byteBuffer);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Could not read vector", e);
                    }
                    return new ObjectVector(object, vector);
                }
            };
        } else {
            final IndexInput indexInput = vecStore.getIndexInput();
            vecs = new Enumeration<ObjectVector>(){

                @Override
                public boolean hasMoreElements() {
                    if (iter.hasNext()) {
                        return true;
                    }
                    VectorStoreUtils.closeVectorStores(vecStore);
                    return false;
                }

                @Override
                public ObjectVector nextElement() {
                    String object;
                    if (!this.hasMoreElements()) {
                        return null;
                    }
                    Vector vector = VectorFactory.createZeroVector(flagConfig.vectortype(), flagConfig.dimension());
                    try {
                        long position = (Long)iter.next();
                        indexInput.seek(position);
                        object = indexInput.readString();
                        vector.readFromLuceneStream(indexInput);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Could not read vector", e);
                    }
                    return new ObjectVector(object, vector);
                }
            };
        }
        return vecs;
    }
}

