/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.lsh;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import org.apache.lucene.store.IndexInput;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.ObjectVector;
import pitt.search.semanticvectors.VectorStoreReaderLucene;
import pitt.search.semanticvectors.VectorStoreUtils;
import pitt.search.semanticvectors.lsh.LSHStore;
import pitt.search.semanticvectors.lsh.LocalitySensitiveHash;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorFactory;

public class InMemoryLSHStore
extends LSHStore {
    LocalitySensitiveHash lsh;
    FlagConfig flagConfig;
    TreeMap<Short, Collection<Long>> storeHash;
    File vecStoreFile;

    InMemoryLSHStore(File vecStoreFile, FlagConfig flagConfig) {
        this.vecStoreFile = vecStoreFile;
        this.flagConfig = flagConfig;
        this.lsh = new LocalitySensitiveHash(flagConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initCache() throws IOException {
        this.storeHash = new TreeMap();
        VectorStoreReaderLucene vecStore = null;
        try {
            long currentPosition;
            vecStore = new VectorStoreReaderLucene(this.vecStoreFile.getAbsolutePath(), this.flagConfig);
            IndexInput indexInput = vecStore.getIndexInput();
            indexInput.seek(0L);
            indexInput.readString();
            while ((currentPosition = indexInput.getFilePointer()) < indexInput.length()) {
                indexInput.readString();
                Vector vector = VectorFactory.createZeroVector(this.flagConfig.vectortype(), this.flagConfig.dimension());
                vector.readFromLuceneStream(indexInput);
                short hash = this.lsh.getHash(vector);
                this.storeHash.computeIfAbsent(hash, h -> new LinkedList()).add(currentPosition);
            }
        }
        catch (Throwable throwable) {
            VectorStoreUtils.closeVectorStores(vecStore);
            throw throwable;
        }
        VectorStoreUtils.closeVectorStores(vecStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<ObjectVector> getSimilar(Vector vector) throws IOException {
        Enumeration<ObjectVector> enumeration;
        if (this.storeHash == null) {
            throw new RuntimeException("There is no cached data");
        }
        VectorStoreReaderLucene vecStore = new VectorStoreReaderLucene(this.vecStoreFile.getAbsolutePath(), this.flagConfig);
        try {
            short[] potentialHashes = this.lsh.getSimilarHashes(vector);
            HashSet<Long> allVecPositions = new HashSet<Long>();
            for (short potentialHash : potentialHashes) {
                if (!this.storeHash.containsKey(potentialHash)) continue;
                allVecPositions.addAll(this.storeHash.get(potentialHash));
            }
            Iterator<Long> iter = allVecPositions.iterator();
            enumeration = this.getObjectVectorEnum(iter, vecStore, this.flagConfig);
        }
        catch (Throwable throwable) {
            VectorStoreUtils.closeVectorStores(vecStore);
            throw throwable;
        }
        VectorStoreUtils.closeVectorStores(vecStore);
        return enumeration;
    }
}

