/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.collections;

import com.ontotext.graphdb.Config;
import com.ontotext.trree.sdk.PluginException;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Random;
import pitt.search.semanticvectors.CloseableVectorStore;
import pitt.search.semanticvectors.ElementalVectorStore;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.ObjectVector;
import pitt.search.semanticvectors.VectorStoreRAM;
import pitt.search.semanticvectors.collections.FileVectorStore;
import pitt.search.semanticvectors.collections.ModifiableVectorStore;
import pitt.search.semanticvectors.collections.RealVectorBufferConverter;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorFactory;
import pitt.search.semanticvectors.vectors.VectorType;

public class VectorStoreFactory {
    public static ModifiableVectorStore getVectorStore(FlagConfig config) {
        RealVectorBufferConverter converter = null;
        if (config.vectortype() == VectorType.REAL) {
            converter = new RealVectorBufferConverter(config.dimension());
        }
        if (converter != null) {
            try {
                File tempFile = Config.createTempFile((String)"vecReader", (String)".tmp");
                return new FileVectorStore(tempFile, converter);
            }
            catch (IOException e) {
                throw new PluginException("Could not create file for vector store", (Throwable)e);
            }
        }
        return new VectorStoreRAMWrapper(new VectorStoreRAM(config));
    }

    public static CloseableVectorStore getElementalVectorStore(FlagConfig config) {
        if (config.elementalmethod() == ElementalVectorStore.ElementalGenerationMethod.RANDOM && config.vectortype() == VectorType.BINARY) {
            return new RandomBinaryElementalVectorStore(config);
        }
        return new ElementalVectorStoreWrapper(new ElementalVectorStore(config));
    }

    private static class RandomBinaryElementalVectorStore
    implements CloseableVectorStore {
        private Random random;
        private FlagConfig flagConfig;
        private ModifiableVectorStore backingStore;

        public RandomBinaryElementalVectorStore(FlagConfig flagConfig) {
            this.flagConfig = flagConfig;
            this.backingStore = VectorStoreFactory.getVectorStore(flagConfig);
            this.random = new Random();
        }

        @Override
        public Vector getVector(Object term) {
            Vector vector = this.backingStore.getVector(term);
            if (vector == null) {
                vector = VectorFactory.generateRandomVector(this.flagConfig.vectortype(), this.flagConfig.dimension(), this.flagConfig.seedlength(), this.random);
                this.backingStore.putVector(term, vector);
            }
            return vector;
        }

        @Override
        public Enumeration<ObjectVector> getAllVectors() {
            return this.backingStore.getAllVectors();
        }

        @Override
        public int getNumVectors() {
            return this.backingStore.getNumVectors();
        }

        @Override
        public boolean containsVector(Object object) {
            return this.backingStore.containsVector(object);
        }

        @Override
        public void close() {
            this.backingStore.close();
        }
    }

    private static class ElementalVectorStoreWrapper
    implements CloseableVectorStore {
        private ElementalVectorStore wrapped;

        public ElementalVectorStoreWrapper(ElementalVectorStore wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public Vector getVector(Object term) {
            return this.wrapped.getVector(term);
        }

        @Override
        public Enumeration<ObjectVector> getAllVectors() {
            return this.wrapped.getAllVectors();
        }

        @Override
        public int getNumVectors() {
            return this.wrapped.getNumVectors();
        }

        @Override
        public boolean containsVector(Object object) {
            return this.wrapped.containsVector(object);
        }

        @Override
        public void close() {
        }
    }

    private static class VectorStoreRAMWrapper
    implements ModifiableVectorStore {
        private VectorStoreRAM wrapped;

        public VectorStoreRAMWrapper(VectorStoreRAM wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public void putVector(Object key, Vector vector) {
            this.wrapped.putVector(key, vector);
        }

        @Override
        public Enumeration<ObjectVector> getAllVectors() {
            return this.wrapped.getAllVectors();
        }

        @Override
        public int getNumVectors() {
            return this.wrapped.getNumVectors();
        }

        @Override
        public Vector getVector(Object desiredObject) {
            return this.wrapped.getVector(desiredObject);
        }

        @Override
        public boolean containsVector(Object object) {
            return this.wrapped.containsVector(object);
        }

        @Override
        public void updateVector(Object key, Vector vector) {
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }
}

