/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.collections;

import java.nio.ByteBuffer;
import pitt.search.semanticvectors.collections.VectorBufferConverter;
import pitt.search.semanticvectors.vectors.RealVector;
import pitt.search.semanticvectors.vectors.Vector;

public class RealVectorBufferConverter
implements VectorBufferConverter {
    private static final int BITS_IN_BYTE = 8;
    int dimension;
    int bufferSizeInBytes;

    public RealVectorBufferConverter(int dimension) {
        this.dimension = dimension;
        this.bufferSizeInBytes = dimension * 32 / 8;
    }

    @Override
    public Vector readFromBuffer(ByteBuffer byteBuffer) {
        float[] coords = new float[this.dimension];
        byteBuffer.asFloatBuffer().get(coords);
        return new RealVector(coords);
    }

    @Override
    public ByteBuffer writeToBuffer(Vector vector) {
        float[] coords = ((RealVector)vector).getCoordinates();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.bufferSizeInBytes);
        byteBuffer.asFloatBuffer().put(coords);
        return byteBuffer;
    }

    @Override
    public int getBufferSizeInBytes() {
        return this.bufferSizeInBytes;
    }
}

