/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors;

import java.util.Enumeration;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import pitt.search.semanticvectors.CloseableVectorStore;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.ObjectVector;
import pitt.search.semanticvectors.VectorStore;
import pitt.search.semanticvectors.utils.Bobcat;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorFactory;
import pitt.search.semanticvectors.vectors.VectorType;

public class VectorStoreDeterministic
implements VectorStore,
CloseableVectorStore {
    private FlagConfig flagConfig;
    private ConcurrentHashMap<Object, ObjectVector> objectVectors;
    private Random random = new Random();
    private VectorType vectorType;
    private int dimension;
    private boolean cacheVectors = true;

    public VectorStoreDeterministic(FlagConfig flagConfig) {
        this.flagConfig = flagConfig;
        this.objectVectors = new ConcurrentHashMap();
        this.vectorType = flagConfig.vectortype();
        this.dimension = flagConfig.dimension();
    }

    @Override
    public Enumeration<ObjectVector> getAllVectors() {
        return this.objectVectors.elements();
    }

    @Override
    public int getNumVectors() {
        return this.objectVectors.size();
    }

    public void clear() {
        this.objectVectors.clear();
    }

    public void enableVectorCache(boolean cacheVectors) {
        this.cacheVectors = cacheVectors;
    }

    @Override
    public Vector getVector(Object desiredObject) throws NullPointerException {
        ObjectVector objectVector = this.objectVectors.get(desiredObject);
        if (objectVector != null) {
            return objectVector.getVector();
        }
        this.random.setSeed(Bobcat.asLong(desiredObject.toString()));
        Vector v = VectorFactory.generateRandomVector(this.vectorType, this.dimension, this.flagConfig.seedlength(), this.random);
        if (this.cacheVectors) {
            this.objectVectors.put(desiredObject, new ObjectVector(desiredObject, v));
        }
        return v;
    }

    @Override
    public boolean containsVector(Object object) {
        return this.objectVectors.containsKey(object);
    }

    @Override
    public void close() {
    }
}

