/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.FSDirectory;
import pitt.search.semanticvectors.CompoundVectorBuilder;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.LuceneUtils;
import pitt.search.semanticvectors.ObjectVector;
import pitt.search.semanticvectors.SearchResult;
import pitt.search.semanticvectors.VectorStore;
import pitt.search.semanticvectors.VectorStoreRAM;
import pitt.search.semanticvectors.VectorStoreReaderLucene;
import pitt.search.semanticvectors.lsh.LSHStoreFactory;
import pitt.search.semanticvectors.vectors.BinaryVectorUtils;
import pitt.search.semanticvectors.vectors.IncompatibleVectorsException;
import pitt.search.semanticvectors.vectors.PermutationVector;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorFactory;
import pitt.search.semanticvectors.vectors.VectorType;
import pitt.search.semanticvectors.vectors.VectorUtils;
import pitt.search.semanticvectors.vectors.ZeroVectorException;

public abstract class VectorSearcher {
    private static final Logger logger = Logger.getLogger(VectorSearcher.class.getCanonicalName());
    protected FlagConfig flagConfig;
    protected VectorStore searchVecStore;
    protected LuceneUtils luceneUtils;

    public static VectorStore expandSearchSpace(VectorStore searchVecStore, FlagConfig flagConfig) {
        VectorStoreRAM nusearchspace = new VectorStoreRAM(flagConfig);
        Enumeration<ObjectVector> allVectors = searchVecStore.getAllVectors();
        ArrayList<ObjectVector> storeVectors = new ArrayList<ObjectVector>();
        while (allVectors.hasMoreElements()) {
            ObjectVector nextObjectVector = allVectors.nextElement();
            nusearchspace.putVector(nextObjectVector.getObject(), nextObjectVector.getVector());
            storeVectors.add(nextObjectVector);
        }
        for (int x = 0; x < storeVectors.size() - 2; ++x) {
            for (int y = x; y < storeVectors.size() - 1; ++y) {
                String obj2;
                Vector vec1 = ((ObjectVector)storeVectors.get(x)).getVector().copy();
                Vector vec2 = ((ObjectVector)storeVectors.get(y)).getVector().copy();
                String obj1 = ((ObjectVector)storeVectors.get(x)).getObject().toString();
                if (obj1.equals(obj2 = ((ObjectVector)storeVectors.get(y)).getObject().toString())) continue;
                vec1.release(vec2);
                nusearchspace.putVector(obj2 + ":" + obj1, vec1.copy());
                if (!flagConfig.vectortype().equals((Object)VectorType.COMPLEX)) continue;
                vec2.release(((ObjectVector)storeVectors.get(x)).getVector().copy());
                nusearchspace.putVector(obj1 + ":" + obj2, vec2);
            }
        }
        return nusearchspace;
    }

    public static VectorStore expandSearchSpace3(VectorStore searchVecStore, FlagConfig flagConfig) {
        VectorStoreRAM nusearchspace = new VectorStoreRAM(flagConfig);
        Enumeration<ObjectVector> allVectors = searchVecStore.getAllVectors();
        ArrayList<ObjectVector> storeVectors = new ArrayList<ObjectVector>();
        while (allVectors.hasMoreElements()) {
            ObjectVector nextObjectVector = allVectors.nextElement();
            nusearchspace.putVector(nextObjectVector.getObject(), nextObjectVector.getVector());
            storeVectors.add(nextObjectVector);
        }
        for (int x = 0; x < storeVectors.size() - 2; ++x) {
            for (int y = x; y < storeVectors.size() - 1; ++y) {
                for (int z = y; z < storeVectors.size(); ++z) {
                    Vector vec1 = ((ObjectVector)storeVectors.get(x)).getVector().copy();
                    Vector vec2 = ((ObjectVector)storeVectors.get(y)).getVector().copy();
                    Vector vec3 = ((ObjectVector)storeVectors.get(z)).getVector().copy();
                    String obj1 = ((ObjectVector)storeVectors.get(x)).getObject().toString();
                    String obj2 = ((ObjectVector)storeVectors.get(y)).getObject().toString();
                    String obj3 = ((ObjectVector)storeVectors.get(z)).getObject().toString();
                    if (obj1.equals(obj2)) continue;
                    vec1.release(vec2);
                    nusearchspace.putVector(obj2 + ":" + obj1, vec1.copy());
                    if (flagConfig.vectortype().equals((Object)VectorType.COMPLEX)) {
                        vec2.release(((ObjectVector)storeVectors.get(x)).getVector().copy());
                        nusearchspace.putVector(obj1 + ":" + obj2, vec2);
                    }
                    if (obj3.equals(obj2) || obj3.equals(obj1)) continue;
                    vec1.release(vec3);
                    nusearchspace.putVector(obj1 + ":" + obj2 + ":" + obj3, vec1);
                    if (!flagConfig.vectortype().equals((Object)VectorType.COMPLEX)) continue;
                    vec3.release(vec2);
                    nusearchspace.putVector(obj3 + ":" + obj2 + ":" + obj1, vec2);
                }
            }
        }
        System.err.println("Expanding search space from " + storeVectors.size() + " to " + nusearchspace.getNumVectors());
        return nusearchspace;
    }

    public abstract double getScore(Vector var1);

    public VectorSearcher(VectorStore queryVecStore, VectorStore searchVecStore, LuceneUtils luceneUtils, FlagConfig flagConfig) {
        this.flagConfig = flagConfig;
        this.searchVecStore = searchVecStore;
        this.luceneUtils = luceneUtils;
        if (flagConfig.expandsearchspace()) {
            this.searchVecStore = VectorSearcher.expandSearchSpace(searchVecStore, flagConfig);
        } else if (flagConfig.expandsearchspace3()) {
            this.searchVecStore = VectorSearcher.expandSearchSpace3(searchVecStore, flagConfig);
        }
    }

    public LinkedList<SearchResult> getNearestNeighbors(int numResults) {
        Enumeration<ObjectVector> vecEnum = this.searchVecStore.getAllVectors();
        return this.getNearest(numResults, vecEnum);
    }

    protected LinkedList<SearchResult> getNearest(int numResults, Enumeration<ObjectVector> vecEnum) {
        SearchResult result;
        double unsetScore = -Math.PI;
        LinkedList<SearchResult> results = new LinkedList<SearchResult>();
        double score = -1.0;
        double threshold = this.flagConfig.searchresultsminscore();
        if (this.flagConfig.stdev()) {
            threshold = 0.0;
        }
        double sum = 0.0;
        double sumsquared = 0.0;
        int count = 0;
        TreeSet<SearchResult> tmpResults = new TreeSet<SearchResult>();
        for (int i = 0; i < numResults; ++i) {
            tmpResults.add(new SearchResult(-Math.PI, null));
        }
        while (vecEnum.hasMoreElements()) {
            double susq;
            ObjectVector testElement = vecEnum.nextElement();
            score = this.getScore(testElement.getVector());
            if (this.luceneUtils != null && this.flagConfig.usetermweightsintermsearch()) {
                score *= (double)this.luceneUtils.getGlobalTermWeightFromString((String)testElement.getObject());
            }
            if (this.flagConfig.stdev() && !Double.isNaN(susq = Math.pow(score, 2.0))) {
                ++count;
                sum += score;
                sumsquared += Math.pow(score, 2.0);
            }
            if (!(score > threshold) || !(score > ((SearchResult)tmpResults.last()).getScore())) continue;
            tmpResults.pollLast();
            tmpResults.add(new SearchResult(score, testElement));
            threshold = ((SearchResult)tmpResults.last()).getScore();
        }
        Iterator searchResultIterator = tmpResults.iterator();
        while (searchResultIterator.hasNext() && (result = (SearchResult)searchResultIterator.next()).getScore() != -Math.PI && !(result.getScore() < this.flagConfig.searchresultsminscore())) {
            results.add(result);
            if (results.size() != numResults) continue;
            break;
        }
        if (this.flagConfig.stdev()) {
            results = this.transformToStats(results, count, sum, sumsquared);
        }
        return results;
    }

    public LinkedList<SearchResult> getAllAboveThreshold(float threshold) {
        LinkedList<SearchResult> results = new LinkedList<SearchResult>();
        Enumeration<ObjectVector> vecEnum = null;
        vecEnum = this.searchVecStore.getAllVectors();
        while (vecEnum.hasMoreElements()) {
            double score;
            ObjectVector testElement = vecEnum.nextElement();
            if (testElement == null) {
                score = 1.4E-45f;
            } else {
                Vector testVector = testElement.getVector();
                score = this.getScore(testVector);
            }
            if (!(score > (double)threshold) && threshold != Float.MIN_VALUE) continue;
            results.add(new SearchResult(score, testElement));
        }
        Collections.sort(results);
        return results;
    }

    public LinkedList<SearchResult> transformToStats(LinkedList<SearchResult> rawResults, int count, double sum, double sumsq) {
        LinkedList<SearchResult> transformedResults = new LinkedList<SearchResult>();
        double variancesquared = sumsq - Math.pow(sum, 2.0) / (double)count;
        double stdev = Math.sqrt(variancesquared / (double)count);
        double mean = sum / (double)count;
        for (SearchResult temp : rawResults) {
            double score = temp.getScore();
            if (!((score = (double)new Double((score - mean) / stdev).floatValue()) > this.flagConfig.searchresultsminscore())) continue;
            transformedResults.add(new SearchResult(score, temp.getObjectVector()));
        }
        return transformedResults;
    }

    public static class VectorSearcherProximity
    extends VectorSearcher {
        ArrayList<Vector> comparisonVectors = new ArrayList();
        VectorStore numberVectorStore;
        Vector numberVector1;
        Vector numberVector2;

        public VectorSearcherProximity(VectorStore queryVecStore, VectorStore searchVecStore, VectorStore numberVectorStore, LuceneUtils luceneUtils, FlagConfig flagConfig, String[] queryTerms) {
            super(queryVecStore, searchVecStore, null, flagConfig);
            this.numberVectorStore = numberVectorStore;
            this.numberVector1 = numberVectorStore.getVector("100:alpha");
            this.numberVector2 = numberVectorStore.getVector("100:omega");
            for (int q = 0; q < queryTerms.length; ++q) {
                if (!queryVecStore.containsVector(queryTerms[q])) continue;
                this.comparisonVectors.add(queryVecStore.getVector(queryTerms[q]));
            }
        }

        public VectorSearcherProximity(Vector elementalOne, Vector elementalTwo, Vector demarcatorAlpha, Vector demarcatorOmega, VectorStore rowVectorStore, FlagConfig flagConfig) {
            super(rowVectorStore, rowVectorStore, null, flagConfig);
            this.numberVector1 = demarcatorAlpha.copy();
            this.numberVector2 = demarcatorOmega.copy();
            this.comparisonVectors.add(elementalOne);
            this.comparisonVectors.add(elementalTwo);
        }

        @Override
        public double getScore(Vector testVector) {
            double proximityScore = 0.0;
            int numTests = this.comparisonVectors.size();
            for (int q = 0; q < numTests - 1; ++q) {
                Vector testCopy1 = testVector.copy();
                Vector testCopy2 = testVector.copy();
                testCopy1.release(this.comparisonVectors.get(q));
                testCopy2.release(this.comparisonVectors.get(q + 1));
                double a1 = testCopy1.measureOverlap(this.numberVector1);
                double a2 = testCopy1.measureOverlap(this.numberVector2);
                double o1 = testCopy2.measureOverlap(this.numberVector1);
                double o2 = testCopy2.measureOverlap(this.numberVector2);
                proximityScore += Math.sqrt(Math.pow(a1 - o1, 2.0) + Math.pow(a2 - o2, 2.0));
            }
            return proximityScore;
        }
    }

    public static class VectorSearcherLucene
    extends VectorSearcher {
        LuceneUtils specialLuceneUtils;
        FlagConfig specialFlagConfig;
        String[] queryTerms;
        IndexSearcher iSearcher;
        VectorStoreRAM acceptableTerms;

        public VectorSearcherLucene(LuceneUtils luceneUtils, FlagConfig flagConfig, String[] queryTerms) throws IllegalArgumentException, ZeroVectorException {
            super(null, null, luceneUtils, flagConfig);
            this.specialLuceneUtils = luceneUtils;
            this.specialFlagConfig = flagConfig;
            try {
                FSDirectory dir = FSDirectory.open(FileSystems.getDefault().getPath(flagConfig.luceneindexpath(), new String[0]));
                this.iSearcher = new IndexSearcher(DirectoryReader.open(dir));
                if (!flagConfig.elementalvectorfile().equals("elementalvectors")) {
                    this.acceptableTerms = new VectorStoreRAM(flagConfig);
                    this.acceptableTerms.initFromFile(flagConfig.elementalvectorfile());
                }
            }
            catch (IOException e) {
                logger.info("Lucene index initialization failed: " + e.getMessage());
            }
            this.queryTerms = queryTerms;
        }

        @Override
        public LinkedList<SearchResult> getNearestNeighbors(int numResults) {
            LinkedList<SearchResult> results = new LinkedList<SearchResult>();
            BooleanQuery.Builder mtq = new BooleanQuery.Builder();
            for (int q = 0; q < this.queryTerms.length; ++q) {
                String term = this.queryTerms[q];
                if (this.acceptableTerms != null && !this.acceptableTerms.containsVector(term)) continue;
                for (String field : this.specialFlagConfig.contentsfields()) {
                    mtq.add(new TermQuery(new Term(field, term)), BooleanClause.Occur.SHOULD);
                }
            }
            try {
                TopDocs docs = this.iSearcher.search((Query)mtq.build(), this.specialFlagConfig.numsearchresults());
                ScoreDoc[] hits2 = docs.scoreDocs;
                for (int i = 0; i < hits2.length; ++i) {
                    int docId = hits2[i].doc;
                    if (this.specialFlagConfig.hybridvectors() && i < this.specialFlagConfig.numsearchresults()) {
                        Explanation explain = this.iSearcher.explain(mtq.build(), docId);
                        System.out.println(explain);
                    }
                    Document d = this.iSearcher.doc(docId);
                    float dscore = hits2[i].score;
                    results.add(new SearchResult(dscore, new ObjectVector(d.get(this.specialFlagConfig.docidfield()), null)));
                }
            }
            catch (IOException e) {
                logger.info("Lucene search failed: " + e.getMessage());
            }
            return results;
        }

        @Override
        public double getScore(Vector testVector) {
            return 0.0;
        }
    }

    public static class BalancedVectorSearcherPerm
    extends VectorSearcher {
        Vector oneDirection;
        Vector otherDirection;
        VectorStore searchVecStore;
        VectorStore queryVecStore;
        LuceneUtils specialLuceneUtils;
        FlagConfig specialFlagConfig;
        String[] queryTerms;

        public BalancedVectorSearcherPerm(VectorStore queryVecStore, VectorStore searchVecStore, LuceneUtils luceneUtils, FlagConfig flagConfig, String[] queryTerms) throws IllegalArgumentException, ZeroVectorException {
            super(queryVecStore, searchVecStore, luceneUtils, flagConfig);
            this.specialFlagConfig = flagConfig;
            this.specialLuceneUtils = luceneUtils;
            try {
                this.oneDirection = CompoundVectorBuilder.getPermutedQueryVector(queryVecStore, luceneUtils, flagConfig, queryTerms);
                this.otherDirection = CompoundVectorBuilder.getPermutedQueryVector(searchVecStore, luceneUtils, flagConfig, queryTerms);
            }
            catch (IllegalArgumentException e) {
                logger.info("Couldn't create balanced permutation VectorSearcher ...");
                throw e;
            }
            if (this.oneDirection.isZeroVector()) {
                throw new ZeroVectorException("Permutation query vector is zero ... no results.");
            }
        }

        @Override
        public LinkedList<SearchResult> getNearestNeighbors(int numResults) {
            LinkedList<SearchResult> results = new LinkedList<SearchResult>();
            double score2 = -1.0;
            double threshold = this.specialFlagConfig.searchresultsminscore();
            if (this.specialFlagConfig.stdev()) {
                threshold = 0.0;
            }
            double sum = 0.0;
            double sumsquared = 0.0;
            int count = 0;
            Enumeration<ObjectVector> vecEnum = this.searchVecStore.getAllVectors();
            Enumeration<ObjectVector> vecEnum2 = this.queryVecStore.getAllVectors();
            while (vecEnum.hasMoreElements()) {
                ObjectVector testElement = vecEnum.nextElement();
                ObjectVector testElement2 = vecEnum2.nextElement();
                double score1 = this.getScore(testElement.getVector());
                score2 = this.getScore2(testElement2.getVector());
                double score = Math.max(score1, score2);
                if (this.specialLuceneUtils != null && this.specialFlagConfig.usetermweightsintermsearch()) {
                    score *= (double)this.specialLuceneUtils.getGlobalTermWeightFromString((String)testElement.getObject());
                }
                if (this.specialFlagConfig.stdev()) {
                    System.out.println("STDEV");
                    ++count;
                    sum += score;
                    sumsquared += Math.pow(score, 2.0);
                }
                if (!(score > threshold)) continue;
                boolean added = false;
                for (int i = 0; i < results.size(); ++i) {
                    if (!(score > results.get(i).getScore()) || added) continue;
                    results.add(i, new SearchResult(score, testElement));
                    added = true;
                }
                if (results.size() > numResults) {
                    results.removeLast();
                    threshold = results.getLast().getScore();
                    continue;
                }
                if (added) continue;
                results.add(new SearchResult(score, testElement));
            }
            if (this.specialFlagConfig.stdev()) {
                results = this.transformToStats(results, count, sum, sumsquared);
            }
            return results;
        }

        @Override
        public double getScore(Vector testVector) {
            testVector.normalize();
            return this.oneDirection.measureOverlap(testVector);
        }

        public double getScore2(Vector testVector) {
            testVector.normalize();
            return this.otherDirection.measureOverlap(testVector);
        }
    }

    public static class AnalogySearcher
    extends VectorSearcher {
        Vector queryVector;

        public AnalogySearcher(VectorStore queryVecStore, VectorStore searchVecStore, LuceneUtils luceneUtils, FlagConfig flagConfig, String[] queryTriple) {
            super(queryVecStore, searchVecStore, luceneUtils, flagConfig);
            Vector term0 = CompoundVectorBuilder.getQueryVectorFromString(queryVecStore, luceneUtils, flagConfig, queryTriple[0]);
            Vector term1 = CompoundVectorBuilder.getQueryVectorFromString(queryVecStore, luceneUtils, flagConfig, queryTriple[1]);
            Vector term2 = CompoundVectorBuilder.getQueryVectorFromString(queryVecStore, luceneUtils, flagConfig, queryTriple[2]);
            Vector relationVec = term1.copy();
            relationVec.superpose(term0, -1.0, null);
            this.queryVector = term2.copy();
            relationVec.superpose(this.queryVector, 1.0, null);
            relationVec.normalize();
            this.queryVector = relationVec;
        }

        @Override
        public double getScore(Vector testVector) {
            return this.queryVector.measureOverlap(testVector);
        }
    }

    public static class VectorSearcherPerm
    extends VectorSearcher {
        Vector theAvg;

        public VectorSearcherPerm(VectorStore queryVecStore, VectorStore searchVecStore, LuceneUtils luceneUtils, FlagConfig flagConfig, String[] queryTerms) throws IllegalArgumentException, ZeroVectorException {
            super(queryVecStore, searchVecStore, luceneUtils, flagConfig);
            try {
                this.theAvg = CompoundVectorBuilder.getPermutedQueryVector(queryVecStore, luceneUtils, flagConfig, queryTerms);
            }
            catch (IllegalArgumentException e) {
                logger.info("Couldn't create permutation VectorSearcher ...");
                throw e;
            }
            if (this.theAvg.isZeroVector()) {
                throw new ZeroVectorException("Permutation query vector is zero ... no results.");
            }
        }

        public VectorSearcherPerm(VectorStore queryVecStore, VectorStore searchVecStore, VectorStore permutationCache, LuceneUtils luceneUtils, FlagConfig flagConfig, String[] queryTerms) throws IllegalArgumentException, ZeroVectorException {
            super(queryVecStore, searchVecStore, luceneUtils, flagConfig);
            try {
                String[] permStrings = queryTerms[1].split(":");
                Vector toSuperpose = queryVecStore.getVector(queryTerms[0]).copy();
                for (String permString : permStrings) {
                    this.theAvg = VectorFactory.createZeroVector(flagConfig.vectortype(), flagConfig.dimension());
                    int[] thePermutation = ((PermutationVector)permutationCache.getVector(permString)).getCoordinates();
                    this.theAvg.superpose(toSuperpose, 1.0, thePermutation);
                    toSuperpose = this.theAvg.copy();
                }
            }
            catch (IllegalArgumentException e) {
                logger.info("Couldn't create permutation VectorSearcher ...");
                throw e;
            }
            if (this.theAvg.isZeroVector()) {
                throw new ZeroVectorException("Permutation query vector is zero ... no results.");
            }
        }

        @Override
        public double getScore(Vector testVector) {
            return this.theAvg.measureOverlap(testVector);
        }
    }

    public static class VectorSearcherMinSim
    extends VectorSearcher {
        private ArrayList<Vector> disjunctVectors = new ArrayList();

        public VectorSearcherMinSim(VectorStore queryVecStore, VectorStore searchVecStore, LuceneUtils luceneUtils, FlagConfig flagConfig, String[] queryTerms) throws ZeroVectorException {
            super(queryVecStore, searchVecStore, luceneUtils, flagConfig);
            for (int i = 0; i < queryTerms.length; ++i) {
                String[] tmpTerms = queryTerms[i].split("\\s");
                Vector tmpVector = CompoundVectorBuilder.getQueryVector(queryVecStore, luceneUtils, flagConfig, tmpTerms);
                if (tmpVector == null) continue;
                this.disjunctVectors.add(tmpVector);
            }
            if (this.disjunctVectors.size() == 0) {
                throw new ZeroVectorException("No nonzero input vectors ... no results.");
            }
        }

        public VectorSearcherMinSim(VectorStore queryVecStore, VectorStore searchVecStore, LuceneUtils luceneUtils, FlagConfig flagConfig, Vector[] queryTerms) throws ZeroVectorException {
            super(queryVecStore, searchVecStore, luceneUtils, flagConfig);
            for (int i = 0; i < queryTerms.length; ++i) {
                Vector tmpVector = queryTerms[i];
                if (tmpVector == null) continue;
                this.disjunctVectors.add(tmpVector);
            }
            if (this.disjunctVectors.size() == 0) {
                throw new ZeroVectorException("No nonzero input vectors ... no results.");
            }
        }

        @Override
        public double getScore(Vector testVector) {
            double score = -1.0;
            double min_score = Double.MAX_VALUE;
            for (int i = 0; i < this.disjunctVectors.size(); ++i) {
                score = this.disjunctVectors.get(i).measureOverlap(testVector);
                if (!(score < min_score)) continue;
                min_score = score;
            }
            return min_score;
        }
    }

    public static class VectorSearcherMaxSim
    extends VectorSearcher {
        private ArrayList<Vector> disjunctVectors = new ArrayList();

        public VectorSearcherMaxSim(VectorStore queryVecStore, VectorStore searchVecStore, LuceneUtils luceneUtils, FlagConfig flagConfig, String[] queryTerms) throws ZeroVectorException {
            super(queryVecStore, searchVecStore, luceneUtils, flagConfig);
            for (int i = 0; i < queryTerms.length; ++i) {
                String[] tmpTerms = queryTerms[i].split("\\s");
                Vector tmpVector = CompoundVectorBuilder.getQueryVector(queryVecStore, luceneUtils, flagConfig, tmpTerms);
                if (tmpVector == null) continue;
                this.disjunctVectors.add(tmpVector);
            }
            if (this.disjunctVectors.size() == 0) {
                throw new ZeroVectorException("No nonzero input vectors ... no results.");
            }
        }

        public VectorSearcherMaxSim(VectorStore queryVecStore, VectorStore searchVecStore, LuceneUtils luceneUtils, FlagConfig flagConfig, Vector[] queryTerms) throws ZeroVectorException {
            super(queryVecStore, searchVecStore, luceneUtils, flagConfig);
            for (int i = 0; i < queryTerms.length; ++i) {
                Vector tmpVector = queryTerms[i];
                if (tmpVector == null) continue;
                this.disjunctVectors.add(tmpVector);
            }
            if (this.disjunctVectors.size() == 0) {
                throw new ZeroVectorException("No nonzero input vectors ... no results.");
            }
        }

        @Override
        public double getScore(Vector testVector) {
            double score = -1.0;
            double max_score = -1.0;
            for (int i = 0; i < this.disjunctVectors.size(); ++i) {
                score = this.disjunctVectors.get(i).measureOverlap(testVector);
                if (!(score > max_score)) continue;
                max_score = score;
            }
            return max_score;
        }
    }

    public static class VectorSearcherSubspaceSim
    extends VectorSearcher {
        private ArrayList<Vector> disjunctSpace = new ArrayList();
        private VectorType vectorType;

        public VectorSearcherSubspaceSim(VectorStore queryVecStore, VectorStore searchVecStore, LuceneUtils luceneUtils, FlagConfig flagConfig, String[] queryTerms) throws ZeroVectorException {
            super(queryVecStore, searchVecStore, luceneUtils, flagConfig);
            this.vectorType = flagConfig.vectortype();
            for (int i = 0; i < queryTerms.length; ++i) {
                System.out.println("\t" + queryTerms[i]);
                String[] tmpTerms = queryTerms[i].split("\\s");
                Vector tmpVector = CompoundVectorBuilder.getQueryVector(queryVecStore, luceneUtils, flagConfig, tmpTerms);
                if (tmpVector == null) continue;
                this.disjunctSpace.add(tmpVector);
            }
            if (this.disjunctSpace.size() == 0) {
                throw new ZeroVectorException("No nonzero input vectors ... no results.");
            }
            if (!this.vectorType.equals((Object)VectorType.BINARY)) {
                VectorUtils.orthogonalizeVectors(this.disjunctSpace);
            } else {
                BinaryVectorUtils.orthogonalizeVectors(this.disjunctSpace);
            }
        }

        @Override
        public double getScore(Vector testVector) {
            if (!this.vectorType.equals((Object)VectorType.BINARY)) {
                return VectorUtils.compareWithProjection(testVector, this.disjunctSpace);
            }
            return BinaryVectorUtils.compareWithProjection(testVector, this.disjunctSpace);
        }
    }

    public static class VectorSearcherIntersection
    extends VectorSearcher {
        private Vector intersection;

        public VectorSearcherIntersection(VectorStore elementalVecStore, VectorStore semanticVecStore, VectorStore predicateVecStore, VectorStore searchVecStore, LuceneUtils luceneUtils, FlagConfig flagConfig, String term1) throws ZeroVectorException {
            super(semanticVecStore, searchVecStore, luceneUtils, flagConfig);
            this.intersection = CompoundVectorBuilder.getBoundProductQueryIntersectionFromString(flagConfig, elementalVecStore, semanticVecStore, predicateVecStore, luceneUtils, term1);
        }

        @Override
        public double getScore(Vector testVector) {
            return this.intersection.measureOverlap(testVector);
        }
    }

    public static class VectorSearcherBoundMinimum
    extends VectorSearcher {
        private ArrayList<Vector> disjunctSpace;

        public VectorSearcherBoundMinimum(VectorStore queryVecStore, VectorStore boundVecStore, VectorStore searchVecStore, LuceneUtils luceneUtils, FlagConfig flagConfig, String term1, String term2) throws ZeroVectorException {
            super(queryVecStore, searchVecStore, luceneUtils, flagConfig);
            this.disjunctSpace = new ArrayList();
            Vector queryVector = queryVecStore.getVector(term1).copy();
            if (queryVector.isZeroVector()) {
                throw new ZeroVectorException("Query vector is zero ... no results.");
            }
            this.disjunctSpace = CompoundVectorBuilder.getBoundProductQuerySubSpaceFromString(flagConfig, boundVecStore, queryVector, term2);
        }

        public VectorSearcherBoundMinimum(VectorStore elementalVecStore, VectorStore semanticVecStore, VectorStore predicateVecStore, VectorStore searchVecStore, LuceneUtils luceneUtils, FlagConfig flagConfig, String term1) throws ZeroVectorException {
            super(semanticVecStore, searchVecStore, luceneUtils, flagConfig);
            this.disjunctSpace = CompoundVectorBuilder.getBoundProductQuerySubspaceFromString(flagConfig, elementalVecStore, semanticVecStore, predicateVecStore, term1);
        }

        public VectorSearcherBoundMinimum(VectorStore queryVecStore, VectorStore boundVecStore, VectorStore searchVecStore, LuceneUtils luceneUtils, FlagConfig flagConfig, ArrayList<Vector> incomingDisjunctSpace) throws ZeroVectorException {
            super(queryVecStore, searchVecStore, luceneUtils, flagConfig);
            this.disjunctSpace = incomingDisjunctSpace;
        }

        @Override
        public double getScore(Vector testVector) {
            double score = 0.0;
            for (int q = 0; q < this.disjunctSpace.size(); q += 2) {
                try {
                    if (q + 1 >= this.disjunctSpace.size()) {
                        score = Math.max(testVector.measureOverlap(this.disjunctSpace.get(q)), score);
                        continue;
                    }
                    score = Math.max(Math.min(testVector.measureOverlap(this.disjunctSpace.get(q)), testVector.measureOverlap(this.disjunctSpace.get(q + 1))), score);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return score;
        }
    }

    public static class VectorSearcherBoundProductSubSpace
    extends VectorSearcher {
        private ArrayList<Vector> disjunctSpace;

        public VectorSearcherBoundProductSubSpace(VectorStore queryVecStore, VectorStore boundVecStore, VectorStore searchVecStore, LuceneUtils luceneUtils, FlagConfig flagConfig, String term1, String term2) throws ZeroVectorException {
            super(queryVecStore, searchVecStore, luceneUtils, flagConfig);
            this.disjunctSpace = new ArrayList();
            Vector queryVector = queryVecStore.getVector(term1).copy();
            if (queryVector.isZeroVector()) {
                throw new ZeroVectorException("Query vector is zero ... no results.");
            }
            this.disjunctSpace = CompoundVectorBuilder.getBoundProductQuerySubSpaceFromString(flagConfig, boundVecStore, queryVector, term2);
        }

        public VectorSearcherBoundProductSubSpace(VectorStore elementalVecStore, VectorStore semanticVecStore, VectorStore predicateVecStore, VectorStore searchVecStore, LuceneUtils luceneUtils, FlagConfig flagConfig, String term1) throws ZeroVectorException {
            super(semanticVecStore, searchVecStore, luceneUtils, flagConfig);
            this.disjunctSpace = new ArrayList();
            this.disjunctSpace = CompoundVectorBuilder.getBoundProductQuerySubspaceFromString(flagConfig, elementalVecStore, semanticVecStore, predicateVecStore, term1);
        }

        public VectorSearcherBoundProductSubSpace(VectorStore queryVecStore, VectorStore boundVecStore, VectorStore searchVecStore, LuceneUtils luceneUtils, FlagConfig flagConfig, ArrayList<Vector> incomingDisjunctSpace) throws ZeroVectorException {
            super(queryVecStore, searchVecStore, luceneUtils, flagConfig);
            this.disjunctSpace = incomingDisjunctSpace;
        }

        @Override
        public double getScore(Vector testVector) {
            return VectorUtils.compareWithProjection(testVector, this.disjunctSpace);
        }
    }

    public static class VectorSearcherBoundProduct
    extends VectorSearcher {
        Vector queryVector;

        public VectorSearcherBoundProduct(VectorStore queryVecStore, VectorStore boundVecStore, VectorStore searchVecStore, LuceneUtils luceneUtils, FlagConfig flagConfig, String term1, String term2) throws ZeroVectorException {
            super(queryVecStore, searchVecStore, luceneUtils, flagConfig);
            this.queryVector = CompoundVectorBuilder.getQueryVectorFromString(queryVecStore, null, flagConfig, term1);
            this.queryVector.release(CompoundVectorBuilder.getBoundProductQueryVectorFromString(flagConfig, boundVecStore, term2));
            if (this.queryVector.isZeroVector()) {
                throw new ZeroVectorException("Query vector is zero ... no results.");
            }
        }

        public VectorSearcherBoundProduct(VectorStore elementalVecStore, VectorStore semanticVecStore, VectorStore predicateVecStore, VectorStore searchVecStore, LuceneUtils luceneUtils, FlagConfig flagConfig, String term1) throws ZeroVectorException {
            super(semanticVecStore, searchVecStore, luceneUtils, flagConfig);
            this.queryVector = CompoundVectorBuilder.getBoundProductQueryVectorFromString(flagConfig, elementalVecStore, semanticVecStore, predicateVecStore, luceneUtils, term1);
            if (this.queryVector.isZeroVector()) {
                throw new ZeroVectorException("Query vector is zero ... no results.");
            }
        }

        public VectorSearcherBoundProduct(VectorStore queryVecStore, VectorStore boundVecStore, VectorStore searchVecStore, LuceneUtils luceneUtils, FlagConfig flagConfig, ArrayList<Vector> incomingVectors) throws ZeroVectorException {
            super(queryVecStore, searchVecStore, luceneUtils, flagConfig);
            Vector theSuperposition = VectorFactory.createZeroVector(flagConfig.vectortype(), flagConfig.dimension());
            for (int q = 0; q < incomingVectors.size(); ++q) {
                theSuperposition.superpose(incomingVectors.get(q), 1.0, null);
            }
            theSuperposition.normalize();
            this.queryVector = theSuperposition;
            if (this.queryVector.isZeroVector()) {
                throw new ZeroVectorException("Query vector is zero ... no results.");
            }
        }

        public VectorSearcherBoundProduct(VectorStore queryVecStore, VectorStore searchVecStore, LuceneUtils luceneUtils, FlagConfig flagConfig, Vector queryVector) throws ZeroVectorException {
            super(queryVecStore, searchVecStore, luceneUtils, flagConfig);
            this.queryVector = queryVector;
            Vector testVector = searchVecStore.getAllVectors().nextElement().getVector();
            IncompatibleVectorsException.checkVectorsCompatible(queryVector, testVector);
            if (this.queryVector.isZeroVector()) {
                throw new ZeroVectorException("Query vector is zero ... no results.");
            }
        }

        @Override
        public double getScore(Vector testVector) {
            return this.queryVector.measureOverlap(testVector);
        }
    }

    public static class VectorSearcherCosine
    extends VectorSearcher {
        Vector queryVector;

        public VectorSearcherCosine(VectorStore queryVecStore, VectorStore searchVecStore, LuceneUtils luceneUtils, FlagConfig flagConfig, String[] queryTerms) throws ZeroVectorException {
            super(queryVecStore, searchVecStore, luceneUtils, flagConfig);
            this.queryVector = CompoundVectorBuilder.getQueryVector(queryVecStore, luceneUtils, flagConfig, queryTerms);
            if (this.queryVector.isZeroVector()) {
                throw new ZeroVectorException("Query vector is zero ... no results.");
            }
        }

        public VectorSearcherCosine(VectorStore queryVecStore, VectorStore searchVecStore, LuceneUtils luceneUtils, FlagConfig flagConfig, Vector queryVector) throws ZeroVectorException {
            super(queryVecStore, searchVecStore, luceneUtils, flagConfig);
            this.queryVector = queryVector;
            Vector testVector = searchVecStore.getAllVectors().nextElement().getVector();
            IncompatibleVectorsException.checkVectorsCompatible(queryVector, testVector);
            if (this.queryVector.isZeroVector()) {
                throw new ZeroVectorException("Query vector is zero ... no results.");
            }
        }

        @Override
        public LinkedList<SearchResult> getNearestNeighbors(int numResults) {
            if (this.flagConfig.lsh_hashes_num() == this.flagConfig.lsh_max_bits_diff()) {
                return super.getNearestNeighbors(numResults);
            }
            if (!(this.searchVecStore instanceof VectorStoreReaderLucene)) {
                return super.getNearestNeighbors(numResults);
            }
            logger.fine("Getting vector candidates from vector cache");
            Enumeration<ObjectVector> vecs = null;
            try {
                vecs = LSHStoreFactory.INSTANCE.getStore(((VectorStoreReaderLucene)this.searchVecStore).getVectorFile(), this.flagConfig).getSimilar(this.queryVector);
            }
            catch (IOException e) {
                logger.severe(e.getMessage());
                return null;
            }
            return super.getNearest(numResults, vecs);
        }

        @Override
        public double getScore(Vector testVector) {
            return this.queryVector.measureOverlap(testVector);
        }
    }

    public static class VectorSearcherPlain
    extends VectorSearcher {
        Vector queryVector;

        public VectorSearcherPlain(VectorStore searchVecStore, Vector queryVector, FlagConfig flagConfig) {
            super(searchVecStore, searchVecStore, null, flagConfig);
            this.queryVector = queryVector;
        }

        @Override
        public double getScore(Vector testVector) {
            return this.queryVector.measureOverlap(testVector);
        }
    }
}

