/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors;

import java.util.Objects;
import pitt.search.semanticvectors.ObjectVector;
import pitt.search.semanticvectors.utils.StringUtils;

public class SearchResult
implements Comparable<SearchResult> {
    private ObjectVector objectVector;
    private double score;

    public double getScore() {
        return this.score;
    }

    public void set(double score, ObjectVector object) {
        this.score = score;
        this.objectVector = object;
    }

    public ObjectVector getObjectVector() {
        return this.objectVector;
    }

    public SearchResult(double score, ObjectVector object) {
        this.set(score, object);
    }

    @Override
    public int compareTo(SearchResult otherSearchResult) {
        if (this.getScore() > otherSearchResult.getScore()) {
            return -1;
        }
        if (this.getScore() < otherSearchResult.getScore()) {
            return 1;
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchResult result = (SearchResult)o;
        return Double.compare(result.score, this.score) == 0 && Objects.equals(this.objectVector, result.objectVector);
    }

    public int hashCode() {
        return Objects.hash(this.objectVector, this.score);
    }

    public String toTexTableString(int pad) {
        return String.format("%s%s&  %.3f", this.getObjectVector().getObject(), StringUtils.nSpaces(pad - this.getObjectVector().getObject().toString().length()), this.getScore());
    }

    public String toTrecString(int trecevalNumber, int cnt) {
        return String.format("%s\t%s\t%s\t%s\t%f\t%s", trecevalNumber, "Q0", this.getObjectVector().getObject().toString(), cnt, this.getScore(), "DEFAULT");
    }

    public String toSimpleString() {
        return String.format("%f:%s", this.getScore(), this.getObjectVector().getObject().toString());
    }
}

