/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors;

import java.util.Enumeration;
import java.util.Random;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.ObjectVector;
import pitt.search.semanticvectors.VectorStore;
import pitt.search.semanticvectors.VectorStoreDeterministic;
import pitt.search.semanticvectors.VectorStoreOrthographical;
import pitt.search.semanticvectors.VectorStoreRAM;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorFactory;

public class ElementalVectorStore
implements VectorStore {
    private Random random;
    private final FlagConfig flagConfig;
    private VectorStore backingStore;

    public ElementalVectorStore(FlagConfig flagConfig) {
        this.flagConfig = flagConfig;
        switch (flagConfig.elementalmethod()) {
            case RANDOM: {
                this.backingStore = new VectorStoreRAM(flagConfig);
                this.random = new Random();
                break;
            }
            case CONTENTHASH: {
                this.backingStore = new VectorStoreDeterministic(flagConfig);
                break;
            }
            case ORTHOGRAPHIC: {
                this.backingStore = new VectorStoreOrthographical(flagConfig);
            }
        }
    }

    @Override
    public Vector getVector(Object term) {
        switch (this.flagConfig.elementalmethod()) {
            case RANDOM: {
                Vector vector = this.backingStore.getVector(term);
                if (vector == null) {
                    vector = VectorFactory.generateRandomVector(this.flagConfig.vectortype(), this.flagConfig.dimension(), this.flagConfig.seedlength(), this.random);
                    VectorStoreRAM ramCache = (VectorStoreRAM)this.backingStore;
                    ramCache.putVector(term, vector);
                }
                return vector;
            }
            case CONTENTHASH: 
            case ORTHOGRAPHIC: {
                return this.backingStore.getVector(term);
            }
        }
        throw new IllegalStateException("Not a recognized generation method: '" + (Object)((Object)this.flagConfig.elementalmethod()) + "'");
    }

    @Override
    public Enumeration<ObjectVector> getAllVectors() {
        return this.backingStore.getAllVectors();
    }

    @Override
    public int getNumVectors() {
        return this.backingStore.getNumVectors();
    }

    @Override
    public boolean containsVector(Object object) {
        return this.backingStore.containsVector(object);
    }

    public static enum ElementalGenerationMethod {
        RANDOM,
        CONTENTHASH,
        ORTHOGRAPHIC;

    }
}

