/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.netlib.blas.BLAS;
import pitt.search.semanticvectors.ElementalVectorStore;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.LuceneUtils;
import pitt.search.semanticvectors.ObjectVector;
import pitt.search.semanticvectors.VectorStore;
import pitt.search.semanticvectors.VectorStoreRAM;
import pitt.search.semanticvectors.VectorStoreWriter;
import pitt.search.semanticvectors.utils.Bobcat;
import pitt.search.semanticvectors.utils.SigmoidTable;
import pitt.search.semanticvectors.utils.VerbatimLogger;
import pitt.search.semanticvectors.vectors.BinaryVector;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorFactory;
import pitt.search.semanticvectors.vectors.VectorType;
import pitt.search.semanticvectors.vectors.VectorUtils;

public class ESP {
    private static final int MAX_EXP = 6;
    private static final Logger logger = Logger.getLogger(ESP.class.getCanonicalName());
    private FlagConfig flagConfig;
    private VectorStore elementalItemVectors;
    private VectorStore elementalPredicateVectors;
    private VectorStoreRAM semanticItemVectors;
    private static final String SUBJECT_FIELD = "subject";
    private static final String PREDICATE_FIELD = "predicate";
    private static final String OBJECT_FIELD = "object";
    private static final String PREDICATION_FIELD = "predication";
    private String[] itemFields = new String[]{"subject", "object"};
    private int tc = 0;
    private double initial_alpha = 0.025;
    private double alpha = 0.025;
    private double min_alpha = 1.0E-4;
    private SigmoidTable sigmoidTable = new SigmoidTable(6, 1000);
    private ConcurrentHashMap<String, ConcurrentSkipListMap<Double, String>> termDic;
    private ConcurrentHashMap<String, Double> totalPool;
    private LuceneUtils luceneUtils;
    private HashSet<String> addedConcepts;
    private static Random random;
    private AtomicInteger dc = new AtomicInteger(0);
    private AtomicInteger pc = new AtomicInteger(0);
    private ConcurrentLinkedQueue<Document> theQ = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Integer> randomStartpoints = new ConcurrentLinkedQueue();
    private ConcurrentHashMap<String, String> semtypes = new ConcurrentHashMap();
    private HashMap<Object, String> cuis = new HashMap();
    private ConcurrentHashMap<String, Double> subsamplingProbabilities;

    private ESP(FlagConfig flagConfig) {
    }

    public static void createIncrementalESPVectors(FlagConfig flagConfig) throws IOException {
        ESP incrementalESPVectors = new ESP(flagConfig);
        random = new Random();
        incrementalESPVectors.flagConfig = flagConfig;
        incrementalESPVectors.initialize();
        VerbatimLogger.info("Performing first round of ESP training ...");
        incrementalESPVectors.trainIncrementalESPVectors();
        VerbatimLogger.info("Done with createIncrementalESPVectors.");
    }

    private void initialize() throws IOException {
        BytesRef bytes;
        String[] initialVectorFiles;
        if (this.luceneUtils == null) {
            this.luceneUtils = new LuceneUtils(this.flagConfig);
        }
        this.elementalItemVectors = new ElementalVectorStore(this.flagConfig);
        this.semanticItemVectors = new VectorStoreRAM(this.flagConfig);
        if (!this.flagConfig.initialtermvectors().isEmpty() && (initialVectorFiles = this.flagConfig.initialtermvectors().split(",")).length == 2) {
            this.elementalItemVectors = new VectorStoreRAM(this.flagConfig);
            ((VectorStoreRAM)this.elementalItemVectors).initFromFile(initialVectorFiles[0]);
            this.semanticItemVectors.initFromFile(initialVectorFiles[1]);
            VerbatimLogger.info("Initialized elemental vectors from " + initialVectorFiles[0] + "\n");
            VerbatimLogger.info("Initialized semantic vectors from " + initialVectorFiles[1] + "\n");
        }
        this.elementalPredicateVectors = new ElementalVectorStore(this.flagConfig);
        this.flagConfig.setContentsfields(this.itemFields);
        this.termDic = new ConcurrentHashMap();
        this.totalPool = new ConcurrentHashMap();
        this.addedConcepts = new HashSet();
        int termCounter = 0;
        for (String fieldName : this.itemFields) {
            BytesRef bytes2;
            Terms terms = this.luceneUtils.getTermsForField(fieldName);
            if (terms == null) {
                throw new NullPointerException(String.format("No terms for field '%s'. Please check that index at '%s' was built correctly for use with ESP.", fieldName, this.flagConfig.luceneindexpath()));
            }
            TermsEnum termsEnum = terms.iterator();
            while ((bytes2 = termsEnum.next()) != null) {
                Term term = new Term(fieldName, bytes2);
                if (!this.luceneUtils.termFilter(term)) {
                    VerbatimLogger.fine("Filtering out term: " + term + "\n");
                    continue;
                }
                if (this.addedConcepts.contains(term.text())) continue;
                this.addedConcepts.add(term.text());
                if (!this.elementalItemVectors.containsVector(term.text())) {
                    if (this.flagConfig.initialtermvectors().isEmpty()) {
                        this.elementalItemVectors.getVector(term.text());
                    } else {
                        if (this.flagConfig.elementalmethod().equals((Object)ElementalVectorStore.ElementalGenerationMethod.CONTENTHASH)) {
                            random.setSeed(Bobcat.asLong(term.text()));
                        }
                        ((VectorStoreRAM)this.elementalItemVectors).putVector(term.text(), VectorFactory.generateRandomVector(this.flagConfig.vectortype(), this.flagConfig.dimension(), this.flagConfig.seedlength(), random));
                    }
                }
                String semtype = "";
                if (this.flagConfig.elementalmethod().equals((Object)ElementalVectorStore.ElementalGenerationMethod.CONTENTHASH)) {
                    random.setSeed(Bobcat.asLong("_SEMANTIC_" + term.text()));
                }
                if (this.flagConfig.semtypesandcuis()) {
                    PostingsEnum docEnum = this.luceneUtils.getDocsForTerm(term);
                    docEnum.nextDoc();
                    Document theDoc = this.luceneUtils.getDoc(docEnum.docID());
                    if (term.field().equals(SUBJECT_FIELD)) {
                        semtype = theDoc.get("subject_semtype");
                    } else if (term.field().equals(OBJECT_FIELD)) {
                        semtype = theDoc.get("object_semtype");
                    }
                    this.semtypes.put(term.text(), semtype);
                    String cui = "";
                    if (term.field().equals(SUBJECT_FIELD)) {
                        cui = theDoc.get("subject_CUI");
                    } else if (term.field().equals(OBJECT_FIELD)) {
                        cui = theDoc.get("object_CUI");
                    }
                    this.cuis.put(term.text(), cui);
                    if (!this.semanticItemVectors.containsVector(term.text())) {
                        this.semanticItemVectors.putVector(term.text(), VectorFactory.generateRandomVector(this.flagConfig.vectortype(), this.flagConfig.dimension(), this.flagConfig.seedlength(), random));
                    }
                } else {
                    if (!this.semanticItemVectors.containsVector(term.text())) {
                        this.semanticItemVectors.putVector(term.text(), VectorFactory.generateRandomVector(this.flagConfig.vectortype(), this.flagConfig.dimension(), this.flagConfig.seedlength(), random));
                    }
                    semtype = "universal";
                }
                if (!this.termDic.containsKey(semtype)) {
                    this.totalPool.put(semtype, 0.0);
                    this.termDic.put(semtype, new ConcurrentSkipListMap());
                }
                this.totalPool.put(semtype, this.totalPool.get(semtype) + Math.pow(this.luceneUtils.getGlobalTermFreq(term), 0.75));
                this.termDic.get(semtype).put(this.totalPool.get(semtype), term.text());
                if (++termCounter <= 0 || termCounter % 10000 != 0 && (termCounter >= 10000 || termCounter % 1000 != 0)) continue;
                VerbatimLogger.info("Initialized " + termCounter + " term vectors ... ");
            }
        }
        int predCounter = 0;
        Terms predicateTerms = this.luceneUtils.getTermsForField(PREDICATE_FIELD);
        String[] dummyArray = new String[]{PREDICATE_FIELD};
        TermsEnum termsEnum = predicateTerms.iterator();
        while ((bytes = termsEnum.next()) != null) {
            Term term = new Term(PREDICATE_FIELD, bytes);
            if (!this.luceneUtils.termFilter(term, dummyArray, 0, Integer.MAX_VALUE, Integer.MAX_VALUE, 1) || this.flagConfig.mutablepredicatevectors() && !this.luceneUtils.termFilter(term, dummyArray, this.flagConfig.minfrequency(), this.flagConfig.maxfrequency(), Integer.MAX_VALUE, 1)) continue;
            this.elementalPredicateVectors.getVector(term.text().trim());
            this.elementalPredicateVectors.getVector(term.text().trim() + "-INV");
            if (++predCounter <= 0 || predCounter % 10000 != 0 && (predCounter >= 10000 || predCounter % 1000 != 0)) continue;
            VerbatimLogger.info("Initialized " + predCounter + " predicate vectors ... ");
        }
        if (this.flagConfig.samplingthreshold() > -1.0 && this.flagConfig.samplingthreshold() < 1.0) {
            this.subsamplingProbabilities = new ConcurrentHashMap();
            double totalConceptCount = this.luceneUtils.getNumDocs() * 2;
            VerbatimLogger.info("Populating subsampling probabilities - total concept count = " + totalConceptCount + " which is " + totalConceptCount / (double)this.luceneUtils.getNumDocs() + " per doc on average");
            int count = 0;
            for (String termName : this.addedConcepts) {
                double obFreq;
                double subFreq;
                double globalFreq;
                if (termName == null) break;
                if (++count % 10000 == 0) {
                    VerbatimLogger.info(".");
                }
                if (!this.semanticItemVectors.containsVector(termName) || !((globalFreq = ((subFreq = (double)this.luceneUtils.getGlobalDocFreq(new Term(SUBJECT_FIELD, termName.toString()))) + (obFreq = (double)this.luceneUtils.getGlobalDocFreq(new Term(OBJECT_FIELD, termName.toString())))) / totalConceptCount) > this.flagConfig.samplingthreshold())) continue;
                double discount = 1.0;
                this.subsamplingProbabilities.put(termName.toString(), discount - Math.sqrt(this.flagConfig.samplingthreshold() / globalFreq));
            }
            VerbatimLogger.info("\n");
            if (this.subsamplingProbabilities != null && this.subsamplingProbabilities.size() > 0) {
                VerbatimLogger.info("Selected for subsampling: " + this.subsamplingProbabilities.size() + " terms.\n");
            }
        }
    }

    public double sigmoid(double z) {
        return this.sigmoidTable.sigmoid(z);
    }

    public double shiftAway(Vector v1, Vector v2, FlagConfig flagConfig, BLAS blas) {
        if (!flagConfig.vectortype().equals((Object)VectorType.BINARY)) {
            return -this.sigmoid(VectorUtils.scalarProduct(v1, v2, flagConfig, blas));
        }
        return -100.0 * Math.max(VectorUtils.scalarProduct(v1, v2, flagConfig, blas), 0.0);
    }

    public double shiftToward(Vector v1, Vector v2, FlagConfig flagConfig, BLAS blas) {
        if (!flagConfig.vectortype().equals((Object)VectorType.BINARY)) {
            return 1.0 - this.sigmoid(VectorUtils.scalarProduct(v1, v2, flagConfig, blas));
        }
        return 100.0 - 100.0 * Math.max(VectorUtils.scalarProduct(v1, v2, flagConfig, blas), 0.0);
    }

    private void processPredication(String subject, String predicate, String object, String subsem, String obsem, BLAS blas) {
        Vector subjectSemanticVector = this.semanticItemVectors.getVector(subject);
        Vector copyOfSubjectSemanticVector = this.semanticItemVectors.getVector(subject).copy();
        Vector objectElementalVector = this.elementalItemVectors.getVector(object);
        Vector elementalBoundProduct = this.elementalPredicateVectors.getVector(predicate).copy();
        Vector predicateElementalVector = this.elementalPredicateVectors.getVector(predicate);
        if (!this.flagConfig.semtypesandcuis()) {
            subsem = "universal";
            obsem = "universal";
        }
        ArrayList<Vector> objNegSamples = new ArrayList<Vector>();
        HashSet<String> duplicates = new HashSet<String>();
        while (objNegSamples.size() <= this.flagConfig.negsamples()) {
            Vector objectsNegativeSample = null;
            int ocnt = 0;
            while (objectsNegativeSample == null) {
                double test = random.nextDouble() * this.totalPool.get(obsem);
                if (this.termDic.get(obsem).ceilingEntry(test) == null) continue;
                String testConcept = this.termDic.get(obsem).ceilingEntry(test).getValue();
                if (++ocnt > 10 && this.flagConfig.semtypesandcuis()) {
                    test = random.nextDouble() * this.totalPool.get("dsyn");
                    testConcept = this.termDic.get("dsyn").ceilingEntry(test).getValue();
                }
                if (duplicates.contains(testConcept)) continue;
                duplicates.add(testConcept);
                if (testConcept.equals(object)) continue;
                objectsNegativeSample = this.elementalItemVectors.getVector(testConcept);
            }
            objNegSamples.add(objectsNegativeSample);
        }
        elementalBoundProduct.bind(objectElementalVector);
        copyOfSubjectSemanticVector.release(predicateElementalVector);
        Vector copyOfElementalVector = null;
        if (this.flagConfig.mutablepredicatevectors()) {
            copyOfElementalVector = objectElementalVector.copy();
            copyOfElementalVector.bind(subjectSemanticVector);
        }
        double shiftToward = this.shiftToward(subjectSemanticVector, elementalBoundProduct, this.flagConfig, blas);
        subjectSemanticVector.superpose(elementalBoundProduct, this.alpha * shiftToward, null);
        shiftToward = this.shiftToward(copyOfSubjectSemanticVector, objectElementalVector, this.flagConfig, blas);
        objectElementalVector.superpose(copyOfSubjectSemanticVector, this.alpha * shiftToward, null);
        if (this.flagConfig.mutablepredicatevectors()) {
            shiftToward = this.shiftToward(predicateElementalVector, copyOfElementalVector, this.flagConfig, blas);
            predicateElementalVector.superpose(copyOfElementalVector, this.alpha * shiftToward, null);
        }
        for (Vector objNegativeSample : objNegSamples) {
            Vector negativeElementalBoundProduct = this.elementalPredicateVectors.getVector(predicate).copy();
            negativeElementalBoundProduct.bind(objNegativeSample);
            Vector boundArguments = null;
            if (this.flagConfig.mutablepredicatevectors()) {
                boundArguments = objNegativeSample.copy();
                boundArguments.bind(subjectSemanticVector);
            }
            double shiftAway = this.shiftAway(subjectSemanticVector, negativeElementalBoundProduct, this.flagConfig, blas);
            subjectSemanticVector.superpose(negativeElementalBoundProduct, this.alpha * shiftAway, null);
            shiftAway = this.shiftAway(copyOfSubjectSemanticVector, objNegativeSample, this.flagConfig, blas);
            objNegativeSample.superpose(copyOfSubjectSemanticVector, this.alpha * shiftAway, null);
            if (!this.flagConfig.mutablepredicatevectors()) continue;
            shiftAway = this.shiftAway(predicateElementalVector, boundArguments, this.flagConfig, blas);
            predicateElementalVector.superpose(boundArguments, this.alpha * shiftAway, null);
        }
    }

    private void processPredicationDocument(Document document, BLAS blas) {
        int predCount;
        double predFreq;
        String subject = document.get(SUBJECT_FIELD);
        String predicate = document.get(PREDICATE_FIELD);
        String object = document.get(OBJECT_FIELD);
        String predication = subject + predicate + object;
        String subsem = document.get("subject_semtype");
        String obsem = document.get("object_semtype");
        boolean encode = true;
        if (!(this.elementalItemVectors.containsVector(object) && this.elementalItemVectors.containsVector(subject) && this.elementalPredicateVectors.containsVector(predicate))) {
            logger.fine("skipping predication " + subject + " " + predicate + " " + object);
            encode = false;
        }
        if ((predFreq = (double)(predCount = this.luceneUtils.getGlobalTermFreq(new Term(PREDICATION_FIELD, predication))) / (double)this.luceneUtils.getNumDocs()) > this.flagConfig.samplingthreshold() * 0.01 && random.nextDouble() <= 1.0 - Math.sqrt(this.flagConfig.samplingthreshold() * 0.01) / predFreq) {
            encode = false;
        }
        if (this.subsamplingProbabilities != null && this.subsamplingProbabilities.contains(subject) && random.nextDouble() <= this.subsamplingProbabilities.get(subject)) {
            encode = false;
            logger.fine("skipping predication " + object + " " + predicate + "-INV " + subject);
        }
        if (this.subsamplingProbabilities != null && this.subsamplingProbabilities.contains(object) && random.nextDouble() <= this.subsamplingProbabilities.get(object)) {
            encode = false;
            logger.fine("skipping predication " + subject + " " + predicate + " " + object);
        }
        if (encode) {
            this.processPredication(subject, predicate, object, subsem, obsem, blas);
            this.processPredication(object, predicate + "-INV", subject, obsem, subsem, blas);
            this.pc.incrementAndGet();
        }
        if (this.pc.get() > 0 && this.pc.get() % 10000 == 0) {
            VerbatimLogger.info("Processed " + this.pc + " predications ... ");
            double progress = (double)(this.tc * this.luceneUtils.getNumDocs() + this.dc.get()) / ((double)this.luceneUtils.getNumDocs() * (double)(this.flagConfig.trainingcycles() + 1));
            VerbatimLogger.info(100.0 * progress + "% complete ...");
            this.alpha = Math.max(this.initial_alpha - (this.initial_alpha - this.min_alpha) * progress, this.min_alpha);
            VerbatimLogger.info("\nUpdated alpha to " + this.alpha + "..");
        }
    }

    private void initializeRandomizationStartpoints() {
        boolean remainder;
        this.randomStartpoints = new ConcurrentLinkedQueue();
        int increments = this.luceneUtils.getNumDocs() / 100000;
        boolean bl = remainder = this.luceneUtils.getNumDocs() % 100000 > 0;
        if (remainder) {
            ++increments;
        }
        ArrayList<Integer> toRandomize = new ArrayList<Integer>();
        for (int x = 0; x < increments; ++x) {
            toRandomize.add(x * 100000);
        }
        Collections.shuffle(toRandomize);
        this.randomStartpoints.addAll(toRandomize);
    }

    private synchronized int populateQueue() {
        if (this.dc.get() >= this.luceneUtils.getNumDocs()) {
            return -1;
        }
        if (this.theQ.size() > 100000) {
            return 0;
        }
        if (this.randomStartpoints.isEmpty()) {
            return -1;
        }
        int qb = this.randomStartpoints.poll();
        int qe = qb + 100000;
        int qplus = 0;
        for (int qc = qb; qc < qe && qc < this.luceneUtils.getNumDocs() && this.dc.get() < this.luceneUtils.getNumDocs() - 1; ++qc) {
            try {
                Document nextDoc = this.luceneUtils.getDoc(qc);
                this.dc.incrementAndGet();
                if (nextDoc == null) continue;
                this.theQ.add(nextDoc);
                ++qplus;
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        VerbatimLogger.info("Added " + qplus + " documents to queue, now carrying " + this.theQ.size());
        if (qplus == 0) {
            return -1;
        }
        return qplus;
    }

    private void trainIncrementalESPVectors() throws IOException {
        if (this.flagConfig.vectortype().equals((Object)VectorType.BINARY)) {
            this.initial_alpha = 0.25;
            this.alpha = 0.25;
            this.min_alpha = 0.001;
        }
        this.tc = 0;
        while (this.tc <= this.flagConfig.trainingcycles()) {
            this.initializeRandomizationStartpoints();
            this.theQ = new ConcurrentLinkedQueue();
            this.dc.set(0);
            this.populateQueue();
            double time = System.currentTimeMillis();
            int numthreads = this.flagConfig.numthreads();
            ExecutorService executor = Executors.newFixedThreadPool(numthreads);
            for (int q = 0; q < numthreads; ++q) {
                executor.execute(new TrainPredThread(q));
            }
            executor.shutdown();
            while (!executor.isTerminated()) {
                if (this.theQ.size() >= 50000) continue;
                this.populateQueue();
            }
            VerbatimLogger.info("Time for cycle " + this.tc + " : " + ((double)System.currentTimeMillis() - time) / 60000.0 + " minutes");
            VerbatimLogger.info("Processed " + this.pc.get() + " total predications (total on disk = " + this.luceneUtils.getNumDocs() + ")");
            if (!this.flagConfig.vectortype().equals((Object)VectorType.BINARY)) {
                Enumeration<ObjectVector> semanticVectorEnumeration = this.semanticItemVectors.getAllVectors();
                Enumeration<ObjectVector> elementalVectorEnumeration = this.elementalItemVectors.getAllVectors();
                while (semanticVectorEnumeration.hasMoreElements()) {
                    semanticVectorEnumeration.nextElement().getVector().normalize();
                    elementalVectorEnumeration.nextElement().getVector().normalize();
                }
            }
            ++this.tc;
        }
        Enumeration<ObjectVector> e = null;
        if (this.flagConfig.semtypesandcuis()) {
            File vectorFile = new File("cuivectors.bin");
            Files.deleteIfExists(vectorFile.toPath());
            String parentPath = vectorFile.getParent();
            if (parentPath == null) {
                parentPath = "";
            }
            FSDirectory fsDirectory = FSDirectory.open(FileSystems.getDefault().getPath(parentPath, new String[0]));
            IndexOutput outputStream = fsDirectory.createOutput(vectorFile.getName(), IOContext.DEFAULT);
            outputStream.writeString(VectorStoreWriter.generateHeaderString(this.flagConfig));
            e = this.semanticItemVectors.getAllVectors();
            while (e.hasMoreElements()) {
                ObjectVector ov = e.nextElement();
                if (this.flagConfig.vectortype().equals((Object)VectorType.BINARY)) {
                    ((BinaryVector)ov.getVector()).tallyVotes();
                } else {
                    ov.getVector().normalize();
                }
                if (!this.cuis.containsKey(ov.getObject())) continue;
                outputStream.writeString(this.cuis.get(ov.getObject()));
                ov.getVector().writeToLuceneStream(outputStream);
            }
            outputStream.close();
        } else {
            e = this.semanticItemVectors.getAllVectors();
            while (e.hasMoreElements()) {
                e.nextElement().getVector().normalize();
            }
        }
        e = this.elementalItemVectors.getAllVectors();
        while (e.hasMoreElements()) {
            e.nextElement().getVector().normalize();
        }
        if (this.flagConfig.mutablepredicatevectors()) {
            e = this.elementalPredicateVectors.getAllVectors();
            while (e.hasMoreElements()) {
                e.nextElement().getVector().normalize();
            }
        }
        VectorStoreWriter.writeVectors(this.flagConfig.elementalpredicatevectorfile(), this.flagConfig, this.elementalPredicateVectors);
        VectorStoreWriter.writeVectors(this.flagConfig.semanticvectorfile(), this.flagConfig, this.semanticItemVectors);
        VectorStoreWriter.writeVectors(this.flagConfig.elementalvectorfile(), this.flagConfig, this.elementalItemVectors);
        VectorStoreWriter.writeVectors(this.flagConfig.elementalpredicatevectorfile(), this.flagConfig, this.elementalPredicateVectors);
        VerbatimLogger.info("Finished writing semantic item and context vectors.\n");
    }

    public static void main(String[] args) throws IllegalArgumentException, IOException {
        FlagConfig flagConfig = FlagConfig.getFlagConfig(args);
        args = flagConfig.remainingArgs;
        if (flagConfig.luceneindexpath().isEmpty()) {
            throw new IllegalArgumentException("-luceneindexpath argument must be provided.");
        }
        VerbatimLogger.info("Building ESP model from index in: " + flagConfig.luceneindexpath() + "\n");
        VerbatimLogger.info("Minimum frequency = " + flagConfig.minfrequency() + "\n");
        VerbatimLogger.info("Maximum frequency = " + flagConfig.maxfrequency() + "\n");
        VerbatimLogger.info("Number non-alphabet characters = " + flagConfig.maxnonalphabetchars() + "\n");
        ESP.createIncrementalESPVectors(flagConfig);
    }

    private class TrainPredThread
    implements Runnable {
        BLAS blas = BLAS.getInstance();

        public TrainPredThread(int threadno) {
        }

        @Override
        public void run() {
            Document document = null;
            int complete = 0;
            while (complete != -1 || !ESP.this.theQ.isEmpty()) {
                document = (Document)ESP.this.theQ.poll();
                if (document == null) {
                    complete = ESP.this.populateQueue();
                    document = (Document)ESP.this.theQ.poll();
                }
                if (document == null) continue;
                ESP.this.processPredicationDocument(document, this.blas);
            }
        }
    }
}

