/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors;

import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Logger;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermsEnum;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.LuceneUtils;
import pitt.search.semanticvectors.ObjectVector;
import pitt.search.semanticvectors.VectorStore;
import pitt.search.semanticvectors.VectorStoreRAM;
import pitt.search.semanticvectors.utils.VerbatimLogger;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorFactory;
import pitt.search.semanticvectors.vectors.VectorType;

public class DocVectors
implements VectorStore {
    private static final Logger logger = Logger.getLogger(DocVectors.class.getCanonicalName());
    private FlagConfig flagConfig;
    private VectorStoreRAM docVectors;
    private VectorStore termVectors;
    private LuceneUtils luceneUtils;

    public VectorType getVectorType() {
        return this.flagConfig.vectortype();
    }

    public int getDimension() {
        return this.flagConfig.dimension();
    }

    public DocVectors(VectorStore termVectors, FlagConfig flagConfig, LuceneUtils luceneUtils) throws IOException {
        this.flagConfig = flagConfig;
        this.luceneUtils = luceneUtils;
        this.termVectors = termVectors;
        this.docVectors = new VectorStoreRAM(flagConfig);
        this.initializeZeroDocVectors();
        this.trainDocVectors();
    }

    private void trainDocVectors() throws IOException {
        VerbatimLogger.info("Building document vectors ... ");
        Enumeration<ObjectVector> termEnum = this.termVectors.getAllVectors();
        try {
            int tc = 0;
            while (termEnum.hasMoreElements()) {
                if (tc % 10000 == 0 || tc < 10000 && tc % 1000 == 0) {
                    VerbatimLogger.info("Processed " + tc + " terms ... ");
                }
                ++tc;
                ObjectVector termVectorObject = termEnum.nextElement();
                Vector termVector = termVectorObject.getVector();
                String word = (String)termVectorObject.getObject();
                for (String fieldName : this.flagConfig.contentsfields()) {
                    Term term = new Term(fieldName, word);
                    float globalweight = this.luceneUtils.getGlobalTermWeight(term);
                    float fieldweight = 1.0f;
                    PostingsEnum docsEnum = this.luceneUtils.getDocsForTerm(term);
                    if (docsEnum == null) continue;
                    while (docsEnum.nextDoc() != Integer.MAX_VALUE) {
                        String externalDocID = this.luceneUtils.getExternalDocId(docsEnum.docID());
                        Vector docVector = this.docVectors.getVector(externalDocID);
                        float localweight = docsEnum.freq();
                        if (this.flagConfig.fieldweight()) {
                            TermsEnum terms = this.luceneUtils.getTermVector(docsEnum.docID(), fieldName).iterator();
                            int numTerms = 0;
                            while (terms.next() != null) {
                                ++numTerms;
                            }
                            fieldweight = (float)(1.0 / Math.sqrt(numTerms));
                        }
                        docVector.superpose(termVector, localweight * globalweight * fieldweight, null);
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        VerbatimLogger.info("\nNormalizing doc vectors ...\n");
        Enumeration<ObjectVector> docEnum = this.docVectors.getAllVectors();
        while (docEnum.hasMoreElements()) {
            docEnum.nextElement().getVector().normalize();
        }
    }

    private void initializeZeroDocVectors() throws IOException {
        VerbatimLogger.info("Initializing new document vector store ... \n");
        for (int i = 0; i < this.luceneUtils.getNumDocs(); ++i) {
            String externalDocId = this.luceneUtils.getExternalDocId(i);
            Vector docVector = VectorFactory.createZeroVector(this.flagConfig.vectortype(), this.flagConfig.dimension());
            this.docVectors.putVector(externalDocId, docVector);
        }
    }

    public VectorStore makeWriteableVectorStore() {
        VectorStoreRAM outputVectors = new VectorStoreRAM(this.flagConfig);
        for (int i = 0; i < this.luceneUtils.getNumDocs(); ++i) {
            try {
                String externalDocId = this.luceneUtils.getExternalDocId(i);
                Vector docVector = this.docVectors.getVector(externalDocId);
                outputVectors.putVector(externalDocId, docVector);
                continue;
            }
            catch (CorruptIndexException e) {
                e.printStackTrace();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return outputVectors;
    }

    @Override
    public Vector getVector(Object id) {
        return this.docVectors.getVector(id);
    }

    @Override
    public Enumeration<ObjectVector> getAllVectors() {
        return this.docVectors.getAllVectors();
    }

    @Override
    public int getNumVectors() {
        return this.docVectors.getNumVectors();
    }

    @Override
    public boolean containsVector(Object object) {
        return this.getVector(object) != null;
    }

    public static enum DocIndexingStrategy {
        INMEMORY,
        INCREMENTAL,
        NONE;

    }
}

