/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors;

import java.util.ArrayList;
import java.util.Random;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorFactory;

public class CompressedVectorStoreRAM {
    private int maxVectors = 2000000;
    private Random random = new Random();
    private FlagConfig flagConfig;
    private Vector[] vectorTable;
    long[] observationCounts;
    long totalCounts;

    public CompressedVectorStoreRAM(FlagConfig flagConfig) {
        this.flagConfig = flagConfig;
        this.observationCounts = new long[this.maxVectors];
        this.vectorTable = new Vector[this.maxVectors];
    }

    public int getHashedKey(String originalKey) {
        int hashedKey = Math.abs(originalKey.hashCode()) % this.maxVectors;
        return hashedKey;
    }

    public Vector getVector(String desiredObject, boolean subSample) {
        Vector toBeAdded;
        int hashedKey;
        int n = hashedKey = this.getHashedKey(desiredObject);
        this.observationCounts[n] = this.observationCounts[n] + 1L;
        ++this.totalCounts;
        if (this.vectorTable[hashedKey] != null) {
            if (subSample) {
                double frequency = (double)this.observationCounts[hashedKey] / (double)this.totalCounts;
                double subsamp = Math.sqrt(this.flagConfig.samplingthreshold() / frequency);
                if (subsamp > 0.0 && this.random.nextDouble() <= subsamp) {
                    return null;
                }
            }
            return this.vectorTable[hashedKey];
        }
        this.vectorTable[hashedKey] = toBeAdded = VectorFactory.generateRandomVector(this.flagConfig.vectortype(), this.flagConfig.dimension(), this.flagConfig.seedlength, this.random);
        return toBeAdded;
    }

    public boolean containsVector(String object) {
        int hashedKey = this.getHashedKey(object);
        return this.vectorTable[hashedKey] != null;
    }

    public ArrayList<String> getComponentNgrams(String incomingString) {
        ArrayList<String> outgoingNgrams = new ArrayList<String>();
        String toDecompose = "<" + incomingString + ">";
        for (int ngram_length = 3; ngram_length <= 6; ++ngram_length) {
            for (int j = 0; j <= toDecompose.length() - ngram_length; ++j) {
                String toAdd = toDecompose.substring(j, j + ngram_length);
                if (toAdd.equals(toDecompose)) continue;
                outgoingNgrams.add(toAdd);
            }
        }
        return outgoingNgrams;
    }

    public static void main(String[] args) {
        FlagConfig flagConfig = FlagConfig.parseFlagsFromString("-dimension 100 -seedlength 100");
        CompressedVectorStoreRAM cvs = new CompressedVectorStoreRAM(flagConfig);
        double time = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            for (String subword : cvs.getComponentNgrams("incontrovertible")) {
                cvs.getHashedKey(subword);
            }
        }
        System.out.println((double)System.currentTimeMillis() - time);
    }
}

