/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;
import pitt.search.semanticvectors.CloseableVectorStore;
import pitt.search.semanticvectors.ClusterResults;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.ObjectVector;
import pitt.search.semanticvectors.VectorStoreReader;

public class ClusterVectorStore {
    private static final Logger logger = Logger.getLogger(ClusterVectorStore.class.getCanonicalName());
    public static final boolean writeCentroidsFile = false;
    public static final boolean measureClusterOverlaps = false;
    public static final int numRunsForOverlap = 1;

    public static void usage() {
        String message = "ClusterVectorStore class for clustering an entire (text) vector store.";
        message = message + "\nUsage: java.pitt.search.semanticvectors.ClusterVectorStore VECTORFILE";
        message = message + "\nUse --numclusters to change the number of clusters.";
        message = message + "\nDo not try this for large vector stores, it will not scale well!";
        System.out.println(message);
    }

    private static int getMaxValue(int[] values) {
        int max = values[0];
        for (int value : values) {
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    public static String[] getCluster(int ID, int[] clusterIDs, String[] names) {
        ArrayList<String> results = new ArrayList<String>();
        for (int i = 0; i < clusterIDs.length; ++i) {
            if (clusterIDs[i] != ID) continue;
            results.add(names[i]);
        }
        String[] finalResults = new String[results.size()];
        for (int i = 0; i < results.size(); ++i) {
            finalResults[i] = (String)results.get(i);
        }
        return finalResults;
    }

    public static Hashtable<String, int[]> clusterOverlapMeasure(int[] clusterIDs, ObjectVector[] vectors) {
        String[] names = new String[vectors.length];
        Hashtable<String, int[]> internalResults = new Hashtable<String, int[]>();
        for (int i = 0; i < vectors.length; ++i) {
            names[i] = new File(vectors[i].getObject().toString()).getParent();
            int[] matchAndTotal = new int[]{0, 0};
            internalResults.put(names[i], matchAndTotal);
        }
        int numClusters = ClusterVectorStore.getMaxValue(clusterIDs);
        for (int i = 0; i < numClusters; ++i) {
            String[] cluster = ClusterVectorStore.getCluster(i, clusterIDs, names);
            if (cluster.length < 2) continue;
            for (int j = 0; j < cluster.length; ++j) {
                for (int k = j + 1; k < cluster.length; ++k) {
                    int[] matchAndTotalJ = internalResults.get(cluster[j]);
                    int[] matchAndTotalK = internalResults.get(cluster[k]);
                    matchAndTotalJ[1] = matchAndTotalJ[1] + 1;
                    matchAndTotalK[1] = matchAndTotalK[1] + 1;
                    if (!cluster[k].equals(cluster[j])) continue;
                    matchAndTotalJ[0] = matchAndTotalJ[0] + 1;
                    matchAndTotalK[0] = matchAndTotalK[0] + 1;
                }
            }
        }
        return internalResults;
    }

    private static void mergeTables(Hashtable<String, int[]> newTable, Hashtable<String, int[]> mainTable) {
        for (String key : mainTable.keySet()) {
            int[] values = mainTable.get(key);
            int[] newValues = newTable.get(key);
            for (int i = 0; i < mainTable.get(key).length; ++i) {
                int n = i;
                values[n] = values[n] + newValues[i];
            }
        }
    }

    public static void main(String[] args) throws IllegalArgumentException {
        CloseableVectorStore vecReader;
        FlagConfig flagConfig = FlagConfig.getFlagConfig(args);
        args = flagConfig.remainingArgs;
        if (args.length != 1) {
            System.out.println("Wrong number of arguments.");
            ClusterVectorStore.usage();
            return;
        }
        try {
            vecReader = VectorStoreReader.openVectorStore(args[0], flagConfig);
        }
        catch (IOException e) {
            System.out.println("Failed to open vector store from file: '" + args[0] + "'");
            logger.info(e.getMessage());
            throw new IllegalArgumentException("Failed to parse arguments for ClusterVectorStore");
        }
        logger.info("Reading vectors into memory ...");
        int numVectors = vecReader.getNumVectors();
        ObjectVector[] resultsVectors = new ObjectVector[numVectors];
        Enumeration<ObjectVector> vecEnum = vecReader.getAllVectors();
        int offset = 0;
        while (vecEnum.hasMoreElements()) {
            resultsVectors[offset] = vecEnum.nextElement();
            ++offset;
        }
        vecReader.close();
        Object mainOverlapResults = null;
        for (int runNumber = 0; runNumber < 1; ++runNumber) {
            logger.info("Clustering vectors ...");
            ClusterResults.Clusters clusters = ClusterResults.kMeansCluster(resultsVectors, flagConfig);
            ClusterVectorStore.printAllCusters(flagConfig, resultsVectors, clusters);
        }
    }

    private static void printAllCusters(FlagConfig flagConfig, ObjectVector[] resultsVectors, ClusterResults.Clusters clusters) {
        for (int i = 0; i < flagConfig.numclusters(); ++i) {
            System.out.println("Cluster " + i);
            for (int j = 0; j < clusters.clusterMappings.length; ++j) {
                if (clusters.clusterMappings[j] != i) continue;
                System.out.print(resultsVectors[j].getObject() + "\t");
            }
            System.out.println("\n*********\n");
        }
    }
}

