/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors;

import java.io.IOException;
import java.util.Random;
import java.util.logging.Logger;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.ObjectVector;
import pitt.search.semanticvectors.Search;
import pitt.search.semanticvectors.VectorStoreRAM;
import pitt.search.semanticvectors.VectorStoreWriter;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorFactory;
import pitt.search.semanticvectors.vectors.VectorUtils;

public class ClusterResults {
    private static final Logger logger = Logger.getLogger(ClusterResults.class.getCanonicalName());
    public static String usageMessage = "ClusterResults class in package pitt.search.semanticvectors\nUsage: java pitt.search.semanticvectors.ClusterResults\n                        -numsearchresults [number of search results]\n                        -numclusters [number of clusters]\n                        <SEARCH ARGS>\nwhere SEARCH ARGS is an expression passed to Search class.";

    public static Clusters kMeansCluster(ObjectVector[] objectVectors, FlagConfig flagConfig) {
        boolean changeFlag;
        int i;
        Clusters clusters = new Clusters();
        clusters.clusterMappings = new int[objectVectors.length];
        clusters.centroids = new Vector[flagConfig.numclusters()];
        Random rand = new Random();
        logger.info("Initializing clusters ...");
        for (i = 0; i < objectVectors.length; ++i) {
            int randInt = rand.nextInt();
            while (randInt == Integer.MIN_VALUE) {
                randInt = rand.nextInt();
            }
            clusters.clusterMappings[i] = Math.abs(randInt) % flagConfig.numclusters();
        }
        logger.info("Iterating k-means assignment ...");
        do {
            for (i = 0; i < clusters.centroids.length; ++i) {
                clusters.centroids[i] = VectorFactory.createZeroVector(flagConfig.vectortype(), flagConfig.dimension());
            }
            for (i = 0; i < objectVectors.length; ++i) {
                clusters.centroids[clusters.clusterMappings[i]].superpose(objectVectors[i].getVector(), 1.0, null);
            }
            for (i = 0; i < flagConfig.numclusters(); ++i) {
                clusters.centroids[i].normalize();
            }
            changeFlag = false;
            for (int i2 = 0; i2 < objectVectors.length; ++i2) {
                int j = VectorUtils.getNearestVector(objectVectors[i2].getVector(), clusters.centroids);
                if (j == clusters.clusterMappings[i2]) continue;
                changeFlag = true;
                clusters.clusterMappings[i2] = j;
            }
        } while (changeFlag);
        logger.info("Got to stable clusters ...");
        return clusters;
    }

    public static void usage() {
        System.err.println(usageMessage);
    }

    public static void writeCentroidsToFile(Clusters clusters, FlagConfig flagConfig) {
        VectorStoreRAM centroidsOutput = new VectorStoreRAM(flagConfig);
        for (int i = 0; i < clusters.centroids.length; ++i) {
            centroidsOutput.putVector(Integer.toString(i), clusters.centroids[i]);
        }
        try {
            VectorStoreWriter.writeVectors("cluster_centroids.bin", flagConfig, centroidsOutput);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IllegalArgumentException {
        FlagConfig flagConfig = FlagConfig.getFlagConfig(args);
        args = flagConfig.remainingArgs;
        ObjectVector[] resultsVectors = Search.getSearchResultVectors(flagConfig);
        Clusters clusters = ClusterResults.kMeansCluster(resultsVectors, flagConfig);
        for (int i = 0; i < flagConfig.numclusters(); ++i) {
            System.out.println("Cluster " + i);
            for (int j = 0; j < clusters.clusterMappings.length; ++j) {
                if (clusters.clusterMappings[j] != i) continue;
                System.out.print(resultsVectors[j].getObject() + " ");
            }
            System.out.println();
        }
        ClusterResults.writeCentroidsToFile(clusters, flagConfig);
    }

    public static class Clusters {
        public int[] clusterMappings = null;
        public Vector[] centroids = null;
    }
}

