/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import pitt.search.semanticvectors.DocVectors;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.IncrementalDocVectors;
import pitt.search.semanticvectors.IncrementalTermVectors;
import pitt.search.semanticvectors.LuceneUtils;
import pitt.search.semanticvectors.TermVectorsFromLucene;
import pitt.search.semanticvectors.VectorStore;
import pitt.search.semanticvectors.VectorStoreRAM;
import pitt.search.semanticvectors.VectorStoreUtils;
import pitt.search.semanticvectors.VectorStoreWriter;
import pitt.search.semanticvectors.utils.VerbatimLogger;

public class BuildIndex {
    public static Logger logger = Logger.getLogger("pitt.search.semanticvectors");
    public static String usageMessage = "\nBuildIndex class in package pitt.search.semanticvectors\nUsage: java pitt.search.semanticvectors.BuildIndex -luceneindexpath PATH_TO_LUCENE_INDEX\nBuildIndex creates termvectors and docvectors files in local directory.\nOther parameters that can be changed include number of dimensions, vector type (real, binary or complex), seed length (number of non-zero entries in basic vectors), minimum term frequency, max. number of non-alphabetical characters per term, filtering of numeric terms (i.e. numbers), and number of iterative training cycles.\nTo change these use the command line arguments \n  -vectortype [real, complex or binary]\n  -dimension [number of dimension]\n  -seedlength [seed length]\n  -minfrequency [minimum term frequency]\n  -maxnonalphabetchars [number non-alphabet characters (-1 for any number)]\n  -filternumbers [true or false]\n  -trainingcycles [training cycles]\n  -docindexing [incremental|inmemory|none] Switch between building doc vectors incrementally\n        (requires positional index), all in memory (default case), or not at all";

    public static void main(String[] args) throws IllegalArgumentException, IOException {
        FlagConfig flagConfig;
        try {
            flagConfig = FlagConfig.getFlagConfig(args);
        }
        catch (IllegalArgumentException e) {
            System.err.println(usageMessage);
            throw e;
        }
        BuildIndex.buildIndex(flagConfig, new AtomicBoolean());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean buildIndex(FlagConfig flagConfig, AtomicBoolean isCreationInterruptedByUser) throws IOException {
        if (flagConfig.luceneindexpath().isEmpty()) {
            throw new IllegalArgumentException("-luceneindexpath must be set.");
        }
        VerbatimLogger.info("Seedlength: " + flagConfig.seedlength() + ", Dimension: " + flagConfig.dimension() + ", Vector type: " + (Object)((Object)flagConfig.vectortype()) + ", Minimum frequency: " + flagConfig.minfrequency() + ", Maximum frequency: " + flagConfig.maxfrequency() + ", Number non-alphabet characters: " + flagConfig.maxnonalphabetchars() + ", Contents fields are: " + Arrays.toString(flagConfig.contentsfields()) + "\n");
        String termFile = flagConfig.termvectorsfile();
        String docFile = flagConfig.docvectorsfile();
        LuceneUtils luceneUtils = new LuceneUtils(flagConfig);
        try {
            TermVectorsFromLucene termVectorIndexer;
            if (!flagConfig.initialtermvectors().isEmpty()) {
                VerbatimLogger.info("Creating elemental term vectors ... \n");
                termVectorIndexer = TermVectorsFromLucene.createTermBasedRRIVectors(flagConfig);
            } else {
                VectorStoreRAM initialDocVectors = null;
                if (!flagConfig.initialdocumentvectors().isEmpty()) {
                    VerbatimLogger.info(String.format("Loading initial document vectors from file: '%s'.\n", flagConfig.initialdocumentvectors()));
                    initialDocVectors = VectorStoreRAM.readFromFile(flagConfig, flagConfig.initialdocumentvectors());
                    VerbatimLogger.info(String.format("Loaded %d document vectors to use as elemental vectors.\n", initialDocVectors.getNumVectors()));
                }
                VerbatimLogger.info("Creating term vectors as superpositions of elemental document vectors ... \n");
                termVectorIndexer = TermVectorsFromLucene.createTermVectorsFromLucene(flagConfig, initialDocVectors, isCreationInterruptedByUser);
            }
            VerbatimLogger.info("Writing term vectors to " + termFile + "\n");
            VectorStoreWriter.writeVectors(termFile, flagConfig, termVectorIndexer.getSemanticTermVectors());
            switch (flagConfig.docindexing()) {
                case INCREMENTAL: {
                    IncrementalDocVectors.createIncrementalDocVectors(termVectorIndexer.getSemanticTermVectors(), flagConfig, luceneUtils, isCreationInterruptedByUser);
                    for (int i = 1; i < flagConfig.trainingcycles(); ++i) {
                        IncrementalTermVectors itermVectors = new IncrementalTermVectors(flagConfig, luceneUtils);
                        VectorStoreWriter.writeVectors(VectorStoreUtils.getStoreFileName(flagConfig.termvectorsfile() + flagConfig.trainingcycles(), flagConfig), flagConfig, itermVectors);
                        IncrementalDocVectors.createIncrementalDocVectors(itermVectors, flagConfig, luceneUtils, isCreationInterruptedByUser);
                    }
                    if (flagConfig.trainingcycles() <= 0) return true;
                    VectorStoreUtils.renameTrainedVectorsFile(flagConfig.termvectorsfile(), flagConfig);
                    VectorStoreUtils.renameEntityMapVectorsFile(flagConfig.termvectorsfile(), flagConfig);
                    return true;
                }
                case INMEMORY: {
                    DocVectors docVectors = new DocVectors(termVectorIndexer.getSemanticTermVectors(), flagConfig, luceneUtils);
                    for (int i = 1; i < flagConfig.trainingcycles(); ++i) {
                        VerbatimLogger.info("\nRetraining with learned document vectors ...");
                        termVectorIndexer = TermVectorsFromLucene.createTermVectorsFromLucene(flagConfig, docVectors, isCreationInterruptedByUser);
                        docVectors = new DocVectors(termVectorIndexer.getSemanticTermVectors(), flagConfig, luceneUtils);
                    }
                    VectorStoreWriter.writeVectors(VectorStoreUtils.getStoreFileName(flagConfig.termvectorsfile() + flagConfig.trainingcycles(), flagConfig), flagConfig, termVectorIndexer.getSemanticTermVectors());
                    if (flagConfig.trainingcycles() > 0) {
                        VectorStoreUtils.renameTrainedVectorsFile(flagConfig.termvectorsfile(), flagConfig);
                        VectorStoreUtils.renameEntityMapVectorsFile(flagConfig.termvectorsfile(), flagConfig);
                    }
                    VectorStore writeableDocVectors = docVectors.makeWriteableVectorStore();
                    VerbatimLogger.info("Writing doc vectors to " + docFile + "\n");
                    VectorStoreWriter.writeVectors(docFile, flagConfig, writeableDocVectors);
                    return true;
                }
                case NONE: {
                    return true;
                }
                default: {
                    throw new IllegalStateException("No procedure defined for -docindexing " + (Object)((Object)flagConfig.docindexing()));
                }
            }
        }
        catch (IOException e) {
            logger.warning(e.getMessage());
            throw e;
        }
        finally {
            luceneUtils.closeLuceneDir();
        }
    }
}

