/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import pitt.search.semanticvectors.DocVectors;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.LuceneUtils;
import pitt.search.semanticvectors.TermVectorsFromLucene;
import pitt.search.semanticvectors.VectorStore;
import pitt.search.semanticvectors.VectorStoreWriter;
import pitt.search.semanticvectors.utils.VerbatimLogger;

public class BuildBilingualIndex {
    public static Logger logger = Logger.getLogger("pitt.search.semanticvectors.BuildBilingualIndex");
    private static final String usageMessage = "\nBuildBilingualIndex class in package pitt.search.semanticvectors\nUsage: java pitt.search.semanticvectors.BuildBilingualIndex [args] -luceneindexpath PATH_TO_LUCENE_INDEX LANG1 LANG2.\nBuildBilingualIndex creates files termvectors_LANGn.bin and docvectors_LANGn.bin,\nin local directory, where LANG1 and LANG2 are obtained from fields in index.";

    public static void usage() {
        System.out.println(usageMessage);
    }

    public static void main(String[] args) throws IllegalArgumentException {
        FlagConfig flagConfig;
        String[] argsWithDocIdField = new String[2 + args.length];
        argsWithDocIdField[0] = "-docidfield";
        argsWithDocIdField[1] = "filename";
        System.arraycopy(args, 0, argsWithDocIdField, 2, args.length);
        try {
            flagConfig = FlagConfig.getFlagConfig(argsWithDocIdField);
        }
        catch (IllegalArgumentException e) {
            BuildBilingualIndex.usage();
            throw e;
        }
        if (!flagConfig.docidfield().equals("filename")) {
            logger.log(Level.WARNING, "Docid field is normally 'filename' for bilingual indexes. Are you sure you wanted to change this?");
        }
        if (flagConfig.remainingArgs.length != 2) {
            BuildBilingualIndex.usage();
            throw new IllegalArgumentException("After parsing command line flags, there were " + flagConfig.remainingArgs.length + " arguments, instead of the expected 2.");
        }
        String lang1 = args[args.length - 2];
        String lang2 = args[args.length - 1];
        String termFile1 = "termvectors_" + lang1 + ".bin";
        String termFile2 = "termvectors_" + lang2 + ".bin";
        String docFile1 = "docvectors_" + lang1 + ".bin";
        String docFile2 = "docvectors_" + lang2 + ".bin";
        String[] argsWithDocIdAndContentsField = new String[2 + argsWithDocIdField.length];
        System.arraycopy(argsWithDocIdField, 0, argsWithDocIdAndContentsField, 2, argsWithDocIdField.length);
        argsWithDocIdAndContentsField[0] = "-contentsfields";
        argsWithDocIdAndContentsField[1] = "contents_" + lang1;
        FlagConfig actualConfigLang1 = FlagConfig.getFlagConfig(argsWithDocIdAndContentsField);
        argsWithDocIdAndContentsField[1] = "contents_" + lang2;
        FlagConfig actualConfigLang2 = FlagConfig.getFlagConfig(argsWithDocIdAndContentsField);
        VerbatimLogger.info("Creating bilingual indexes ...");
        try {
            TermVectorsFromLucene termIndexer1 = TermVectorsFromLucene.createTermVectorsFromLucene(actualConfigLang1, null);
            logger.info("Writing term vectors to " + termFile1);
            VectorStoreWriter.writeVectors(termFile1, actualConfigLang1, termIndexer1.getSemanticTermVectors());
            DocVectors docVectors = new DocVectors(termIndexer1.getSemanticTermVectors(), actualConfigLang1, new LuceneUtils(actualConfigLang1));
            logger.info("Writing doc vectors to " + docFile1);
            VectorStoreWriter.writeVectors(docFile1, actualConfigLang1, docVectors.makeWriteableVectorStore());
            VectorStore basicDocVectors = termIndexer1.getElementalDocVectors();
            System.out.println("Keeping basic doc vectors, number: " + basicDocVectors.getNumVectors());
            TermVectorsFromLucene termIndexer2 = TermVectorsFromLucene.createTermVectorsFromLucene(actualConfigLang2, basicDocVectors);
            logger.info("Writing term vectors to " + termFile2);
            VectorStoreWriter.writeVectors(termFile2, actualConfigLang2, termIndexer2.getSemanticTermVectors());
            docVectors = new DocVectors(termIndexer2.getSemanticTermVectors(), actualConfigLang2, new LuceneUtils(actualConfigLang2));
            logger.info("Writing doc vectors to " + docFile2);
            VectorStoreWriter.writeVectors(docFile2, actualConfigLang2, docVectors.makeWriteableVectorStore());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

