/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.lucene;

import java.nio.file.FileSystems;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.FSDirectory;

public class LuceneSearch {
    public static final int MAX_RESULTS = 20;

    public static void usage() {
        System.out.println("Lucene Search Wrapper");
        System.out.println("Usage: java pitt.search.lucene.LuceneWrapper [-i path_to_index] [-f lucene_field] query terms ...");
        System.out.println("If no index given, defaults to directory './index'");
        System.out.println("The field argument may be used for searching bilingual indexes,e.g., -f contents_en or -field contents_fr");
        System.exit(0);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            LuceneSearch.usage();
        }
        IndexSearcher searcher = null;
        String luceneIndex = "index";
        String luceneField = "contents";
        int argc = 0;
        int startIndex = 0;
        int maxPage = 10;
        int thisPage = 0;
        boolean error = false;
        if (args[argc].equals("-i")) {
            luceneIndex = args[argc + 1];
            argc += 2;
        }
        if (args[argc].equals("-f")) {
            luceneField = args[argc + 1];
            argc += 2;
        }
        String queryString = "";
        for (int i = argc; i < args.length; ++i) {
            queryString = queryString + args[i] + " ";
        }
        try {
            searcher = new IndexSearcher(DirectoryReader.open(FSDirectory.open(FileSystems.getDefault().getPath(luceneIndex, new String[0]))));
        }
        catch (Exception e) {
            System.err.println("Error opening index at: '" + luceneIndex + "'");
            e.printStackTrace();
            error = true;
        }
        StandardAnalyzer analyzer = new StandardAnalyzer();
        Query query = null;
        TopDocs hits = null;
        try {
            QueryParser qp = new QueryParser(luceneField, analyzer);
            query = qp.parse(queryString);
        }
        catch (ParseException e) {
            System.err.println("Error when parsing query ...");
            e.printStackTrace();
            error = true;
        }
        if (!error && searcher != null) {
            thisPage = maxPage;
            try {
                hits = searcher.search(query, 20);
            }
            catch (Exception e) {
                System.err.println("Error when searching ...");
                e.printStackTrace();
                error = true;
            }
            if (hits.totalHits == 0) {
                System.out.println("<p> I'm sorry, there were no Lucene results. </p>");
                error = true;
            }
        }
        if (hits != null && startIndex + maxPage > hits.totalHits) {
            thisPage = hits.totalHits - startIndex;
        }
        for (int i = startIndex; i < thisPage + startIndex; ++i) {
            try {
                float score = hits.scoreDocs[i].score;
                Document doc = searcher.doc(hits.scoreDocs[i].doc);
                String title = doc.get("title");
                String filename = doc.get("path");
                if (filename == null) {
                    filename = doc.get("filename");
                }
                System.out.println("Document:" + filename);
                System.out.println("Score:" + score);
                if (title == null) continue;
                System.out.println("Title:" + title);
                continue;
            }
            catch (Exception e) {
                System.err.println("Error while getting data from search results ...");
            }
        }
    }
}

