/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.lucene;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.FSDirectory;

public class IndexBilingualFiles {
    static Path INDEX_DIR = FileSystems.getDefault().getPath("bilingual_index", new String[0]);
    String LANGUAGE1;
    String LANGUAGE2;

    public IndexBilingualFiles(String lang1, String lang2) {
        this.LANGUAGE1 = lang1;
        this.LANGUAGE2 = lang2;
    }

    private void runIndexer() {
        if (Files.exists(INDEX_DIR, new LinkOption[0])) {
            throw new IllegalArgumentException("Cannot save index to '" + INDEX_DIR + "' directory, please delete it first");
        }
        Date start = new Date();
        try {
            File docDir1 = new File(this.LANGUAGE1);
            File docDir2 = new File(this.LANGUAGE2);
            IndexWriterConfig writerConfig = new IndexWriterConfig(new StandardAnalyzer());
            IndexWriter writer = new IndexWriter(FSDirectory.open(INDEX_DIR), writerConfig);
            System.out.println("Indexing to directory '" + INDEX_DIR + "'...");
            this.runDeepIndexer(docDir1, docDir2, writer);
            System.out.println("Optimizing...");
            writer.close();
            Date end = new Date();
            System.out.println(end.getTime() - start.getTime() + " total milliseconds");
        }
        catch (IOException e) {
            System.out.println(" caught a " + e.getClass() + "\n with message: " + e.getMessage());
        }
    }

    private void runDeepIndexer(File docDir1, File docDir2, IndexWriter writer) {
        if (!docDir1.exists()) {
            System.out.println("Test directory exists failed: " + docDir1);
            System.exit(1);
            if (!docDir1.canRead()) {
                System.out.println("Test readable failed: " + docDir1);
                System.exit(1);
                if (!docDir1.isDirectory()) {
                    System.out.println("Test is directory failed: " + docDir1);
                    System.exit(1);
                }
            }
        }
        if (!docDir2.exists()) {
            System.out.println("Test directory exists failed: " + docDir2);
            System.exit(1);
            if (!docDir2.canRead()) {
                System.out.println("Test readable failed: " + docDir2);
                System.exit(1);
                if (!docDir2.isDirectory()) {
                    System.out.println("Test is directory failed: " + docDir2);
                    System.exit(1);
                }
            }
        }
        System.err.println("Trying to index files in directories:\n" + docDir1.getAbsolutePath() + "\n" + docDir2.getAbsolutePath());
        String[] files1 = docDir1.list();
        String[] files2 = docDir2.list();
        if (!IndexBilingualFiles.checkStringArraysEqual(files1, files2)) {
            System.err.println("Contents of directories don't match up; not creating bilingual index.\nPlease check corpora contents, clean up your data, and try again.");
        }
        for (int i = 0; i < files1.length; ++i) {
            System.out.println("adding " + files1[i]);
            File newFile1 = new File(docDir1 + "/" + files1[i]);
            File newFile2 = new File(docDir2 + "/" + files1[i]);
            if (newFile1.isDirectory() && newFile2.isDirectory()) {
                this.runDeepIndexer(newFile1, newFile2, writer);
            }
            try {
                writer.addDocument(this.fileBilingualDocument(newFile1, newFile2));
                continue;
            }
            catch (IOException e) {
                System.err.println("Got exception with filepair: " + files1[i]);
                e.printStackTrace();
            }
        }
    }

    protected Document fileBilingualDocument(File file1, File file2) throws IOException {
        Document doc = new Document();
        doc.add(new StoredField("filename", file1.getPath()));
        doc.add(new TextField("contents_" + this.LANGUAGE1, new FileReader(file1)));
        doc.add(new TextField("contents_" + this.LANGUAGE2, new FileReader(file2)));
        return doc;
    }

    static boolean checkStringArraysEqual(String[] array1, String[] array2) {
        if (array1.length != array2.length) {
            System.err.println("checkStringArraysEqual: arrays are of different lengths!");
            return false;
        }
        if (array1.length == 0) {
            System.err.println("checkStringArraysEqual: arrays are empty!");
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i].equals(array2[i])) continue;
            System.err.println("checkStringArraysEqual: following pairs differ: " + array1[i] + " " + array2[i]);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        String usage = "java pitt.search.preporcessing.IndexBilingualFiles <directory1> <directory2>";
        if (args.length != 2) {
            System.err.println("Usage: " + usage);
            System.exit(1);
        }
        IndexBilingualFiles indexer = new IndexBilingualFiles(args[0], args[1]);
        indexer.runIndexer();
    }
}

