/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.lucene;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexOptions;

public class FilePositionDoc {
    public static Document Document(File f) throws FileNotFoundException {
        Document doc = new Document();
        doc.add(new StoredField("path", f.getPath()));
        doc.add(new StoredField("modified", DateTools.timeToString(f.lastModified(), DateTools.Resolution.MINUTE)));
        FieldType ft = new FieldType();
        ft.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS);
        ft.setTokenized(true);
        ft.setStoreTermVectors(true);
        ft.setStoreTermVectorPositions(true);
        Field contentsField = new Field("contents", new FileReader(f), ft);
        doc.add(contentsField);
        return doc;
    }

    public static Document Document(String inLine, int lineNumber) {
        Document doc = new Document();
        doc.add(new StoredField("line_number", "" + lineNumber));
        doc.add(new StoredField("modified", DateTools.timeToString(System.currentTimeMillis(), DateTools.Resolution.MINUTE)));
        FieldType ft = new FieldType();
        ft.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS);
        ft.setTokenized(true);
        ft.setStoreTermVectors(true);
        ft.setStoreTermVectorPositions(true);
        Field contentsField = new Field("contents", inLine, ft);
        doc.add(contentsField);
        return doc;
    }
}

