/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.codecs.simpletext.SimpleTextBKDReader;
import org.apache.lucene.codecs.simpletext.SimpleTextPointsWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.StringHelper;

class SimpleTextPointsReader
extends PointsReader {
    private final IndexInput dataIn;
    final SegmentReadState readState;
    final Map<String, SimpleTextBKDReader> readers;
    final BytesRefBuilder scratch;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SimpleTextPointsReader(SegmentReadState readState) throws IOException {
        block18: {
            this.readers = new HashMap<String, SimpleTextBKDReader>();
            this.scratch = new BytesRefBuilder();
            HashMap<String, Long> fieldToFileOffset = new HashMap<String, Long>();
            String indexFileName = IndexFileNames.segmentFileName(readState.segmentInfo.name, readState.segmentSuffix, "dii");
            try (ChecksumIndexInput in = readState.directory.openChecksumInput(indexFileName, IOContext.DEFAULT);){
                this.readLine(in);
                int count = this.parseInt(SimpleTextPointsWriter.FIELD_COUNT);
                for (int i = 0; i < count; ++i) {
                    this.readLine(in);
                    String fieldName = this.stripPrefix(SimpleTextPointsWriter.FIELD_FP_NAME);
                    this.readLine(in);
                    long fp = this.parseLong(SimpleTextPointsWriter.FIELD_FP);
                    fieldToFileOffset.put(fieldName, fp);
                }
                SimpleTextUtil.checkFooter(in);
            }
            boolean success = false;
            String fileName = IndexFileNames.segmentFileName(readState.segmentInfo.name, readState.segmentSuffix, "dim");
            this.dataIn = readState.directory.openInput(fileName, IOContext.DEFAULT);
            try {
                for (Map.Entry ent : fieldToFileOffset.entrySet()) {
                    this.readers.put((String)ent.getKey(), this.initReader((Long)ent.getValue()));
                }
                success = true;
                if (success) break block18;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(this);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(this);
        }
        this.readState = readState;
    }

    private SimpleTextBKDReader initReader(long fp) throws IOException {
        this.dataIn.seek(fp);
        this.readLine(this.dataIn);
        int numDims = this.parseInt(SimpleTextPointsWriter.NUM_DIMS);
        this.readLine(this.dataIn);
        int bytesPerDim = this.parseInt(SimpleTextPointsWriter.BYTES_PER_DIM);
        this.readLine(this.dataIn);
        int maxPointsInLeafNode = this.parseInt(SimpleTextPointsWriter.MAX_LEAF_POINTS);
        this.readLine(this.dataIn);
        int count = this.parseInt(SimpleTextPointsWriter.INDEX_COUNT);
        this.readLine(this.dataIn);
        assert (this.startsWith(SimpleTextPointsWriter.MIN_VALUE));
        BytesRef minValue = SimpleTextUtil.fromBytesRefString(this.stripPrefix(SimpleTextPointsWriter.MIN_VALUE));
        assert (minValue.length == numDims * bytesPerDim);
        this.readLine(this.dataIn);
        assert (this.startsWith(SimpleTextPointsWriter.MAX_VALUE));
        BytesRef maxValue = SimpleTextUtil.fromBytesRefString(this.stripPrefix(SimpleTextPointsWriter.MAX_VALUE));
        assert (maxValue.length == numDims * bytesPerDim);
        this.readLine(this.dataIn);
        assert (this.startsWith(SimpleTextPointsWriter.POINT_COUNT));
        long pointCount = this.parseLong(SimpleTextPointsWriter.POINT_COUNT);
        this.readLine(this.dataIn);
        assert (this.startsWith(SimpleTextPointsWriter.DOC_COUNT));
        int docCount = this.parseInt(SimpleTextPointsWriter.DOC_COUNT);
        long[] leafBlockFPs = new long[count];
        for (int i = 0; i < count; ++i) {
            this.readLine(this.dataIn);
            leafBlockFPs[i] = this.parseLong(SimpleTextPointsWriter.BLOCK_FP);
        }
        this.readLine(this.dataIn);
        count = this.parseInt(SimpleTextPointsWriter.SPLIT_COUNT);
        int bytesPerIndexEntry = numDims == 1 ? bytesPerDim : 1 + bytesPerDim;
        byte[] splitPackedValues = new byte[count * bytesPerIndexEntry];
        for (int i = 0; i < count; ++i) {
            this.readLine(this.dataIn);
            int address = bytesPerIndexEntry * i;
            int splitDim = this.parseInt(SimpleTextPointsWriter.SPLIT_DIM);
            if (numDims != 1) {
                splitPackedValues[address++] = (byte)splitDim;
            }
            this.readLine(this.dataIn);
            assert (this.startsWith(SimpleTextPointsWriter.SPLIT_VALUE));
            BytesRef br = SimpleTextUtil.fromBytesRefString(this.stripPrefix(SimpleTextPointsWriter.SPLIT_VALUE));
            assert (br.length == bytesPerDim);
            System.arraycopy(br.bytes, br.offset, splitPackedValues, address, bytesPerDim);
        }
        return new SimpleTextBKDReader(this.dataIn, numDims, maxPointsInLeafNode, bytesPerDim, leafBlockFPs, splitPackedValues, minValue.bytes, maxValue.bytes, pointCount, docCount);
    }

    private void readLine(IndexInput in) throws IOException {
        SimpleTextUtil.readLine(in, this.scratch);
    }

    private boolean startsWith(BytesRef prefix) {
        return StringHelper.startsWith(this.scratch.get(), prefix);
    }

    private int parseInt(BytesRef prefix) {
        assert (this.startsWith(prefix));
        return Integer.parseInt(this.stripPrefix(prefix));
    }

    private long parseLong(BytesRef prefix) {
        assert (this.startsWith(prefix));
        return Long.parseLong(this.stripPrefix(prefix));
    }

    private String stripPrefix(BytesRef prefix) {
        return new String(this.scratch.bytes(), prefix.length, this.scratch.length() - prefix.length, StandardCharsets.UTF_8);
    }

    private SimpleTextBKDReader getBKDReader(String fieldName) {
        FieldInfo fieldInfo = this.readState.fieldInfos.fieldInfo(fieldName);
        if (fieldInfo == null) {
            throw new IllegalArgumentException("field=\"" + fieldName + "\" is unrecognized");
        }
        if (fieldInfo.getPointDimensionCount() == 0) {
            throw new IllegalArgumentException("field=\"" + fieldName + "\" did not index points");
        }
        return this.readers.get(fieldName);
    }

    @Override
    public void intersect(String fieldName, PointValues.IntersectVisitor visitor) throws IOException {
        SimpleTextBKDReader bkdReader = this.getBKDReader(fieldName);
        if (bkdReader == null) {
            return;
        }
        bkdReader.intersect(visitor);
    }

    @Override
    public long estimatePointCount(String fieldName, PointValues.IntersectVisitor visitor) {
        SimpleTextBKDReader bkdReader = this.getBKDReader(fieldName);
        if (bkdReader == null) {
            return 0L;
        }
        return bkdReader.estimatePointCount(visitor);
    }

    @Override
    public void checkIntegrity() throws IOException {
        BytesRefBuilder scratch = new BytesRefBuilder();
        IndexInput clone = this.dataIn.clone();
        clone.seek(0L);
        long footerStartPos = this.dataIn.length() - (long)(SimpleTextUtil.CHECKSUM.length + 21);
        BufferedChecksumIndexInput input = new BufferedChecksumIndexInput(clone);
        do {
            SimpleTextUtil.readLine(input, scratch);
        } while (((IndexInput)input).getFilePointer() < footerStartPos);
        if (((IndexInput)input).getFilePointer() != footerStartPos) {
            throw new CorruptIndexException("SimpleText failure: footer does not start at expected position current=" + ((IndexInput)input).getFilePointer() + " vs expected=" + footerStartPos, input);
        }
        SimpleTextUtil.checkFooter(input);
    }

    @Override
    public long ramBytesUsed() {
        return 0L;
    }

    @Override
    public void close() throws IOException {
        this.dataIn.close();
    }

    public String toString() {
        return "SimpleTextPointsReader(segment=" + this.readState.segmentInfo.name + " maxDoc=" + this.readState.segmentInfo.maxDoc() + ")";
    }

    @Override
    public byte[] getMinPackedValue(String fieldName) {
        SimpleTextBKDReader bkdReader = this.getBKDReader(fieldName);
        if (bkdReader == null) {
            return null;
        }
        return bkdReader.getMinPackedValue();
    }

    @Override
    public byte[] getMaxPackedValue(String fieldName) {
        SimpleTextBKDReader bkdReader = this.getBKDReader(fieldName);
        if (bkdReader == null) {
            return null;
        }
        return bkdReader.getMaxPackedValue();
    }

    @Override
    public int getNumDimensions(String fieldName) {
        SimpleTextBKDReader bkdReader = this.getBKDReader(fieldName);
        if (bkdReader == null) {
            return 0;
        }
        return bkdReader.getNumDimensions();
    }

    @Override
    public int getBytesPerDimension(String fieldName) {
        SimpleTextBKDReader bkdReader = this.getBKDReader(fieldName);
        if (bkdReader == null) {
            return 0;
        }
        return bkdReader.getBytesPerDimension();
    }

    @Override
    public long size(String fieldName) {
        SimpleTextBKDReader bkdReader = this.getBKDReader(fieldName);
        if (bkdReader == null) {
            return 0L;
        }
        return bkdReader.getPointCount();
    }

    @Override
    public int getDocCount(String fieldName) {
        SimpleTextBKDReader bkdReader = this.getBKDReader(fieldName);
        if (bkdReader == null) {
            return 0;
        }
        return bkdReader.getDocCount();
    }
}

